/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostLinkTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostSearchLinkTable;

class HostSetSQLOps
extends HostSetImplTable {
    public static final HostSetSQLOps DEFAULT = new HostSetSQLOps();

    public HostSetSQLOps(String alias) {
        super(alias);
    }

    private HostSetSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new HostSetSQLOps(alias);
    }

    public ConditionalExpression isName(String name) {
        return HostSetSQLOps.equals(this.Name, name);
    }

    public OrderByList orderByNameAsc(QueryContext ctx) {
        return HostSetSQLOps.dictOrderAsc(this.Name);
    }

    public OrderByList orderByNameDesc(QueryContext ctx) {
        return HostSetSQLOps.dictOrderDesc(this.Name);
    }

    public int incrUpdateCountsByHost(HostID hostID, HostSetID[] hostSetIDs) throws PersistenceManagerException {
        ConditionalExpression cond = HostSetSQLOps.emptyIn(this.ID, HostSetSQLOps.rList(hostSetIDs));
        if (hostID != null) {
            Select containingHostSets = HostSetToHostLinkTable.DEFAULT.selectParentIDs(hostID);
            cond = HostSetSQLOps.or(cond, HostSetSQLOps.in((ColumnNode)this.ID, containingHostSets));
        }
        return HostSetSQLOps.execute(this.incrUpdateCountWhere(cond));
    }

    public int incrUpdateCountsByHost(HostID hostID) throws PersistenceManagerException {
        Select containingHostSets = HostSetToHostLinkTable.DEFAULT.selectParentIDs(hostID);
        return HostSetSQLOps.execute(this.incrUpdateCountByID(containingHostSets));
    }

    public int incrUpdateCountsByHostSearch(HostSearchID hostSearchID) throws PersistenceManagerException {
        Select containingHostSets = HostSetToHostSearchLinkTable.DEFAULT.selectParentIDs(hostSearchID);
        return HostSetSQLOps.execute(this.incrUpdateCountByID(containingHostSets));
    }

    public ConditionalExpression isSupported(boolean isSupported) {
        return HostSetSQLOps.equals(this.IsSupported, isSupported);
    }
}

