/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostLinkTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostSearchLinkTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostSetLinkTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSearchQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class HostSetImpl
extends PersistentBean
implements Cloneable {
    private String mSimpleName;
    private String mPluginName;
    private String mDescription = "";
    private PluginID mPluginID;
    private boolean mIsSupported = true;
    private transient SummaryHostSet mSummaryView;
    private boolean mExternalDataLoaded = false;
    private HostIDSet mMemberHostIDSet;
    private HostSetIDSet mMemberHostSetIDSet;
    private HostSearchIDSet mMemberHostSearchIDSet;
    static final Object LOCK = new Object();

    private HostSetImpl() {
    }

    static HostSetImpl create() {
        HostSetImpl result = new HostSetImpl();
        result.resetExternalData(true);
        return result;
    }

    static HostSetImpl create(PluginID pluginID) throws PersistenceManagerException, RPCException {
        HostSetImpl result = HostSetImpl.create();
        result.setPluginID(pluginID);
        result.setPluginName(pluginID.getByIDQuery().selectSummaryView().getName());
        return result;
    }

    HostSetID getID() {
        return (HostSetID)this.getObjectID();
    }

    protected Visibility getVisibility() {
        return super.getVisibility();
    }

    protected void setVisibility(Visibility v) {
        super.setVisibility(v);
    }

    String getName() {
        if (this.getPluginID() != null) {
            return this.getPluginName() + Plugin.NAME_SEPARATOR + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    private void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        int separatorIndex = name.indexOf(Plugin.NAME_SEPARATOR);
        if (separatorIndex != -1) {
            this.setPluginName(name.substring(0, separatorIndex));
            this.setSimpleName(name.substring(separatorIndex + 1));
        } else {
            this.setSimpleName(name);
        }
    }

    String getSimpleName() {
        return this.mSimpleName;
    }

    void setSimpleName(String simpleName) {
        if (simpleName == null) {
            throw new NullPointerException();
        }
        this.mSimpleName = simpleName;
    }

    private void setPluginName(String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException();
        }
        this.mPluginName = pluginName;
    }

    private String getPluginName() {
        return this.mPluginName;
    }

    String getDescription() {
        return this.mDescription;
    }

    void setDescription(String desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.mDescription = desc;
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int updateCount) {
        super.setUpdateCount(updateCount);
    }

    PluginID getPluginID() {
        return this.mPluginID;
    }

    private void setPluginID(PluginID plugin) {
        this.mPluginID = plugin;
    }

    boolean getIsSupported() {
        return this.mIsSupported;
    }

    void setIsSupported(boolean isSupported) {
        this.mIsSupported = isSupported;
    }

    SummaryHostSet getSummaryView() {
        if (this.mSummaryView == null) {
            this.mSummaryView = new SummaryHostSet(this);
        }
        return this.mSummaryView;
    }

    HostSet getCompleteViewMS() throws PersistenceManagerException {
        this.loadExternalDataMS();
        return new HostSet(this);
    }

    private boolean isExternalDataLoaded() {
        return this.mExternalDataLoaded;
    }

    private void resetExternalData(boolean isLoadComplete) {
        this.mMemberHostIDSet = new HostIDSet();
        this.mMemberHostSetIDSet = new HostSetIDSet();
        this.mMemberHostSearchIDSet = new HostSearchIDSet();
        if (isLoadComplete) {
            this.setExternalDataLoaded();
        }
    }

    private void setExternalDataLoaded() {
        this.mExternalDataLoaded = true;
    }

    private void loadExternalDataMS() throws PersistenceManagerException {
        if (this.isExternalDataLoaded()) {
            return;
        }
        if (this.getID() != null) {
            Link[] hosts = HostSetToHostLinkTable.DEFAULT.getByParentID(this.getID());
            Link[] hostSearches = HostSetToHostSearchLinkTable.DEFAULT.getByParentID(this.getID());
            Link[] hostSets = HostSetToHostSetLinkTable.DEFAULT.getByParentID(this.getID());
            this.setExternalDataMS(Arrays.asList(hosts), Arrays.asList(hostSearches), Arrays.asList(hostSets));
        } else {
            this.resetExternalData(true);
        }
    }

    static void loadExternalDataMS(List hostSets) throws PersistenceManagerException {
        int size = hostSets.size();
        if (size == 0) {
            return;
        }
        HostSetIDSet idSet = new HostSetIDSet();
        for (int i = 0; i < size; ++i) {
            HostSetImpl hostSet = (HostSetImpl)hostSets.get(i);
            if (hostSet.isExternalDataLoaded()) continue;
            idSet.add(hostSet.getID());
        }
        if (idSet.isEmpty()) {
            return;
        }
        ObjectID[] hostSetIDs = idSet.toIDArray();
        Map hostsMap = HostSetToHostLinkTable.DEFAULT.mapLinksByParentIDs(hostSetIDs);
        Map hostSearchesMap = HostSetToHostSearchLinkTable.DEFAULT.mapLinksByParentIDs(hostSetIDs);
        Map hostSetsMap = HostSetToHostSetLinkTable.DEFAULT.mapLinksByParentIDs(hostSetIDs);
        for (int i = 0; i < size; ++i) {
            HostSetImpl hostSet = (HostSetImpl)hostSets.get(i);
            if (hostSet.isExternalDataLoaded()) continue;
            List hostsList = (List)hostsMap.get(hostSet.getID());
            List hostSearchesList = (List)hostSearchesMap.get(hostSet.getID());
            List hostSetsList = (List)hostSetsMap.get(hostSet.getID());
            hostSet.setExternalDataMS(hostsList, hostSearchesList, hostSetsList);
        }
    }

    private synchronized void setExternalDataMS(List hostList, List hostSearchList, List hostSetList) {
        if (this.isExternalDataLoaded()) {
            return;
        }
        this.resetExternalData(false);
        Link.addChildIDs(this.mMemberHostIDSet, hostList);
        Link.addChildIDs(this.mMemberHostSearchIDSet, hostSearchList);
        Link.addChildIDs(this.mMemberHostSetIDSet, hostSetList);
        this.setExternalDataLoaded();
    }

    HostIDSet getMemberHostIDSet() {
        return (HostIDSet)this.mMemberHostIDSet.clone();
    }

    void setMemberHostIDSet(HostIDSet set) {
        this.mMemberHostIDSet = (HostIDSet)set.clone();
    }

    HostSetIDSet getMemberHostSetIDSet() {
        return (HostSetIDSet)this.mMemberHostSetIDSet.clone();
    }

    void setMemberHostSetIDSet(HostSetIDSet set) {
        this.mMemberHostSetIDSet = (HostSetIDSet)set.clone();
    }

    HostSearchIDSet getMemberHostSearchIDSet() {
        return (HostSearchIDSet)this.mMemberHostSearchIDSet.clone();
    }

    void setMemberHostSearchIDSet(HostSearchIDSet set) {
        this.mMemberHostSearchIDSet = (HostSearchIDSet)set.clone();
    }

    void removeAll() {
        this.resetExternalData(false);
    }

    MultiHostQuery getAllHostsQuery() throws PersistenceManagerException, RPCException {
        return MultiHostQuery.byMembers(this);
    }

    protected Object clone() {
        try {
            HostSetImpl result = (HostSetImpl)super.clone();
            result.mSummaryView = null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Object getObjectDataClone() {
        try {
            HostSetImpl result = (HostSetImpl)super.getObjectDataClone();
            result.setPluginID(null);
            result.setIsSupported(true);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void validate() throws HostDBException {
        HostSet.validateSimpleName(this.getSimpleName());
        HostSet.validateDescription(this.getDescription());
    }

    void save() throws HostDBException, PersistenceManagerException, RPCException {
        this.validate();
        this.saveRPC(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMS(PersistContext context) throws PersistenceManagerException {
        Object object = LOCK;
        synchronized (object) {
            HostSetImpl.transactMS(new Transaction(){

                public Object execute() throws PersistenceManagerException {
                    HostSetImpl.this.trSaveMS();
                    return null;
                }
            });
        }
    }

    private void trSaveMS() throws PersistenceManagerException {
        Plugin.checkWritePermissions(this.getSummaryView());
        HostSetID ID2 = this.getID();
        HostID[] hosts = this.mMemberHostIDSet.toIDArray();
        if (ID2 != null) {
            ID2.lockForUpdateMS();
            this.validateNoCycles(ID2);
            this.resetLinksMS(ID2, hosts, true);
            super.saveMS(null);
        } else {
            super.saveMS(null);
            ID2 = this.getID();
            this.resetLinksMS(ID2, hosts, false);
            HostDBSubsystem.getInstance().getHostSetUpdateNotifier().hostSetAdded(ID2);
        }
    }

    private void validateNoCycles(HostSetID myID) throws PersistenceManagerException {
        try {
            if (this.isDescendant(myID)) {
                throw HostDBException.hostSetCycle();
            }
        }
        catch (RPCException e) {
            throw HostDBException.unexpectedRPCException(e);
        }
    }

    private void resetLinksMS(HostSetID ID2, HostID[] hosts, boolean isUpdate) throws PersistenceManagerException {
        HostSQLOps.DEFAULT.incrUpdateCountsByHostSet(ID2, hosts, isUpdate);
        HostSetToHostLinkTable.DEFAULT.resetLinks(ID2, hosts, isUpdate);
        HostSetToHostSearchLinkTable.DEFAULT.resetLinks(ID2, this.mMemberHostSearchIDSet.toIDArray(), isUpdate);
        HostSetToHostSetLinkTable.DEFAULT.resetLinks(ID2, this.mMemberHostSetIDSet.toIDArray(), isUpdate);
    }

    boolean contains(HostSearchIDSet set, HostID hostID) throws PersistenceManagerException, RPCException {
        if (this.mMemberHostIDSet.contains(hostID)) {
            return true;
        }
        MultiHostSetQuery q = this.mMemberHostSetIDSet.getByIDsQuery();
        q.setAddResultsToCache(true);
        HostSet[] childSets = q.select();
        for (int i = 0; i < childSets.length; ++i) {
            if (!childSets[i].getHostSet().contains(set, hostID)) continue;
            return true;
        }
        set.addAll((Collection)this.mMemberHostSearchIDSet);
        return false;
    }

    boolean addIfContains(HostSetIDSet set, Host host) throws PersistenceManagerException, RPCException {
        HostSearchIDSet searchSet;
        boolean isContained = false;
        MultiHostSetQuery q = this.mMemberHostSetIDSet.getByIDsQuery();
        q.setAddResultsToCache(true);
        HostSet[] childSets = q.select();
        for (int i = 0; i < childSets.length; ++i) {
            if (!childSets[i].getHostSet().addIfContains(set, host)) continue;
            isContained = true;
        }
        if (!isContained && this.mMemberHostIDSet.contains(host.getID())) {
            isContained = true;
        }
        if (!isContained && (searchSet = this.mMemberHostSearchIDSet).size() > 0) {
            MultiHostSearchQuery hsq = searchSet.getByIDsQuery();
            hsq.setAddResultsToCache(true);
            HostSearch[] searches = hsq.select();
            for (int i = 0; !isContained && i < searches.length; ++i) {
                if (!searches[i].getCriteria().matches(host)) continue;
                isContained = true;
            }
        }
        if (isContained) {
            set.add(this.getID());
        }
        return isContained;
    }

    boolean addIfContains(HostSetIDSet set, HostSetID hostSetID) throws PersistenceManagerException, RPCException {
        boolean isContained = false;
        if (this.getID().equals(hostSetID)) {
            isContained = true;
        }
        if (!isContained) {
            MultiHostSetQuery q = this.mMemberHostSetIDSet.getByIDsQuery();
            q.setAddResultsToCache(true);
            HostSet[] childSets = q.select();
            for (int i = 0; i < childSets.length; ++i) {
                if (!childSets[i].getHostSet().addIfContains(set, hostSetID)) continue;
                isContained = true;
            }
        }
        if (isContained) {
            set.add(this.getID());
        }
        return isContained;
    }

    void getAllMembers(HostIDSet hosts, HostSearchIDSet searches, HostSetIDSet hostSets) throws PersistenceManagerException, RPCException {
        if (hosts != null) {
            hosts.addAll((Collection)this.mMemberHostIDSet);
        }
        if (searches != null) {
            searches.addAll((Collection)this.mMemberHostSearchIDSet);
        }
        if (hostSets != null) {
            hostSets.addAll((Collection)this.mMemberHostSetIDSet);
        }
        MultiHostSetQuery q = this.mMemberHostSetIDSet.getByIDsQuery();
        q.setAddResultsToCache(true);
        HostSet[] sets = q.select();
        for (int i = 0; i < sets.length; ++i) {
            sets[i].getHostSet().getAllMembers(hosts, searches, hostSets);
        }
    }

    boolean isDescendant(HostSetID setID) throws PersistenceManagerException, RPCException {
        if (this.mMemberHostSetIDSet.contains(setID)) {
            return true;
        }
        MultiHostSetQuery q = this.mMemberHostSetIDSet.getByIDsQuery();
        q.setAddResultsToCache(true);
        HostSet[] childSets = q.select();
        for (int i = 0; i < childSets.length; ++i) {
            if (!childSets[i].getHostSet().isDescendant(setID)) continue;
            return true;
        }
        return false;
    }
}

