/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsTable;
import com.raplix.rolloutexpress.difference.differencedb.MultiDifferenceSettingsQuery;
import com.raplix.rolloutexpress.event.rule.PersistentCriteriaMetaDataTable;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.cache.SingleObjectByNameCache;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetImpl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostLinkTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostSearchLinkTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostSetLinkTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSearchQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import java.security.AccessControlException;
import java.util.Hashtable;

public class HostSetID
extends ObjectID {
    private static final IDFactory ID_FACTORY = new IDFactory();

    private HostSetID() {
    }

    public HostSetID(String key) {
        super(key);
    }

    public SingleHostSetQuery getByIDQuery() {
        return new SingleHostSetQuery(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        Object object = HostSetImpl.LOCK;
        synchronized (object) {
            HostSetID.transactMS(new Transaction(){

                public Object execute() throws PersistenceManagerException {
                    HostSetID.this.trDeleteMS();
                    return null;
                }
            });
        }
    }

    private void trDeleteMS() throws PersistenceManagerException {
        HostSetToHostSetLinkTable.DEFAULT.incrParentUpdateCounts(HostSetSQLOps.DEFAULT, this);
        this.lockForUpdateMS();
        HostSetToHostLinkTable.DEFAULT.incrChildUpdateCounts(HostSQLOps.DEFAULT, this);
        HostSetToHostLinkTable.DEFAULT.removeByParentID(this);
        HostSetToHostSearchLinkTable.DEFAULT.removeByParentID(this);
        HostSetToHostSetLinkTable.DEFAULT.removeLinks(this);
        HostDBSubsystem.getInstance().getHostSetUpdateNotifier().hostSetDeleted(this);
        super.deleteMS(null);
    }

    protected void lockForUpdateMS() throws PersistenceManagerException {
        super.lockForUpdateMS();
    }

    public MultiHostQuery getAllHostsQuery() throws PersistenceManagerException, RPCException {
        return MultiHostQuery.byHostSet(this);
    }

    public boolean contains(HostID hostID) throws PersistenceManagerException, RPCException {
        HostSet hs;
        if (hostID == null) {
            return false;
        }
        HostSearchIDSet allSearches = new HostSearchIDSet();
        try {
            hs = this.getByIDQuery().select();
        }
        catch (NoResultsFoundException e) {
            return false;
        }
        if (hs.getHostSet().contains(allSearches, hostID)) {
            return true;
        }
        if (allSearches.size() == 0) {
            return false;
        }
        Host host = null;
        try {
            host = hostID.getByIDQuery().select();
        }
        catch (NoResultsFoundException e) {
            return false;
        }
        MultiHostSearchQuery hsq = allSearches.getByIDsQuery();
        hsq.setAddResultsToCache(true);
        HostSearch[] searches = hsq.select();
        for (int i = 0; i < searches.length; ++i) {
            if (!searches[i].getCriteria().matches(host)) continue;
            return true;
        }
        return false;
    }

    public HostSetIDSet getDescendantsContaining(HostID hID) throws PersistenceManagerException, RPCException {
        HostSetIDSet result = new HostSetIDSet();
        if (hID == null) {
            return result;
        }
        Host h = null;
        try {
            h = hID.getByIDQuery().select();
        }
        catch (NoResultsFoundException e) {
            return result;
        }
        HostSet hs = null;
        try {
            hs = this.getByIDQuery().select();
        }
        catch (NoResultsFoundException e) {
            return result;
        }
        hs.getHostSet().addIfContains(result, h);
        return result;
    }

    public HostSetIDSet getDescendantsContaining(HostSetID hsID) throws PersistenceManagerException, RPCException {
        HostSetIDSet result = new HostSetIDSet();
        if (hsID == null) {
            return result;
        }
        HostSet hs = null;
        try {
            hs = this.getByIDQuery().select();
        }
        catch (NoResultsFoundException e) {
            return result;
        }
        hs.getHostSet().addIfContains(result, hsID);
        return result;
    }

    public boolean containsAll(HostSetID hostSetID) throws PersistenceManagerException, RPCException {
        return !MultiHostQuery.byExclusiveMembersOf(hostSetID, this).selectExists();
    }

    public boolean isDescendant(HostSetID hostSetID) throws PersistenceManagerException, RPCException {
        HostSet hs;
        if (hostSetID == null) {
            return false;
        }
        if (this.equals(hostSetID)) {
            return true;
        }
        try {
            hs = this.getByIDQuery().select();
        }
        catch (NoResultsFoundException e) {
            return false;
        }
        return hs.getHostSet().isDescendant(hostSetID);
    }

    public MultiHostSetQuery getDescendantsQuery() throws PersistenceManagerException, RPCException {
        MultiHostSetQuery q = this.getDescendantIDs().getByIDsQuery();
        q.setObjectOrder(HostSetOrder.BY_NAME_ASC);
        return q;
    }

    public HostSetIDSet getDescendantIDs() throws PersistenceManagerException, RPCException {
        HostSet hs;
        HostSetIDSet result = new HostSetIDSet();
        result.add(this);
        try {
            hs = this.getByIDQuery().select();
        }
        catch (NoResultsFoundException e) {
            return result;
        }
        hs.getHostSet().getAllMembers(null, null, result);
        return result;
    }

    public static HostSetID generateID() {
        return (HostSetID)ID_FACTORY.generateObjectID();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            SummaryHostSet theHostSet = this.getByIDQuery().selectSummaryView();
            try {
                Plugin.checkWritePermissions(theHostSet);
            }
            catch (AccessControlException e) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{theHostSet.getPluginID().getByIDQuery().selectSummaryView()});
            }
            MultiDifferenceSettingsQuery mdsq = MultiDifferenceSettingsQuery.all();
            mdsq.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    DifferenceSettingsTable t = (DifferenceSettingsTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(DifferenceSettingsTable.equals(t.DstHostSetID, HostSetID.this.toString()));
                }
            });
            UsingObject[] users = mdsq.select();
            if (null != users && users.length > 0) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), users);
            }
            PersistentCriteriaMetaDataTable cdt = PersistentCriteriaMetaDataTable.DEFAULT;
            if (0 != PersistentCriteriaMetaDataTable.selectCount(cdt, PersistentCriteriaMetaDataTable.where(PersistentCriteriaMetaDataTable.equals(cdt.HostSet, this.toString())))) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"));
            }
            ResourceTable rt = ResourceTable.DEFAULT;
            if (0 != ResourceTable.selectCount(rt, ResourceTable.where(ResourceTable.equals(rt.Platform, this)))) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"));
            }
            HostSetImplTable hst = HostSetImplTable.DEFAULT;
            final Select hostSetName = hst.select(HostSetImplTable.sList(hst.Name), HostSetImplTable.where(HostSetImplTable.equals(hst.ID, this)));
            MultiComponentQuery mcq = MultiComponentQuery.all();
            mcq.setVisibilityFilter(null);
            mcq.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    ComponentImplTable ct = (ComponentImplTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(ComponentImplTable.or(ComponentImplTable.in((ColumnNode)ct.Platform, hostSetName), ComponentImplTable.in((ColumnNode)ct.LocalLimitToHostSet, hostSetName)));
                }
            });
            SummaryComponent[] comps = mcq.selectSummaryView();
            for (int i = 0; i < comps.length; ++i) {
                if (inContext.objectWillBeDeletedPriorTo(comps[i].getID(), this)) continue;
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), (UsingObject[])new SummaryComponent[]{comps[i]});
            }
            Permission[] perms = null;
            try {
                PermissionManager pm = HostDBSubsystem.getInstance().getApplication().getUserDBSubsystem().getLocalUserDBAdmin().getPermissionManager();
                StringBuffer hostSetPerms = new StringBuffer();
                hostSetPerms.append("%").append("hostset:").append(this.toString());
                perms = pm.getPermissionsByCriteria(hostSetPerms.toString(), null, null);
            }
            catch (UserDBException udbe) {
                throw new PersistenceManagerException(udbe);
            }
            catch (UnsupportedSubsystemException use) {
                throw new PersistenceManagerException(use);
            }
            if (perms.length > 0) {
                Hashtable<GroupID, Group> usingObjs = new Hashtable<GroupID, Group>();
                for (int i = 0; i < perms.length; ++i) {
                    try {
                        Group[] groups = perms[i].getGroups();
                        for (int j = 0; j < groups.length; ++j) {
                            usingObjs.put(groups[j].getGroupID(), groups[j]);
                        }
                        continue;
                    }
                    catch (UserDBException udbe) {
                        throw new PersistenceManagerException(udbe);
                    }
                }
                if (usingObjs.values().size() > 0) {
                    throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), usingObjs.values().toArray(new UsingObject[0]));
                }
            }
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        HostSetIDSet idset = new HostSetIDSet();
        idset.add(this);
        return idset;
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new HostSetID(inID);
        }

        public void registerCaches(ClassMap classMap, ObjectCache objectCache) {
            HostSetImplTable t = HostSetImplTable.DEFAULT;
            SingleObjectByNameCache cache = new SingleObjectByNameCache(objectCache, t.Name);
            classMap.addSingleObjectCache(cache);
        }
    }
}

