/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetImpl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.util.Validate;

public class HostSet
extends SummaryHostSet
implements Cloneable,
RPCSerializable {
    private boolean mHostSetIsCopy;

    public HostSet() {
        super(HostSetImpl.create());
        this.mHostSetIsCopy = true;
    }

    public HostSet(PluginID inPluginID) throws PersistenceManagerException, RPCException {
        super(HostSetImpl.create(inPluginID));
        this.mHostSetIsCopy = true;
    }

    HostSet(HostSetImpl hostSet) {
        super(hostSet);
        this.mHostSetIsCopy = false;
    }

    private HostSetImpl getMutableHostSet() {
        if (!this.mHostSetIsCopy) {
            this.setHostSet((HostSetImpl)this.getHostSet().clone());
            this.mHostSetIsCopy = true;
        }
        return this.getHostSet();
    }

    public void setSimpleName(String name) {
        this.getMutableHostSet().setSimpleName(name);
    }

    public void setDescription(String desc) {
        this.getMutableHostSet().setDescription(desc);
    }

    public void setVisibility(Visibility visibility) {
        this.getMutableHostSet().setVisibility(visibility);
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableHostSet().setUpdateCount(updateCount);
    }

    public void setIsSupported(boolean isSupported) {
        if (this.getPluginID() == null) {
            throw new UnsupportedOperationException();
        }
        this.getHostSet().setIsSupported(isSupported);
    }

    public HostIDSet getMemberHostIDSet() {
        return this.getHostSet().getMemberHostIDSet();
    }

    public void setMemberHostIDSet(HostIDSet hostSet) {
        this.getMutableHostSet().setMemberHostIDSet(hostSet);
    }

    public HostSetIDSet getMemberHostSetIDSet() {
        return this.getHostSet().getMemberHostSetIDSet();
    }

    public void setMemberHostSetIDSet(HostSetIDSet hostSetSet) {
        this.getMutableHostSet().setMemberHostSetIDSet(hostSetSet);
    }

    public HostSearchIDSet getMemberHostSearchIDSet() {
        return this.getHostSet().getMemberHostSearchIDSet();
    }

    public void setMemberHostSearchIDSet(HostSearchIDSet hostSearchSet) {
        this.getMutableHostSet().setMemberHostSearchIDSet(hostSearchSet);
    }

    public void removeAll() {
        this.getMutableHostSet().removeAll();
    }

    public MultiHostQuery getAllHostsQuery() throws PersistenceManagerException, RPCException {
        return this.getHostSet().getAllHostsQuery();
    }

    public HostSet getDataClone() {
        return new HostSet((HostSetImpl)this.getHostSet().getObjectDataClone());
    }

    public Object clone() {
        if (this.mHostSetIsCopy) {
            return new HostSet((HostSetImpl)this.getHostSet().clone());
        }
        return new HostSet(this.getHostSet());
    }

    public void save() throws HostDBException, PersistenceManagerException, RPCException {
        this.getMutableHostSet().save();
    }

    public void validate() throws HostDBException {
        this.getHostSet().validate();
    }

    public static void validateSimpleName(String name) throws HostDBException {
        if (!Validate.isValidObjectName(name, 32)) {
            throw HostDBException.invalidHostSetName(name);
        }
    }

    public static void validateDescription(String desc) throws HostDBException {
        if (!Validate.isValidObjectDescription(desc)) {
            throw HostDBException.invalidHostSetDescription(desc);
        }
    }
}

