/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppTypeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteriaList;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteriaTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.PhysicalCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSearch;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

class HostSearchImpl
extends PersistentBean
implements Cloneable {
    private String mSimpleName;
    private String mPluginName;
    private String mDescription = "";
    private PluginID mPluginID;
    private transient SummaryHostSearch mSummaryView;
    private boolean mExternalDataLoaded = false;
    private AttributeCriteriaList mAttrCriteriaList;
    private boolean mIncludeMS;
    private boolean mIncludeLD;
    private boolean mIncludeRA;
    private boolean mIncludeNone;
    private boolean mIncludePhysical;
    private boolean mIncludeVirtual;

    private HostSearchImpl() {
    }

    static HostSearchImpl create() {
        HostSearchImpl result = new HostSearchImpl();
        result.resetExternalData(true);
        result.setAppTypeCriteria(new AppTypeCriteria());
        return result;
    }

    static HostSearchImpl create(PluginID pluginID) throws PersistenceManagerException, RPCException {
        HostSearchImpl result = HostSearchImpl.create();
        result.setPluginID(pluginID);
        result.setPluginName(pluginID.getByIDQuery().selectSummaryView().getName());
        return result;
    }

    HostSearchID getID() {
        return (HostSearchID)this.getObjectID();
    }

    protected Visibility getVisibility() {
        return super.getVisibility();
    }

    protected void setVisibility(Visibility v) {
        super.setVisibility(v);
    }

    String getName() {
        if (this.getPluginID() != null) {
            return this.getPluginName() + Plugin.NAME_SEPARATOR + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    private void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        int separatorIndex = name.indexOf(Plugin.NAME_SEPARATOR);
        if (separatorIndex != -1) {
            this.setPluginName(name.substring(0, separatorIndex));
            this.setSimpleName(name.substring(separatorIndex + 1));
        } else {
            this.setSimpleName(name);
        }
    }

    String getSimpleName() {
        return this.mSimpleName;
    }

    void setSimpleName(String simpleName) {
        if (simpleName == null) {
            throw new NullPointerException();
        }
        this.mSimpleName = simpleName;
    }

    private void setPluginName(String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException();
        }
        this.mPluginName = pluginName;
    }

    private String getPluginName() {
        return this.mPluginName;
    }

    String getDescription() {
        return this.mDescription;
    }

    void setDescription(String desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.mDescription = desc;
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int updateCount) {
        super.setUpdateCount(updateCount);
    }

    PluginID getPluginID() {
        return this.mPluginID;
    }

    private void setPluginID(PluginID plugin) {
        this.mPluginID = plugin;
    }

    SummaryHostSearch getSummaryView() {
        if (this.mSummaryView == null) {
            this.mSummaryView = new SummaryHostSearch(this);
        }
        return this.mSummaryView;
    }

    HostSearch getCompleteViewMS() throws PersistenceManagerException {
        this.loadExternalDataMS();
        return new HostSearch(this);
    }

    private boolean isExternalDataLoaded() {
        return this.mExternalDataLoaded;
    }

    private void resetExternalData(boolean isLoadComplete) {
        this.mAttrCriteriaList = new AttributeCriteriaList();
        if (isLoadComplete) {
            this.setExternalDataLoaded();
        }
    }

    private void setExternalDataLoaded() {
        this.mExternalDataLoaded = true;
    }

    private void loadExternalDataMS() throws PersistenceManagerException {
        if (this.isExternalDataLoaded()) {
            return;
        }
        if (this.getID() != null) {
            AttributeCriteriaList attrCriteriaList = new AttributeCriteriaList();
            AttributeCriteriaTable[] criteriaTs = AttributeCriteriaTable.ALL_DEFAULTS;
            for (int i = 0; i < criteriaTs.length; ++i) {
                AttributeCriteria[] criteria = criteriaTs[i].getByHostSearch(this.getID());
                attrCriteriaList.addAll(Arrays.asList(criteria));
            }
            this.setExternalDataMS(attrCriteriaList);
        } else {
            this.resetExternalData(true);
        }
    }

    static void loadExternalDataMS(List hostSearches) throws PersistenceManagerException {
        int i;
        int size = hostSearches.size();
        if (size == 0) {
            return;
        }
        HostSearchIDSet idSet = new HostSearchIDSet();
        HashMap<HostSearchID, AttributeCriteriaList> criteriaMap = new HashMap<HostSearchID, AttributeCriteriaList>();
        for (int i2 = 0; i2 < size; ++i2) {
            HostSearchImpl hostSearch = (HostSearchImpl)hostSearches.get(i2);
            if (hostSearch.isExternalDataLoaded()) continue;
            idSet.add(hostSearch.getID());
            criteriaMap.put(hostSearch.getID(), new AttributeCriteriaList());
        }
        if (idSet.isEmpty()) {
            return;
        }
        HostSearchID[] hostSearchIDs = idSet.toIDArray();
        AttributeCriteriaTable[] criteriaTs = AttributeCriteriaTable.ALL_DEFAULTS;
        for (i = 0; i < criteriaTs.length; ++i) {
            HostSearchImpl.addCriteriaForHostSearches(hostSearchIDs, criteriaTs[i], criteriaMap);
        }
        for (i = 0; i < size; ++i) {
            HostSearchImpl hostSearch = (HostSearchImpl)hostSearches.get(i);
            if (hostSearch.isExternalDataLoaded()) continue;
            HostSearchID id = hostSearch.getID();
            AttributeCriteriaList criteriaList = (AttributeCriteriaList)criteriaMap.get(id);
            hostSearch.setExternalDataMS(criteriaList);
        }
    }

    private static void addCriteriaForHostSearches(HostSearchID[] hostSearches, AttributeCriteriaTable criteriaT, HashMap criteriaMap) throws PersistenceManagerException {
        AttributeCriteria[] criteria = criteriaT.getByHostSearches(hostSearches);
        for (int i = 0; i < criteria.length; ++i) {
            HostSearchID id = criteria[i].getHostSearchID();
            AttributeCriteriaList criteriaList = (AttributeCriteriaList)criteriaMap.get(id);
            criteriaList.add(criteria[i]);
        }
    }

    private synchronized void setExternalDataMS(AttributeCriteriaList criteriaList) {
        if (this.isExternalDataLoaded()) {
            return;
        }
        this.resetExternalData(false);
        this.mAttrCriteriaList.addAll(criteriaList);
        this.setExternalDataLoaded();
    }

    HostSearchCriteria getCriteria() {
        return new HostSearchCriteria(this.getAppTypeCriteria(), this.getPhysicalCriteria(), this.mAttrCriteriaList);
    }

    void setCriteria(HostSearchCriteria criteria) {
        this.setAppTypeCriteria(criteria.getAppTypeCriteria());
        this.setPhysicalCriteria(criteria.getPhysicalCriteria());
        this.mAttrCriteriaList = criteria.getAttributeCriteriaList();
    }

    private void setAppTypeCriteria(AppTypeCriteria c) {
        this.setIncludeMS(c.getIncludeMS());
        this.setIncludeLD(c.getIncludeLD());
        this.setIncludeRA(c.getIncludeRA());
        this.setIncludeNone(c.getIncludeNone());
    }

    private AppTypeCriteria getAppTypeCriteria() {
        AppTypeCriteria result = new AppTypeCriteria();
        result.setIncludeMS(this.getIncludeMS());
        result.setIncludeLD(this.getIncludeLD());
        result.setIncludeRA(this.getIncludeRA());
        result.setIncludeNone(this.getIncludeNone());
        return result;
    }

    private boolean getIncludeMS() {
        return this.mIncludeMS;
    }

    private void setIncludeMS(boolean includeMS) {
        this.mIncludeMS = includeMS;
    }

    private boolean getIncludeLD() {
        return this.mIncludeLD;
    }

    private void setIncludeLD(boolean includeLD) {
        this.mIncludeLD = includeLD;
    }

    private boolean getIncludeRA() {
        return this.mIncludeRA;
    }

    private void setIncludeRA(boolean includeRA) {
        this.mIncludeRA = includeRA;
    }

    private boolean getIncludeNone() {
        return this.mIncludeNone;
    }

    private void setIncludeNone(boolean includeNone) {
        this.mIncludeNone = includeNone;
    }

    private void setPhysicalCriteria(PhysicalCriteria c) {
        this.setIncludePhysical(c.getIncludePhysical());
        this.setIncludeVirtual(c.getIncludeVirtual());
    }

    private PhysicalCriteria getPhysicalCriteria() {
        PhysicalCriteria result = new PhysicalCriteria();
        result.setIncludePhysical(this.getIncludePhysical());
        result.setIncludeVirtual(this.getIncludeVirtual());
        return result;
    }

    private boolean getIncludePhysical() {
        return this.mIncludePhysical;
    }

    private void setIncludePhysical(boolean includePhysical) {
        this.mIncludePhysical = includePhysical;
    }

    private boolean getIncludeVirtual() {
        return this.mIncludeVirtual;
    }

    private void setIncludeVirtual(boolean includeVirtual) {
        this.mIncludeVirtual = includeVirtual;
    }

    protected Object clone() {
        try {
            HostSearchImpl result = (HostSearchImpl)super.clone();
            result.mSummaryView = null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Object getObjectDataClone() {
        try {
            HostSearchImpl result = (HostSearchImpl)super.getObjectDataClone();
            result.setPluginID(null);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void validate() throws HostDBException {
        HostSearch.validateSimpleName(this.getSimpleName());
        HostSearch.validateDescription(this.getDescription());
        HostSearch.validateCriteria(this.getCriteria());
    }

    void save() throws HostDBException, PersistenceManagerException, RPCException {
        this.validate();
        this.saveRPC(null);
    }

    protected void saveMS(PersistContext context) throws PersistenceManagerException {
        HostSearchImpl.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                HostSearchImpl.this.trSaveMS();
                return null;
            }
        });
    }

    private void trSaveMS() throws PersistenceManagerException {
        Plugin.checkWritePermissions(this.getSummaryView());
        HostSearchID ID2 = this.getID();
        if (ID2 != null) {
            ID2.lockForUpdateMS();
            ID2.removeAttributeCriteriaMS();
            this.saveAttributeCriteriaMS(ID2);
            super.saveMS(null);
        } else {
            super.saveMS(null);
            ID2 = this.getID();
            this.saveAttributeCriteriaMS(ID2);
        }
    }

    private void saveAttributeCriteriaMS(HostSearchID id) throws PersistenceManagerException {
        this.mAttrCriteriaList.saveMS(id);
    }
}

