/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteriaTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostSearchLinkTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSearchQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSearch;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import java.security.AccessControlException;

public class HostSearchID
extends ObjectID {
    private static final IDFactory ID_FACTORY = new IDFactory();

    private HostSearchID() {
    }

    public HostSearchID(String key) {
        super(key);
    }

    public SingleHostSearchQuery getByIDQuery() {
        return new SingleHostSearchQuery(this);
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        HostSearchID.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                HostSearchID.this.trDeleteMS();
                return null;
            }
        });
    }

    private void trDeleteMS() throws PersistenceManagerException {
        HostSetSQLOps.DEFAULT.incrUpdateCountsByHostSearch(this);
        HostSetToHostSearchLinkTable.DEFAULT.removeByChildID(this);
        this.lockForUpdateMS();
        this.removeAttributeCriteriaMS();
        super.deleteMS(null);
    }

    void removeAttributeCriteriaMS() throws PersistenceManagerException {
        AttributeCriteriaTable[] criteriaTs = AttributeCriteriaTable.ALL_DEFAULTS;
        for (int i = 0; i < criteriaTs.length; ++i) {
            criteriaTs[i].removeByHostSearch(this);
        }
    }

    protected void lockForUpdateMS() throws PersistenceManagerException {
        super.lockForUpdateMS();
    }

    public MultiHostQuery getAllHostsQuery() throws RPCException, PersistenceManagerException {
        return MultiHostQuery.bySearch(this);
    }

    public static HostSearchID generateID() {
        return (HostSearchID)ID_FACTORY.generateObjectID();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            SummaryHostSearch theHostSearch = this.getByIDQuery().selectSummaryView();
            try {
                Plugin.checkWritePermissions(theHostSearch);
            }
            catch (AccessControlException e) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{theHostSearch.getPluginID().getByIDQuery().selectSummaryView()});
            }
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        HostSearchIDSet idset = new HostSearchIDSet();
        idset.add(this);
        return idset;
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new HostSearchID(inID);
        }
    }
}

