/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppTypeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteriaList;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.PhysicalCriteria;
import java.util.HashSet;
import java.util.Iterator;

public class HostSearchCriteria
implements Cloneable,
RPCSerializable {
    private AppTypeCriteria mAppTypeCriteria;
    private PhysicalCriteria mPhysicalCriteria;
    private AttributeCriteriaList mAttrCriteriaList;
    public static final String EMPTY_CRITERIA = "empty";
    public static final String TERM_SEPARATOR = ";";

    public HostSearchCriteria() {
        this(new AppTypeCriteria(), new PhysicalCriteria(), new AttributeCriteriaList());
    }

    HostSearchCriteria(AppTypeCriteria appTypeCriteria, PhysicalCriteria physicalCriteria, AttributeCriteriaList attrCriteriaList) {
        this.mAppTypeCriteria = appTypeCriteria;
        this.mPhysicalCriteria = physicalCriteria;
        this.mAttrCriteriaList = attrCriteriaList;
    }

    public AppTypeCriteria getAppTypeCriteria() {
        return (AppTypeCriteria)this.mAppTypeCriteria.clone();
    }

    public void setAppTypeCriteria(AppTypeCriteria criteria) {
        this.mAppTypeCriteria = (AppTypeCriteria)criteria.clone();
    }

    public PhysicalCriteria getPhysicalCriteria() {
        return (PhysicalCriteria)this.mPhysicalCriteria.clone();
    }

    public void setPhysicalCriteria(PhysicalCriteria criteria) {
        this.mPhysicalCriteria = (PhysicalCriteria)criteria.clone();
    }

    public AttributeCriteriaList getAttributeCriteriaList() {
        return (AttributeCriteriaList)this.mAttrCriteriaList.clone();
    }

    public void setAttributeCriteriaList(AttributeCriteriaList attributeCriteriaList) {
        this.mAttrCriteriaList = (AttributeCriteriaList)attributeCriteriaList.clone();
    }

    public MultiHostQuery getAllHostsQuery() {
        return MultiHostQuery.byCriteria(this);
    }

    public boolean isEmptyCriteria() {
        return this.mAttrCriteriaList.isEmpty() && this.mPhysicalCriteria.isEmptyCriteria() && this.mAppTypeCriteria.isEmptyCriteria();
    }

    ConditionalExpression getConditional(HostSQLOps hostTable) {
        if (this.isEmptyCriteria()) {
            return hostTable.none();
        }
        AndExp result = hostTable.and();
        if (!this.mAppTypeCriteria.isEmptyCriteria()) {
            result.add(this.mAppTypeCriteria.getConditional(hostTable));
        }
        if (!this.mPhysicalCriteria.isEmptyCriteria()) {
            result.add(this.mPhysicalCriteria.getConditional(hostTable));
        }
        Iterator it = this.mAttrCriteriaList.iterator();
        while (it.hasNext()) {
            AttributeCriteria c = (AttributeCriteria)it.next();
            result.add(c.getConditional(hostTable));
        }
        return result;
    }

    public boolean matches(HostID hostID) throws RPCException, PersistenceManagerException {
        if (hostID == null) {
            return false;
        }
        try {
            return this.matches(hostID.getByIDQuery().select());
        }
        catch (NoResultsFoundException noResultsFoundException) {
            return false;
        }
    }

    boolean matches(Host host) {
        if (this.isEmptyCriteria()) {
            return false;
        }
        if (!this.mAppTypeCriteria.isEmptyCriteria() && !this.mAppTypeCriteria.matches(host)) {
            return false;
        }
        if (!this.mPhysicalCriteria.isEmptyCriteria() && !this.mPhysicalCriteria.matches(host)) {
            return false;
        }
        Iterator it = this.mAttrCriteriaList.iterator();
        while (it.hasNext()) {
            AttributeCriteria c = (AttributeCriteria)it.next();
            if (c.matches(host)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isEmptyCriteria()) {
            return EMPTY_CRITERIA;
        }
        StringBuffer result = new StringBuffer();
        this.mAppTypeCriteria.toStringBuffer(result);
        result.append(TERM_SEPARATOR);
        this.mPhysicalCriteria.toStringBuffer(result);
        Iterator it = this.mAttrCriteriaList.iterator();
        while (it.hasNext()) {
            result.append(TERM_SEPARATOR);
            AttributeCriteria c = (AttributeCriteria)it.next();
            c.toStringBuffer(result);
        }
        return result.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof HostSearchCriteria)) {
            return false;
        }
        HostSearchCriteria otherCriteria = (HostSearchCriteria)other;
        return this.mAppTypeCriteria.equals(otherCriteria.mAppTypeCriteria) && this.mPhysicalCriteria.equals(otherCriteria.mPhysicalCriteria) && this.mAttrCriteriaList.containsAll(otherCriteria.mAttrCriteriaList) && otherCriteria.mAttrCriteriaList.containsAll(this.mAttrCriteriaList);
    }

    public int hashCode() {
        return this.mAppTypeCriteria.hashCode() + this.mPhysicalCriteria.hashCode() + new HashSet(this.mAttrCriteriaList).hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

