/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchImpl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSearch;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.util.Validate;

public class HostSearch
extends SummaryHostSearch
implements Cloneable,
RPCSerializable {
    private boolean mHostSearchIsCopy;

    public HostSearch() {
        super(HostSearchImpl.create());
        this.mHostSearchIsCopy = true;
    }

    public HostSearch(PluginID inPluginID) throws PersistenceManagerException, RPCException {
        super(HostSearchImpl.create(inPluginID));
        this.mHostSearchIsCopy = true;
    }

    HostSearch(HostSearchImpl hostSearch) {
        super(hostSearch);
        this.mHostSearchIsCopy = false;
    }

    private HostSearchImpl getMutableHostSearch() {
        if (!this.mHostSearchIsCopy) {
            this.setHostSearch((HostSearchImpl)this.getHostSearch().clone());
            this.mHostSearchIsCopy = true;
        }
        return this.getHostSearch();
    }

    public void setSimpleName(String name) {
        this.getMutableHostSearch().setSimpleName(name);
    }

    public void setDescription(String desc) {
        this.getMutableHostSearch().setDescription(desc);
    }

    public void setVisibility(Visibility visibility) {
        this.getMutableHostSearch().setVisibility(visibility);
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableHostSearch().setUpdateCount(updateCount);
    }

    public HostSearchCriteria getCriteria() {
        return this.getHostSearch().getCriteria();
    }

    public void setCriteria(HostSearchCriteria criteria) {
        this.getMutableHostSearch().setCriteria(criteria);
    }

    public HostSearch getDataClone() {
        return new HostSearch((HostSearchImpl)this.getHostSearch().getObjectDataClone());
    }

    public Object clone() {
        if (this.mHostSearchIsCopy) {
            return new HostSearch((HostSearchImpl)this.getHostSearch().clone());
        }
        return new HostSearch(this.getHostSearch());
    }

    public void save() throws HostDBException, PersistenceManagerException, RPCException {
        this.getMutableHostSearch().save();
    }

    public void validate() throws HostDBException {
        this.getHostSearch().validate();
    }

    public static void validateSimpleName(String name) throws HostDBException {
        if (!Validate.isValidObjectName(name, 32)) {
            throw HostDBException.invalidSearchName(name);
        }
    }

    public static void validateDescription(String desc) throws HostDBException {
        if (!Validate.isValidObjectDescription(desc)) {
            throw HostDBException.invalidSearchDescription(desc);
        }
    }

    public static void validateCriteria(HostSearchCriteria criteria) throws HostDBException {
        if (criteria.isEmptyCriteria()) {
            throw HostDBException.emptySearchCriteria();
        }
    }
}

