/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrExp;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SetList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppTypeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetImpl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostLinkTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSearchQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.PhysicalCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarDeclSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarOverrideSQLOps;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.util.regex.GlobPattern;
import java.util.Date;

class HostSQLOps
extends HostImplTable {
    public static final HostSQLOps DEFAULT = new HostSQLOps();

    public HostSQLOps(String alias) {
        super(alias);
    }

    private HostSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new HostSQLOps(alias);
    }

    public int incrUpdateCountsByHostType(HostTypeID id) throws PersistenceManagerException {
        return HostSQLOps.execute(this.incrUpdateCountWhere(HostSQLOps.equals(this.HostTypeID, id)));
    }

    public int incrUpdateCountsByHostSet(HostSetID hostSetID, HostID[] hostIDs, boolean refreshExisting) throws PersistenceManagerException {
        ConditionalExpression cond = HostSQLOps.emptyIn(this.ID, HostSQLOps.rList(hostIDs));
        if (refreshExisting) {
            Select hostSetMembers = HostSetToHostLinkTable.DEFAULT.selectChildIDs(hostSetID);
            cond = HostSQLOps.or(cond, HostSQLOps.in((ColumnNode)this.ID, hostSetMembers));
        }
        return HostSQLOps.execute(this.incrUpdateCountWhere(cond));
    }

    public ConditionalExpression isName(String name) {
        return HostSQLOps.equals(this.Name, name);
    }

    ConditionalExpression byInstalledComponentID(InstalledComponentID inID) {
        return HostSQLOps.equals(this.InstalledComponentID, inID);
    }

    public ConditionalExpression isType(HostTypeID hostTypeID) {
        return HostSQLOps.equals(this.HostTypeID, hostTypeID);
    }

    public ConditionalExpression isChildOf(HostID parentID) {
        return HostSQLOps.equals(this.ParentHostID, parentID);
    }

    public OrderByList orderByNameAsc(QueryContext ctx) {
        return HostSQLOps.dictOrderAsc(this.Name);
    }

    public OrderByList orderByNameDesc(QueryContext ctx) {
        return HostSQLOps.dictOrderDesc(this.Name);
    }

    private ScalarExp getDominantAppType() {
        Select dominantAppType = AppInstanceSQLOps.DEFAULT.selectDominantAppTypeForHost(this.ID);
        return HostSQLOps.ifNull(HostSQLOps.scalar(dominantAppType), HostSQLOps.v(1000));
    }

    public OrderByList orderByAppTypeAsc(QueryContext ctx) {
        return HostSQLOps.oList(HostSQLOps.orderByAsc(this.getDominantAppType()), HostSQLOps.orderByAsc(HostSQLOps.isNull(this.ParentHostID))).add(this.orderByNameAsc(ctx));
    }

    public OrderByList orderByAppTypeDesc(QueryContext ctx) {
        return HostSQLOps.oList(HostSQLOps.orderByDesc(this.getDominantAppType()), HostSQLOps.orderByDesc(HostSQLOps.isNull(this.ParentHostID))).add(this.orderByNameAsc(ctx));
    }

    public OrderByList orderByHostTypeNameAsc(QueryContext ctx) {
        HostTypeSQLOps htT = new HostTypeSQLOps("htT");
        ctx.addTable(htT);
        ctx.addAndWhereCondition(HostSQLOps.equals((ColumnNode)htT.ID, this.HostTypeID));
        return HostSQLOps.dictOrderAsc(htT.Name).add(this.orderByAppTypeAsc(ctx));
    }

    public OrderByList orderByHostTypeNameDesc(QueryContext ctx) {
        HostTypeSQLOps htT = new HostTypeSQLOps("htT");
        ctx.addTable(htT);
        ctx.addAndWhereCondition(HostSQLOps.equals((ColumnNode)htT.ID, this.HostTypeID));
        return HostSQLOps.dictOrderDesc(htT.Name).add(this.orderByAppTypeAsc(ctx));
    }

    public ConditionalExpression equalsHostType(HostTypeID hostTypeID) {
        return HostSQLOps.equals(this.HostTypeID, hostTypeID);
    }

    public ConditionalExpression containsAppType(AppType[] appTypes) {
        AppTypeCriteria c = new AppTypeCriteria();
        for (int i = 0; i < appTypes.length; ++i) {
            if (AppType.RA.equals(appTypes[i])) {
                c.setIncludeRA(true);
                continue;
            }
            if (AppType.LD.equals(appTypes[i])) {
                c.setIncludeLD(true);
                continue;
            }
            if (!AppType.MS.equals(appTypes[i])) continue;
            c.setIncludeMS(true);
        }
        return this.getByAppType(c);
    }

    public ConditionalExpression isMemberOf(HostSetID hostSetID) throws PersistenceManagerException, RPCException {
        HostSet hs;
        if (hostSetID == null) {
            return HostSQLOps.none();
        }
        try {
            hs = hostSetID.getByIDQuery().select();
        }
        catch (NoResultsFoundException e) {
            return HostSQLOps.none();
        }
        return this.isMemberOf(hs.getHostSet());
    }

    ConditionalExpression isMemberOf(HostSetImpl hs) throws PersistenceManagerException, RPCException {
        HostIDSet hostIDs = new HostIDSet();
        HostSearchIDSet searchIDs = new HostSearchIDSet();
        hs.getAllMembers(hostIDs, searchIDs, null);
        boolean hasMember = false;
        OrExp matchingHosts = HostSQLOps.or();
        if (hostIDs.size() > 0) {
            matchingHosts.add(HostSQLOps.emptyIn(this.ID, HostSQLOps.rList(hostIDs.toIDArray())));
            hasMember = true;
        }
        if (searchIDs.size() > 0) {
            MultiHostSearchQuery hsq = searchIDs.getByIDsQuery();
            hsq.setAddResultsToCache(true);
            HostSearch[] searches = hsq.select();
            for (int i = 0; i < searches.length; ++i) {
                HostSearchCriteria criteria = searches[i].getCriteria();
                matchingHosts.add(criteria.getConditional(this));
                hasMember = true;
            }
        }
        return hasMember ? matchingHosts : HostSQLOps.none();
    }

    public ConditionalExpression isExclusiveMemberOf(HostSetID inSet, HostSetID notInSet) throws PersistenceManagerException, RPCException {
        return HostSQLOps.and(this.isMemberOf(inSet), HostSQLOps.not(this.isMemberOf(notInSet)));
    }

    public ConditionalExpression getByAppType(AppTypeCriteria criteria) {
        if (criteria.isEmptyCriteria()) {
            return HostSQLOps.none();
        }
        OrExp result = HostSQLOps.or();
        AppInstanceSQLOps aT = AppInstanceSQLOps.DEFAULT;
        if (criteria.getIncludeMS()) {
            result.add(aT.hasAppType(AppType.MS, this));
        }
        if (criteria.getIncludeLD()) {
            result.add(aT.hasAppType(AppType.LD, this));
        }
        if (criteria.getIncludeRA()) {
            result.add(aT.hasAppType(AppType.RA, this));
        }
        if (criteria.getIncludeNone()) {
            result.add(HostSQLOps.not(aT.hasApp(this)));
        }
        return result;
    }

    public ConditionalExpression getByPhysical(PhysicalCriteria criteria) {
        if (criteria.isEmptyCriteria()) {
            return HostSQLOps.none();
        }
        OrExp result = HostSQLOps.or();
        if (criteria.getIncludePhysical()) {
            result.add(HostSQLOps.isNull(this.ParentHostID));
        }
        if (criteria.getIncludeVirtual()) {
            result.add(HostSQLOps.not(HostSQLOps.isNull(this.ParentHostID)));
        }
        return result;
    }

    public ConditionalExpression getByName(GlobPattern namePattern) {
        return HostSQLOps.likeLower(this.Name, namePattern);
    }

    public ConditionalExpression getByDescription(GlobPattern descPattern) {
        return HostSQLOps.likeLower(this.Description, descPattern);
    }

    public ConditionalExpression getByOSName(GlobPattern osNamePattern) {
        return HostSQLOps.likeLower(this.OSName, osNamePattern);
    }

    public ConditionalExpression getByOSVersion(GlobPattern osVersionPattern) {
        return HostSQLOps.likeLower(this.OSVersion, osVersionPattern);
    }

    public ConditionalExpression getByOSArch(GlobPattern osArchPattern) {
        return HostSQLOps.likeLower(this.OSArch, osArchPattern);
    }

    public ConditionalExpression getByIPAddress(GlobPattern ipPattern) {
        return AppInstanceSQLOps.DEFAULT.hasAppWithIP(ipPattern, this);
    }

    public ConditionalExpression getByHostTypeName(GlobPattern namePattern) {
        return HostTypeSQLOps.DEFAULT.hasTypeWithName(namePattern, this);
    }

    public ConditionalExpression getByVarValue(String varName, GlobPattern value) {
        ConditionalExpression hasMatchingOverride = VarOverrideSQLOps.DEFAULT.hasVarWithValue(varName, value, this);
        ConditionalExpression hasOverride = VarOverrideSQLOps.DEFAULT.hasVar(varName, this);
        ConditionalExpression hasMatchingDefault = VarDeclSQLOps.DEFAULT.hasVarWithValue(varName, value, this);
        return HostSQLOps.or(hasMatchingOverride, HostSQLOps.and(HostSQLOps.not(hasOverride), hasMatchingDefault));
    }

    public ConditionalExpression getByParentHostName(GlobPattern name) {
        HostSQLOps nested = new HostSQLOps("iht");
        return HostSQLOps.exists(nested.select(HostSQLOps.sList(nested.ID), HostSQLOps.where(HostSQLOps.and(HostSQLOps.equals((ColumnNode)nested.ID, this.ParentHostID), nested.getByName(name)))));
    }

    int updateMachineInfo(HostID hostID, MachineInfo newInfo) throws PersistenceManagerException {
        SetList updates = HostSQLOps.uList(HostSQLOps.increment(this.UpdateCount));
        updates.add(HostSQLOps.set(this.OSName, newInfo.getOSName()));
        updates.add(HostSQLOps.set(this.OSVersion, newInfo.getOSVersion()));
        updates.add(HostSQLOps.set(this.OSArch, newInfo.getOSArch()));
        updates.add(HostSQLOps.set(this.RAHomeDir, newInfo.getRAHomeDir()));
        updates.add(HostSQLOps.set(this.RADataDir, newInfo.getRADataDir()));
        updates.add(HostSQLOps.set(this.RAConfigDir, newInfo.getRAConfigDir()));
        updates.add(HostSQLOps.set(this.RATmpDir, newInfo.getRATmpDir()));
        updates.add(HostSQLOps.set(this.RAVersionNumber, newInfo.getRAVersionNumber()));
        updates.add(HostSQLOps.set(this.RABuildNumber, newInfo.getRABuildNumber()));
        updates.add(HostSQLOps.set(this.RAFileSeparator, newInfo.getRAFileSeparator()));
        updates.add(HostSQLOps.set(this.RAPathSeparator, newInfo.getRAPathSeparator()));
        updates.add(HostSQLOps.set(this.MachineInfoTimestamp, new Date()));
        return HostSQLOps.execute(this.update(updates, HostSQLOps.where(HostSQLOps.equals(this.ID, hostID))));
    }
}

