/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImpl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetImpl;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermissionBase;
import com.raplix.util.logger.Logger;
import java.security.Permission;

public abstract class HostPermission
extends ROXPermissionBase
implements ROXPermission {
    public static final String ALL_HOSTS = "allhosts";
    public static final String ANY_HOST = "anyhost";
    public static final String HOST_PREFIX = "host:";
    private static final int HOST_PREFIX_LEN = "host:".length();
    public static final String HOSTSET_PREFIX = "hostset:";
    private static final int HOSTSET_PREFIX_LEN = "hostset:".length();
    private boolean mImpliesAll = false;
    private boolean mTestAny = false;
    private HostID mHostID = null;
    private HostSetID mHostSetID = null;

    public HostPermission(String name) {
        super(name);
        this.validateName(name);
    }

    public HostPermission(HostID hostID) {
        this(HOST_PREFIX + hostID);
    }

    public HostPermission(HostSetID hostSetID) {
        this(HOSTSET_PREFIX + hostSetID);
    }

    public HostPermission(String name, String actions) {
        this(name);
    }

    private void validateName(String name) {
        if (name.equals(ALL_HOSTS)) {
            this.mImpliesAll = true;
        } else if (name.equals(ANY_HOST)) {
            this.mTestAny = true;
        } else {
            int len = name.length();
            if (len <= HOST_PREFIX_LEN) {
                throw this.invalidName(name);
            }
            if (name.startsWith(HOST_PREFIX)) {
                this.mHostID = new HostID(name.substring(HOST_PREFIX_LEN));
            } else if (len > HOSTSET_PREFIX_LEN && name.startsWith(HOSTSET_PREFIX)) {
                this.mHostSetID = new HostSetID(name.substring(HOSTSET_PREFIX_LEN));
            } else {
                throw this.invalidName(name);
            }
        }
    }

    private IllegalArgumentException invalidName(String name) {
        return new IllegalArgumentException("invalid host name: " + name);
    }

    public String getActions() {
        return "";
    }

    public boolean implies(Permission other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (this.impliesAllHosts()) {
            return true;
        }
        HostPermission otherPerm = (HostPermission)other;
        if (otherPerm.impliesAllHosts()) {
            return false;
        }
        if (this.impliedByAnyHost()) {
            return false;
        }
        if (otherPerm.impliedByAnyHost()) {
            return true;
        }
        HostSetID otherHostSetID = otherPerm.getImpliedHostSetID();
        HostSetID thisHostSetID = this.getImpliedHostSetID();
        if (otherHostSetID != null) {
            return thisHostSetID != null && this.implies(thisHostSetID, otherHostSetID);
        }
        HostID otherHostID = otherPerm.getImpliedHostID();
        if (thisHostSetID != null) {
            return this.implies(thisHostSetID, otherHostID);
        }
        return otherHostID.equals(this.getImpliedHostID());
    }

    protected boolean implies(HostSetID hostSet1, HostSetID hostSet2) {
        if (hostSet1.equals(hostSet2)) {
            return true;
        }
        try {
            return hostSet1.containsAll(hostSet2);
        }
        catch (RPCException e) {
            this.handleHostResolutionError(e);
        }
        catch (PersistenceManagerException e) {
            this.handleHostResolutionError(e);
        }
        return false;
    }

    protected void handleHostResolutionError(Exception e) {
        if (Logger.isErrorEnabled(this)) {
            Logger.error("unable to determine host set membership", e, this);
        }
    }

    protected boolean implies(HostSetID hostSet, HostID host) {
        try {
            return hostSet.contains(host);
        }
        catch (RPCException e) {
            this.handleHostResolutionError(e);
        }
        catch (PersistenceManagerException e) {
            this.handleHostResolutionError(e);
        }
        return false;
    }

    public final boolean impliesAllHosts() {
        return this.mImpliesAll;
    }

    public final boolean impliedByAnyHost() {
        return this.mTestAny;
    }

    public final HostSetID getImpliedHostSetID() {
        return this.mHostSetID;
    }

    public final HostID getImpliedHostID() {
        return this.mHostID;
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.getName().equals(((HostPermission)other).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    protected ROXMessage getMessageMS() {
        String objectName = "";
        String objectType = "";
        try {
            if (this.impliesAllHosts()) {
                objectType = "";
                objectName = ALL_HOSTS;
            } else if (this.impliedByAnyHost()) {
                objectType = "";
                objectName = ANY_HOST;
            } else if (this.getImpliedHostID() != null) {
                objectType = PersistenceManager.getObjectName(HostImpl.class).getMessageString();
                objectName = this.getImpliedHostID().getByIDQuery().selectSummaryView().getName();
            } else if (this.getImpliedHostSetID() != null) {
                objectType = PersistenceManager.getObjectName(HostSetImpl.class).getMessageString();
                objectName = this.getImpliedHostSetID().getByIDQuery().selectSummaryView().getName();
            }
            return new ROXMessage(this.getMessageCode(), new Object[]{objectType, objectName});
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error fetching permission text", e, this);
            }
            if (this.getImpliedHostID() != null) {
                objectType = "host";
                objectName = this.getImpliedHostID().toString();
            } else if (this.getImpliedHostSetID() != null) {
                objectType = "hostset";
                objectName = this.getImpliedHostID().toString();
            }
            return new ROXMessage(this.getMessageCode(), new Object[]{objectType, objectName});
        }
    }

    protected abstract String getMessageCode();
}

