/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.SaveResult;
import com.raplix.rolloutexpress.persist.TopLevelTransactionListener;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotSavedQueryException;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBIllegalArgError;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDHaver;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostReservationID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostLink;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostLinkTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostUpdateListener;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiAppInstanceQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.UpdateIncompleteException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarOverride;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarOverrideSQLOps;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.FIFOQueue;
import com.raplix.util.threads.ResourceID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class HostImpl
extends PersistentBean
implements Cloneable {
    private String mName;
    private String mDescription = "";
    private HostTypeID mHostTypeID;
    private HostID mParentHostID;
    private MachineInfo mMachineInfo;
    private Date mMachineInfoTimestamp;
    private String mOSName;
    private String mOSVersion;
    private String mOSArch;
    private String mRAHomeDir;
    private String mRADataDir;
    private String mRAConfigDir;
    private String mRATmpDir;
    private String mRABuildNumber;
    private String mRAVersionNumber;
    private String mRAFileSeparator;
    private String mRAPathSeparator;
    private InstalledComponentID mInstalledComponentID;
    private transient SummaryHost mSummaryView;
    private boolean mExternalDataLoaded = false;
    private VariableSettingsHolder mOverrideVars;
    private HostType mHostType;
    private HostSetIDSet mHostSetIDSet;
    private Hashtable mAppInstances;
    private HostReservationID mHostReservationID;
    private static final String APP_SAVE_NAME = "AppInstances";
    private static final AppType[] NON_MS_TYPES = new AppType[]{AppType.RA, AppType.LD};
    private static final FIFOQueue RESOURCE = new FIFOQueue(1);
    private static final ThreadLocal LOCK = new ThreadLocal();

    private HostImpl() {
    }

    static HostImpl create(HostType hostType) {
        HostImpl result = new HostImpl();
        result.resetExternalData(true);
        result.setHostType(hostType);
        return result;
    }

    HostID getID() {
        return (HostID)super.getObjectID();
    }

    String getName() {
        return this.mName;
    }

    void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mName = name;
    }

    String getDescription() {
        return this.mDescription;
    }

    void setDescription(String desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.mDescription = desc;
    }

    protected Visibility getVisibility() {
        return super.getVisibility();
    }

    protected void setVisibility(Visibility visibility) {
        super.setVisibility(visibility);
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int updateCount) {
        super.setUpdateCount(updateCount);
    }

    HostTypeID getHostTypeID() {
        return this.mHostTypeID;
    }

    private void setHostTypeID(HostTypeID hostTypeID) {
        if (hostTypeID == null) {
            throw new NullPointerException();
        }
        this.mHostTypeID = hostTypeID;
    }

    HostID getParentHostID() {
        return this.mParentHostID;
    }

    void setParentHostID(HostID parentHostID) {
        this.mParentHostID = parentHostID;
    }

    boolean isVirtual() {
        return this.getParentHostID() != null;
    }

    MachineInfo getMachineInfo() {
        if (this.mMachineInfo == null && this.getMachineInfoTimestamp() != null) {
            this.mMachineInfo = new MachineInfo(this);
        }
        return this.mMachineInfo;
    }

    private void setMachineInfo(MachineInfo machineInfo) {
        this.mMachineInfo = machineInfo;
    }

    Date getMachineInfoTimestamp() {
        return this.mMachineInfoTimestamp;
    }

    private void setMachineInfoTimestamp(Date machineInfoTimestamp) {
        this.mMachineInfoTimestamp = machineInfoTimestamp;
    }

    String getOSName() {
        return this.mOSName;
    }

    private void setOSName(String OSName) {
        this.mOSName = OSName;
    }

    String getOSVersion() {
        return this.mOSVersion;
    }

    private void setOSVersion(String OSVersion) {
        this.mOSVersion = OSVersion;
    }

    String getOSArch() {
        return this.mOSArch;
    }

    private void setOSArch(String OSArch) {
        this.mOSArch = OSArch;
    }

    String getRAHomeDir() {
        return this.mRAHomeDir;
    }

    private void setRAHomeDir(String RAHomeDir) {
        this.mRAHomeDir = RAHomeDir;
    }

    String getRADataDir() {
        return this.mRADataDir;
    }

    private void setRADataDir(String RADataDir) {
        this.mRADataDir = RADataDir;
    }

    String getRAConfigDir() {
        return this.mRAConfigDir;
    }

    private void setRAConfigDir(String RAConfigDir) {
        this.mRAConfigDir = RAConfigDir;
    }

    String getRATmpDir() {
        return this.mRATmpDir;
    }

    private void setRATmpDir(String RATmpDir) {
        this.mRATmpDir = RATmpDir;
    }

    String getRABuildNumber() {
        return this.mRABuildNumber;
    }

    private void setRABuildNumber(String RABuildNumber) {
        this.mRABuildNumber = RABuildNumber;
    }

    String getRAVersionNumber() {
        return this.mRAVersionNumber;
    }

    private void setRAVersionNumber(String RAVersionNumber) {
        this.mRAVersionNumber = RAVersionNumber;
    }

    String getRAFileSeparator() {
        return this.mRAFileSeparator;
    }

    private void setRAFileSeparator(String RAFileSeparator) {
        this.mRAFileSeparator = RAFileSeparator;
    }

    String getRAPathSeparator() {
        return this.mRAPathSeparator;
    }

    private void setRAPathSeparator(String RAPathSeparator) {
        this.mRAPathSeparator = RAPathSeparator;
    }

    InstalledComponentID getInstalledComponentID() {
        return this.mInstalledComponentID;
    }

    void setInstalledComponentID(InstalledComponentID inID) {
        this.mInstalledComponentID = inID;
    }

    SummaryHost getSummaryView() {
        if (this.mSummaryView == null) {
            this.mSummaryView = new SummaryHost(this);
        }
        return this.mSummaryView;
    }

    Host getCompleteViewMS() throws PersistenceManagerException {
        this.loadExternalDataMS();
        return new Host(this);
    }

    private boolean isExternalDataLoaded() {
        return this.mExternalDataLoaded;
    }

    private void resetExternalData(boolean isLoadComplete) {
        this.mOverrideVars = new VariableSettingsHolder();
        this.mAppInstances = new Hashtable();
        this.mHostSetIDSet = new HostSetIDSet();
        if (isLoadComplete) {
            this.setExternalDataLoaded();
        }
    }

    private void setExternalDataLoaded() {
        this.mExternalDataLoaded = true;
    }

    private void loadExternalDataMS() throws PersistenceManagerException {
        if (this.isExternalDataLoaded()) {
            return;
        }
        if (this.getID() != null) {
            try {
                HostType hostType = this.getHostTypeID().getByIDQuery().select();
                VarOverride[] overrides = VarOverrideSQLOps.DEFAULT.getByHost(this.getID());
                AppInstance[] apps = MultiAppInstanceQuery.byHost(this.getID()).select();
                Link[] hostSets = HostSetToHostLinkTable.DEFAULT.getByChildID(this.getID());
                this.setExternalDataMS(hostType, Arrays.asList(overrides), Arrays.asList(apps), Arrays.asList(hostSets));
            }
            catch (RPCException e) {
                throw HostDBException.unexpectedRPCException(e);
            }
        } else {
            this.resetExternalData(true);
        }
    }

    static void loadExternalDataMS(List hosts) throws PersistenceManagerException {
        int size = hosts.size();
        if (size == 0) {
            return;
        }
        HostIDSet idSet = new HostIDSet();
        ArrayList<HostImpl> unloadedHosts = new ArrayList<HostImpl>();
        for (int i = 0; i < size; ++i) {
            HostImpl host = (HostImpl)hosts.get(i);
            if (host.isExternalDataLoaded()) continue;
            idSet.add(host.getID());
            unloadedHosts.add(host);
        }
        if (idSet.isEmpty()) {
            return;
        }
        HostID[] hostIDs = idSet.toIDArray();
        try {
            HashMap hostTypeMap = HostImpl.getHostTypesForHostsMS(unloadedHosts);
            HashMap overrideMap = HostImpl.getOverridesForHostsMS(hostIDs);
            HashMap appMap = HostImpl.getAppsForHostsMS(hostIDs);
            HashMap hostSetMap = HostImpl.getHostSetsForHostsMS(hostIDs);
            for (int i = 0; i < size; ++i) {
                HostImpl host = (HostImpl)hosts.get(i);
                if (host.isExternalDataLoaded()) continue;
                HostType hostType = (HostType)hostTypeMap.get(host.getHostTypeID());
                List overrideList = (List)overrideMap.get(host.getID());
                List appList = (List)appMap.get(host.getID());
                List hostSetList = (List)hostSetMap.get(host.getID());
                host.setExternalDataMS(hostType, overrideList, appList, hostSetList);
            }
        }
        catch (RPCException e) {
            throw HostDBException.unexpectedRPCException(e);
        }
    }

    private static HashMap getHostTypesForHostsMS(List hosts) throws PersistenceManagerException, RPCException {
        HostTypeIDSet idSet = new HostTypeIDSet();
        Iterator hostIter = hosts.iterator();
        while (hostIter.hasNext()) {
            HostImpl host = (HostImpl)hostIter.next();
            idSet.add(host.getHostTypeID());
        }
        HostType[] hostTypes = idSet.getByIDsQuery().select();
        HashMap<HostTypeID, HostType> result = new HashMap<HostTypeID, HostType>();
        for (int i = 0; i < hostTypes.length; ++i) {
            result.put(hostTypes[i].getID(), hostTypes[i]);
        }
        return result;
    }

    private static HashMap getOverridesForHostsMS(HostID[] hostIDs) throws PersistenceManagerException {
        return HostImpl.getMapByHostID(VarOverrideSQLOps.DEFAULT.getByHosts(hostIDs));
    }

    private static HashMap getMapByHostID(HostIDHaver[] hostIDHavers) {
        List<HostIDHaver> hostIDHaverList = Arrays.asList(hostIDHavers);
        HashMap<HostID, List<HostIDHaver>> result = new HashMap<HostID, List<HostIDHaver>>();
        int start = 0;
        while (start < hostIDHavers.length) {
            int end;
            HostID hostID = hostIDHavers[start].getHostID();
            for (end = start + 1; end < hostIDHavers.length && hostID.equals(hostIDHavers[end].getHostID()); ++end) {
            }
            result.put(hostID, hostIDHaverList.subList(start, end));
            start = end;
        }
        return result;
    }

    private static HashMap getAppsForHostsMS(HostID[] hostIDs) throws PersistenceManagerException, RPCException {
        HostIDHaver[] apps = MultiAppInstanceQuery.byHosts(hostIDs).select();
        return HostImpl.getMapByHostID(apps);
    }

    private static HashMap getHostSetsForHostsMS(HostID[] hostIDs) throws PersistenceManagerException {
        HostIDHaver[] hostSets = (HostSetToHostLink[])HostSetToHostLinkTable.DEFAULT.getByChildIDs(hostIDs);
        return HostImpl.getMapByHostID(hostSets);
    }

    private synchronized void setExternalDataMS(HostType hostType, List overrideList, List appList, List hostSetList) {
        if (this.isExternalDataLoaded()) {
            return;
        }
        this.resetExternalData(false);
        this.setHostType(hostType);
        if (overrideList != null) {
            Iterator overrides = overrideList.iterator();
            while (overrides.hasNext()) {
                VarOverride override = (VarOverride)overrides.next();
                this.mOverrideVars.setVarValue(override.getVarName(), override.getOverrideValue());
            }
        }
        if (appList != null) {
            Iterator apps = appList.iterator();
            while (apps.hasNext()) {
                AppInstance app = (AppInstance)apps.next();
                this.mAppInstances.put(app.getType(), app);
            }
        }
        Link.addParentIDs(this.mHostSetIDSet, hostSetList);
        this.setExternalDataLoaded();
    }

    String[] getVarNames() {
        return this.mHostType.getVarNames();
    }

    boolean containsVarValue(String varName) {
        return this.mHostType.containsVarValue(varName);
    }

    String[] getOverrideVarNames() {
        return this.mOverrideVars.getVarNames();
    }

    String getVarValue(String varName) {
        String result = this.getOverrideVarValue(varName);
        if (result == null) {
            result = this.mHostType.getVarValue(varName);
        }
        return result;
    }

    String getOverrideVarValue(String varName) {
        if (varName == null) {
            return null;
        }
        return this.mOverrideVars.getVarValue(varName);
    }

    void setOverrideVarValue(String varName, String varValue) {
        if (!this.mHostType.containsVarValue(varName)) {
            throw HostDBIllegalArgError.noSuchVarName(varName);
        }
        this.mOverrideVars.setVarValue(varName, varValue);
    }

    void removeOverrideVarValue(String varName) {
        if (varName != null) {
            this.mOverrideVars.removeVarValue(varName);
        }
    }

    void removeAllOverrideVarValues() {
        this.mOverrideVars.clear();
    }

    boolean containsOverrideVarValue(String varName) {
        if (varName == null) {
            return false;
        }
        return this.mOverrideVars.containsVarValue(varName);
    }

    String getHostTypeName() {
        return this.mHostType.getName();
    }

    HostType getHostType() {
        return (HostType)this.mHostType.clone();
    }

    void setHostType(HostType hostType) {
        this.setHostTypeID(hostType.getID());
        this.mHostType = (HostType)hostType.clone();
        String[] names = this.getOverrideVarNames();
        for (int i = 0; i < names.length; ++i) {
            if (this.mHostType.containsVarValue(names[i])) continue;
            this.removeOverrideVarValue(names[i]);
        }
    }

    HostSetIDSet getHostSetIDSet() {
        return (HostSetIDSet)this.mHostSetIDSet.clone();
    }

    void setHostSetIDSet(HostSetIDSet set) {
        this.mHostSetIDSet = (HostSetIDSet)set.clone();
    }

    AppInstance getAppInstance(AppType appType) {
        AppInstance result = (AppInstance)this.mAppInstances.get(appType);
        if (result != null) {
            result = (AppInstance)result.clone();
        }
        return result;
    }

    boolean containsAppInstance(AppType type) {
        return this.mAppInstances.containsKey(type);
    }

    int numAppInstances() {
        return this.mAppInstances.size();
    }

    void addAppInstance(AppInstance app) {
        if (AppType.MS.equals(app.getType())) {
            throw HostDBIllegalArgError.cannotAddMSAppInstance();
        }
        if (app.getHostID() != null && !app.getHostID().equals(this.getID())) {
            throw HostDBIllegalArgError.invalidAppInstanceHostID();
        }
        this.mAppInstances.put(app.getType(), app.clone());
    }

    boolean removeAppInstance(AppType type) {
        if (AppType.MS.equals(type)) {
            throw HostDBIllegalArgError.cannotRemoveMSAppInstance();
        }
        if (AppType.RA.equals(type)) {
            this.resetMachineInfo();
        }
        return this.mAppInstances.remove(type) != null;
    }

    private void resetMachineInfo() {
        this.setMachineInfoTimestamp(null);
        this.setMachineInfo(null);
        this.setOSName(null);
        this.setOSVersion(null);
        this.setOSArch(null);
        this.setRAHomeDir(null);
        this.setRADataDir(null);
        this.setRAConfigDir(null);
        this.setRATmpDir(null);
        this.setRAVersionNumber(null);
        this.setRAFileSeparator(null);
        this.setRAPathSeparator(null);
        this.setRABuildNumber(null);
    }

    AppInstance[] getInternalAppInstances() {
        return this.mAppInstances.values().toArray(new AppInstance[0]);
    }

    AppInstance[] getAppInstances() {
        AppInstance[] result = this.getInternalAppInstances();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (AppInstance)result[i].clone();
        }
        return result;
    }

    RoxAddress getRARoxAddress() throws HostDBException {
        AppInstance ra = (AppInstance)this.mAppInstances.get(AppType.RA);
        if (ra == null) {
            throw HostDBException.noRAOnHost(this.getName());
        }
        return ra.getRoxAddress();
    }

    HostReservationID getHostReservationID() {
        return this.mHostReservationID;
    }

    void setHostReservationID(HostReservationID inID) {
        this.mHostReservationID = inID;
    }

    protected Object clone() {
        try {
            HostImpl result = (HostImpl)super.clone();
            Hashtable clonedApps = (Hashtable)result.mAppInstances.clone();
            Iterator appEntries = clonedApps.entrySet().iterator();
            while (appEntries.hasNext()) {
                Map.Entry appEntry = appEntries.next();
                AppInstance app = (AppInstance)appEntry.getValue();
                appEntry.setValue(app.clone());
            }
            result.mAppInstances = clonedApps;
            result.mOverrideVars = (VariableSettingsHolder)result.mOverrideVars.clone();
            result.mSummaryView = null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Object getObjectDataClone() {
        try {
            HostImpl result = (HostImpl)super.getObjectDataClone();
            result.resetMachineInfo();
            result.setHostReservationID(null);
            Iterator appEntries = result.mAppInstances.entrySet().iterator();
            while (appEntries.hasNext()) {
                Map.Entry appEntry = appEntries.next();
                AppInstance app = (AppInstance)appEntry.getValue();
                if (AppType.MS.equals(app.getType())) {
                    appEntries.remove();
                    continue;
                }
                appEntry.setValue(app.getDataClone());
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void save() throws HostDBException, PersistenceManagerException, RPCException {
        try {
            try {
                this.validate();
                this.saveRPC(null);
            }
            catch (UpdateIncompleteException e) {
                this.setSaveResult(e.getSaveResult());
                throw e;
            }
            Object var3_1 = null;
            if (this.getHostReservationID() == null) return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (this.getHostReservationID() == null) throw throwable;
            HostDBSubsystem.getInstance().releaseReservation(this.getHostReservationID());
            this.setHostReservationID(null);
            throw throwable;
        }
        HostDBSubsystem.getInstance().releaseReservation(this.getHostReservationID());
        this.setHostReservationID(null);
    }

    protected void saveMS(PersistContext context) throws PersistenceManagerException {
        HostImpl.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                HostImpl.this.notifyTrSaveMS();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTrSaveMS() throws PersistenceManagerException {
        boolean registered = false;
        HostImpl.acquireHostLock();
        try {
            boolean isUpdate = this.getID() != null;
            Host origHost = isUpdate ? this.loadFreshHostMS() : null;
            this.trSaveMS();
            HostImpl copy = (HostImpl)this.clone();
            Host newHost = new Host(copy);
            HostUpdateListener notifier = HostDBSubsystem.getInstance().getHostUpdateNotifier();
            if (isUpdate) {
                notifier.validateHostUpdated(newHost, origHost);
            } else {
                notifier.validateHostAdded(newHost);
            }
            this.registerCallbackMS(notifier, newHost, origHost);
            registered = true;
        }
        finally {
            if (!registered) {
                HostImpl.releaseHostLock();
            }
        }
    }

    private void registerCallbackMS(final HostUpdateListener notifier, final Host newHost, final Host origHost) throws PersistenceManagerException {
        TopLevelTransactionListener saveCallback = new TopLevelTransactionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transactionComplete(boolean isCommitted) throws UpdateIncompleteException {
                try {
                    if (!isCommitted) {
                        return;
                    }
                    try {
                        if (origHost != null) {
                            notifier.hostUpdated(newHost, origHost);
                        } else {
                            notifier.hostAdded(newHost);
                        }
                    }
                    catch (UpdateIncompleteException e) {
                        try {
                            e.setSaveResult(HostImpl.this.createSaveResult());
                        }
                        catch (PersistenceManagerException persistenceManagerException) {
                            // empty catch block
                        }
                        throw e;
                    }
                }
                finally {
                    HostImpl.releaseHostLock();
                }
            }

            public void aboutToComplete(boolean isCommittable) {
            }
        };
        HostImpl.getTransactionManagerMS().registerTopLevelTransactionListener(saveCallback);
    }

    private Host loadFreshHostMS() throws PersistenceManagerException {
        try {
            return this.getID().getByIDQuery().select();
        }
        catch (RPCException e) {
            throw HostDBException.unexpectedRPCException(e);
        }
    }

    private void trSaveMS() throws PersistenceManagerException {
        HostSQLOps.DEFAULT.checkWritePermission();
        if (this.getHostReservationID() != null) {
            HostDBSubsystem.getInstance().releaseReservation(this.getHostReservationID());
            this.setHostReservationID(null);
        }
        if (HostDBSubsystem.getInstance().isReservedHostName(this.getCompleteViewMS().getName())) {
            throw HostDBException.reservationConflict();
        }
        AppInstance[] apps = this.getAppInstances();
        for (int i = 0; i < apps.length; ++i) {
            if (!HostDBSubsystem.getInstance().isReservedHostAddress(apps[i].getIPAddress())) continue;
            throw HostDBException.reservationConflict();
        }
        this.validateParentHostMS();
        HostID ID2 = this.getID();
        ObjectID[] hostSets = this.mHostSetIDSet.toIDArray();
        HostSetSQLOps.DEFAULT.incrUpdateCountsByHost(ID2, (HostSetID[])hostSets);
        if (ID2 != null) {
            HostSetToHostLinkTable.DEFAULT.resetLinks(hostSets, ID2, true);
            ID2.lockForUpdateMS();
            VarOverrideSQLOps.DEFAULT.removeByHost(ID2);
            this.saveAppInstancesMS(ID2, true);
            this.checkHostTypeCountMS();
            super.saveMS(null);
        } else {
            this.checkHostTypeCountMS();
            super.saveMS(null);
            ID2 = this.getID();
            this.saveAppInstancesMS(ID2, false);
            HostSetToHostLinkTable.DEFAULT.resetLinks(hostSets, ID2, false);
        }
        this.saveOverrideVarsMS(ID2);
    }

    private void validateParentHostMS() throws PersistenceManagerException {
        HostID parentID;
        HostID id = this.getID();
        if (id == null) {
            return;
        }
        HostIDSet visited = new HostIDSet();
        SummaryHost current = this.getSummaryView();
        while ((parentID = current.getParentHostID()) != null) {
            visited.add(current.getID());
            if (visited.contains(parentID)) {
                throw HostDBException.virtualHostCycle();
            }
            try {
                current = parentID.getByIDQuery().selectSummaryView();
            }
            catch (RPCException e) {
                throw HostDBException.unexpectedRPCException(e);
            }
        }
    }

    private void saveOverrideVarsMS(HostID hostID) throws PersistenceManagerException {
        VariableSettingsHolder overrideVars = this.mOverrideVars;
        String[] varNames = overrideVars.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            String overrideValue = overrideVars.getVarValue(varNames[i]);
            VarOverride override = new VarOverride(hostID, this.getHostTypeID(), varNames[i], overrideValue);
            override.saveMS();
        }
    }

    private void checkHostTypeCountMS() throws PersistenceManagerException {
        try {
            SummaryHostType savedHostType = this.getHostTypeID().getByIDQuery().selectSummaryView();
            if (savedHostType.getUpdateCount() != this.mHostType.getUpdateCount()) {
                ROXMessage msg = new ROXMessage("hostdb.HOST_TYPE_MODIFIED", 2000);
                throw new ObjectNotSavedQueryException(msg);
            }
        }
        catch (RPCException e) {
            throw HostDBException.unexpectedRPCException(e);
        }
    }

    private void saveAppInstancesMS(HostID hostID, boolean isUpdate) throws PersistenceManagerException {
        if (isUpdate) {
            AppInstanceSQLOps.DEFAULT.createUniquePorts(hostID, NON_MS_TYPES);
        }
        for (int i = 0; i < NON_MS_TYPES.length; ++i) {
            AppType type = NON_MS_TYPES[i];
            AppInstance app = (AppInstance)this.mAppInstances.get(type);
            if (isUpdate) {
                AppInstanceID appID = app == null ? null : app.getID();
                AppInstanceSQLOps.DEFAULT.removeByHostAndTypeAndNotID(hostID, type, appID);
            }
            if (app == null) continue;
            app.saveMS(hostID);
        }
    }

    protected SaveResult createSaveResult() throws PersistenceManagerException {
        Hashtable<AppType, SaveResult> resultMap = new Hashtable<AppType, SaveResult>();
        for (int i = 0; i < NON_MS_TYPES.length; ++i) {
            AppType type = NON_MS_TYPES[i];
            AppInstance app = (AppInstance)this.mAppInstances.get(type);
            if (app == null) continue;
            resultMap.put(type, app.createSaveResult());
        }
        SaveResult result = super.createSaveResult();
        result.setObjectAssociationResult(APP_SAVE_NAME, resultMap);
        return result;
    }

    protected void setSaveResult(SaveResult saveResult) throws PersistenceManagerException {
        super.setSaveResult(saveResult);
        Hashtable appSaveResults = (Hashtable)saveResult.getObjectAssociationResult(APP_SAVE_NAME);
        for (int i = 0; i < NON_MS_TYPES.length; ++i) {
            AppType type = NON_MS_TYPES[i];
            SaveResult result = (SaveResult)appSaveResults.get(type);
            if (result == null) continue;
            AppInstance app = (AppInstance)this.mAppInstances.get(type);
            app.setSaveResult(result);
        }
    }

    void validate() throws HostDBException {
        this.validateVirtual();
        Host.validateName(this.getName());
        Host.validateDescription(this.getDescription());
        String[] names = this.mOverrideVars.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            Host.validateOverrideValue(this.mOverrideVars.getVarValue(names[i]));
        }
        Iterator apps = this.mAppInstances.values().iterator();
        while (apps.hasNext()) {
            AppInstance app = (AppInstance)apps.next();
            app.validate();
        }
    }

    private void validateVirtual() throws HostDBException {
        if (this.isVirtual() && this.mAppInstances.size() > 0) {
            throw HostDBException.virtualHostApps();
        }
    }

    static void acquireHostLock() throws PersistenceManagerException {
        HostImpl.getHostDBLock().acquire();
    }

    static void releaseHostLock() {
        HostImpl.getHostDBLock().release();
    }

    private static ThreadLock getHostDBLock() {
        ThreadLock result = (ThreadLock)LOCK.get();
        if (result == null) {
            result = new ThreadLock();
            LOCK.set(result);
        }
        return result;
    }

    static /* synthetic */ FIFOQueue access$100() {
        return RESOURCE;
    }

    private static class ThreadLock {
        private Context mContext = new Context("hostLock");
        private ResourceID mResourceID = this.mContext.register(HostImpl.access$100());

        public void acquire() throws PersistenceManagerException {
            try {
                this.mContext.acquireNested(this.mResourceID);
            }
            catch (Exception e) {
                throw new PersistenceManagerException();
            }
        }

        public void release() {
            try {
                this.mContext.releaseNested(this.mResourceID);
            }
            catch (Exception e) {
                throw new InternalError();
            }
        }
    }
}

