/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsTable;
import com.raplix.rolloutexpress.difference.differencedb.MultiDifferenceSettingsQuery;
import com.raplix.rolloutexpress.event.rule.CriteriaToHostLinkTable;
import com.raplix.rolloutexpress.event.rule.MultiCriteriaQuery;
import com.raplix.rolloutexpress.event.rule.PersistentCriteriaMetaData;
import com.raplix.rolloutexpress.event.rule.PersistentCriteriaMetaDataTable;
import com.raplix.rolloutexpress.executor.target.MultiTargetQuery;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetSQLOps;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.TopLevelTransactionListener;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.cache.SingleObjectByNameCache;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImpl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetToHostLinkTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostUpdateListener;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.UpdateIncompleteException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarOverrideSQLOps;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiSnapshotQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.Snapshot;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotToHostLinkTable;
import com.raplix.util.logger.Logger;
import java.util.HashSet;

public class HostID
extends ObjectID {
    private static final IDFactory ID_FACTORY = new IDFactory();

    private HostID() {
    }

    public HostID(String key) {
        super(key);
    }

    public SingleHostQuery getByIDQuery() {
        return new SingleHostQuery(this);
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        HostID.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                HostID.this.notifyTrDeleteMS();
                return null;
            }
        });
    }

    private void notifyTrDeleteMS() throws PersistenceManagerException {
        boolean registered = false;
        HostImpl.acquireHostLock();
        try {
            Host origHost = this.getByIDQuery().select();
            this.trDeleteMS();
            HostUpdateListener notifier = HostDBSubsystem.getInstance().getHostUpdateNotifier();
            notifier.validateHostDeleted(origHost);
            this.registerCallbackMS(notifier, origHost);
            registered = true;
        }
        catch (RPCException e) {
            throw HostDBException.unexpectedRPCException(e);
        }
        finally {
            if (!registered) {
                HostImpl.releaseHostLock();
            }
        }
    }

    private void registerCallbackMS(final HostUpdateListener notifier, final Host origHost) throws PersistenceManagerException {
        TopLevelTransactionListener deleteCallback = new TopLevelTransactionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transactionComplete(boolean isCommitted) throws UpdateIncompleteException {
                try {
                    if (isCommitted) {
                        notifier.hostDeleted(origHost);
                    }
                }
                finally {
                    HostImpl.releaseHostLock();
                }
            }

            public void aboutToComplete(boolean isCommitable) {
            }
        };
        HostID.getTransactionManagerMS().registerTopLevelTransactionListener(deleteCallback);
    }

    private void trDeleteMS() throws PersistenceManagerException {
        SnapshotToHostLinkTable.DEFAULT.removeByChildID(this);
        HostSetToHostLinkTable.DEFAULT.incrParentUpdateCounts(HostSetSQLOps.DEFAULT, this);
        HostSetToHostLinkTable.DEFAULT.removeByChildID(this);
        this.lockForUpdateMS();
        VarOverrideSQLOps.DEFAULT.removeByHost(this);
        AppInstanceSQLOps.DEFAULT.removeByHost(this);
        ComponentImplTable ct = ComponentImplTable.DEFAULT;
        ComponentImplTable.execute(ComponentImplTable.update(ct, ComponentImplTable.uList(ComponentImplTable.set(ct.SourceInfoRawHostID, (ObjectID)null)), ComponentImplTable.where(ComponentImplTable.equals(ct.SourceInfoRawHostID, this))));
        ResourceTable rt = ResourceTable.DEFAULT;
        ResourceTable.execute(ResourceTable.update(rt, ResourceTable.uList(ResourceTable.set(rt.SourceHostID, (ObjectID)null)), ResourceTable.where(ResourceTable.equals(rt.SourceHostID, this))));
        super.deleteMS(null);
    }

    protected void lockForUpdateMS() throws PersistenceManagerException {
        super.lockForUpdateMS();
    }

    public MultiHostQuery getVirtualChildHostsQuery() {
        return MultiHostQuery.byParentID(this);
    }

    public boolean isSupported() throws PersistenceManagerException, RPCException {
        BoolCtx result = (BoolCtx)HostID.transactRPC(new RPCTransaction(false){

            protected PersistContext executeMS() throws PersistenceManagerException {
                try {
                    return new BoolCtx(HostID.this.trIsSupportedMS());
                }
                catch (RPCException e) {
                    throw HostDBException.unexpectedRPCException(e);
                }
            }
        });
        return result.mValue;
    }

    boolean trIsSupportedMS() throws PersistenceManagerException, RPCException {
        MultiHostSetQuery q = MultiHostSetQuery.all();
        q.setIsSupportedFilter(Boolean.FALSE);
        q.setVisibilityFilter(null);
        SummaryHostSet[] unsupportedSets = q.selectSummaryView();
        for (int i = 0; i < unsupportedSets.length; ++i) {
            if (!unsupportedSets[i].getID().contains(this)) continue;
            return false;
        }
        return true;
    }

    boolean isPrepared() throws RPCException, PersistenceManagerException {
        BoolCtx result = (BoolCtx)HostID.transactRPC(new RPCTransaction(false){

            protected PersistContext executeMS() throws PersistenceManagerException {
                try {
                    return new BoolCtx(HostID.this.trIsPreparedMS());
                }
                catch (RPCException e) {
                    throw HostDBException.unexpectedRPCException(e);
                }
            }
        });
        return result.mValue;
    }

    boolean trIsPreparedMS() throws PersistenceManagerException, RPCException {
        return !MultiSystemServiceRefQuery.byUninstalled(this).selectExists();
    }

    public MachineInfo refreshMachineInfo() throws PersistenceManagerException, RPCException {
        MachineInfoCtx result = (MachineInfoCtx)HostID.transactRPC(new RPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                return HostID.this.trRefreshMachineInfoMS();
            }
        });
        return result.getMachineInfo();
    }

    private MachineInfoCtx trRefreshMachineInfoMS() throws PersistenceManagerException {
        MachineInfo mi = HostDBSubsystem.getInstance().getMachineInfo(this);
        this.trUpdateMachineInfoMS(mi);
        return new MachineInfoCtx(mi);
    }

    public void setMachineInfo(final MachineInfo mi) throws PersistenceManagerException, RPCException {
        HostID.transactRPC(new RPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                HostID.this.trUpdateMachineInfoMS(mi);
                return null;
            }
        });
    }

    private void trUpdateMachineInfoMS(MachineInfo mi) throws PersistenceManagerException {
        HostSQLOps.DEFAULT.updateMachineInfo(this, mi);
    }

    public static HostID generateID() {
        return (HostID)ID_FACTORY.generateObjectID();
    }

    public SummaryHost getPhysicalHost() throws PersistenceManagerException, RPCException {
        SummaryHost root = this.getByIDQuery().selectSummaryView();
        while (root.getParentHostID() != null) {
            root = root.getParentHostID().getByIDQuery().selectSummaryView();
        }
        return root;
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("Examining Host " + this.toString() + " for dependent objects", "persist.objectdeletion");
        }
        if (Host.HOST_SENTINEL_ID.equals(this)) {
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Host cannot be deleted because it's the sentinel host", "persist.objectdeletion");
            }
            throw new ObjectNotDeletableException(new ROXMessage("pm.CANNOT_DELETE_OBJECT"));
        }
        if (Host.MASTER_SERVER_ID.equals(this)) {
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Host cannot be deleted because it's the master server host", "persist.objectdeletion");
            }
            throw new ObjectNotDeletableException(new ROXMessage("pm.CANNOT_DELETE_OBJECT"));
        }
        try {
            MultiDifferenceSettingsQuery mdsq = MultiDifferenceSettingsQuery.allVersions();
            mdsq.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    DifferenceSettingsTable t = (DifferenceSettingsTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(DifferenceSettingsTable.or(DifferenceSettingsTable.equals(t.SrcHostID, HostID.this.toString()), DifferenceSettingsTable.equals(t.DstHostID, HostID.this.toString())));
                }
            });
            UsingObject[] users = mdsq.select();
            if (null != users && users.length > 0) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Host in use by difference settings", "persist.objectdeletion");
                }
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), users);
            }
            MultiTargetQuery mtq = MultiTargetQuery.all();
            mtq.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    TargetSQLOps t = (TargetSQLOps)ctx.getFirstTable();
                    ctx.addAndWhereCondition(t.equalsHost(HostID.this, null));
                }
            });
            HasObjectID[] targets = mtq.selectSummaryView();
            HashSet<TargetID> targetIDs = new HashSet<TargetID>();
            for (int i = 0; i < targets.length; ++i) {
                targetIDs.add(targets[i].getID());
            }
            Snapshot[] snaps = MultiSnapshotQuery.byHostID(this).select();
            if (snaps.length > 0) {
                for (int i = 0; i < snaps.length; ++i) {
                    InstalledComponent ic = snaps[i].getInstalledComponentID().getByIDQuery().select();
                    if (targetIDs.contains(ic.getTargetID())) continue;
                    if (Logger.isDebugEnabled("persist.objectdeletion")) {
                        Logger.debug("Host in use by snapshot", "persist.objectdeletion");
                    }
                    throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{snaps[i]});
                }
            }
            if (null != (users = MultiHostQuery.byAppParent(this).selectSummaryView()) && users.length > 0) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Host in use as an appinstance", "persist.objectdeletion");
                }
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), users);
            }
            MultiCriteriaQuery mcrq = MultiCriteriaQuery.all();
            mcrq.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    PersistentCriteriaMetaDataTable t = (PersistentCriteriaMetaDataTable)ctx.getFirstTable();
                    CriteriaToHostLinkTable lt = CriteriaToHostLinkTable.DEFAULT;
                    ctx.addAndWhereCondition(PersistentCriteriaMetaDataTable.in((ColumnNode)t.ID, lt.selectParentIDs(HostID.this)));
                }
            });
            PersistentCriteriaMetaData[] criteria = (PersistentCriteriaMetaData[])mcrq.selectObjects();
            if (criteria.length > 0) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Host in use by notification rule", "persist.objectdeletion");
                }
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{criteria[0]});
            }
            SummaryHost theHost = this.getByIDQuery().selectSummaryView();
            if (theHost.getInstalledComponentID() != null && !inContext.objectWillBeDeletedAfter(theHost.getInstalledComponentID(), this) && theHost.getInstalledComponentID().getByIDQuery().select().isInstalled()) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{theHost.getInstalledComponentID().getByIDQuery().select().getComponentID().getByIDQuery().selectSummaryView()});
            }
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Host collection dependent target objects", "persist.objectdeletion");
            }
            inDependentContainer.addAllDependentObjects(targets);
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Host collection dependent virtual hosts", "persist.objectdeletion");
            }
            inDependentContainer.addAllDependentObjects(MultiHostQuery.byParentID(this).selectObjects());
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        HostIDSet idset = new HostIDSet();
        idset.add(this);
        return idset;
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new HostID(inID);
        }

        public void registerCaches(ClassMap classMap, ObjectCache objectCache) {
            HostImplTable t = HostImplTable.DEFAULT;
            SingleObjectByNameCache cache = new SingleObjectByNameCache(objectCache, t.Name);
            classMap.addSingleObjectCache(cache);
        }
    }

    private static final class MachineInfoCtx
    extends PersistContext {
        private MachineInfo mMachineInfo;

        public MachineInfoCtx(MachineInfo mi) {
            this.setMachineInfo(mi);
        }

        public MachineInfo getMachineInfo() {
            return this.mMachineInfo;
        }

        private void setMachineInfo(MachineInfo machineInfo) {
            this.mMachineInfo = machineInfo;
        }
    }

    private static final class BoolCtx
    extends PersistContext {
        boolean mValue;

        public BoolCtx(boolean value) {
            this.mValue = value;
        }
    }
}

