/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.RequiredConfiguration;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCInterface;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImpl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostReservationID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetUpdateListener;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostUpdateListener;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Messages;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiAppInstanceQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.UpdateIncompleteException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.UpdateNotAcceptedException;
import com.raplix.util.enum.NoSuchEnumException;
import com.raplix.util.logger.Logger;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class HostDBSubsystem
extends Subsystem
implements Messages {
    private static final String DEFAULT_CONFIG_ENABLE_DUPLICATE_IPS = "false";
    private static final String DEFAULT_CONFIG_MS_CONNECTION_TYPE = "raw";
    private static DefaultConfiguration[] sDefaultConfiguration = new DefaultConfiguration[]{new DefaultConfiguration("hostdb.enableDuplicateIPs", "false", "allow saving multiple hosts with the same ip addresses (true|false)"), new RequiredConfiguration("hostdb.ms.ipaddress", "master server ip address"), new RequiredConfiguration("hostdb.ms.port", "master server port"), new DefaultConfiguration("hostdb.ms.connectiontype", "raw", "master server connection type (raw|ssl)")};
    private RoxAddress mMSRoxAddress;
    private boolean mEnableDuplicateIPs;
    private ConnectionType mMSConnectionType;
    private HostUpdateListener mHostUpdateListener;
    private HostUpdateListener mHostUpdateNotifier = new HostUpdateListener(){

        public void validateHostAdded(Host host) throws UpdateNotAcceptedException {
            if (HostDBSubsystem.this.mHostUpdateListener != null) {
                HostDBSubsystem.this.mHostUpdateListener.validateHostAdded(host);
            }
        }

        public void hostAdded(Host host) throws UpdateIncompleteException {
            if (HostDBSubsystem.this.mHostUpdateListener != null) {
                HostDBSubsystem.this.mHostUpdateListener.hostAdded(host);
            }
        }

        public void validateHostDeleted(Host host) throws UpdateNotAcceptedException {
            if (HostDBSubsystem.this.mHostUpdateListener != null) {
                HostDBSubsystem.this.mHostUpdateListener.validateHostDeleted(host);
            }
        }

        public void hostDeleted(Host host) throws UpdateIncompleteException {
            if (HostDBSubsystem.this.mHostUpdateListener != null) {
                HostDBSubsystem.this.mHostUpdateListener.hostDeleted(host);
            }
        }

        public void validateHostUpdated(Host newHost, Host origHost) throws UpdateNotAcceptedException {
            if (HostDBSubsystem.this.mHostUpdateListener != null) {
                HostDBSubsystem.this.mHostUpdateListener.validateHostUpdated(newHost, origHost);
            }
        }

        public void hostUpdated(Host newHost, Host origHost) throws UpdateIncompleteException {
            if (HostDBSubsystem.this.mHostUpdateListener != null) {
                HostDBSubsystem.this.mHostUpdateListener.hostUpdated(newHost, origHost);
            }
        }
    };
    private Vector mHostSetListeners = new Vector();
    private Hashtable mHostToReservationCollection = new Hashtable();
    private Hashtable mAddressToReservationCollection = new Hashtable();
    private Hashtable mReservationToHostCollection = new Hashtable();
    private HostSetUpdateListener mHostSetUpdateNotifier = new HostSetUpdateListener(){

        public void hostSetAdded(HostSetID hostSetID) throws UpdateNotAcceptedException {
            Iterator listeners = HostDBSubsystem.this.mHostSetListeners.iterator();
            while (listeners.hasNext()) {
                HostSetUpdateListener listener = (HostSetUpdateListener)listeners.next();
                listener.hostSetAdded(hostSetID);
            }
        }

        public void hostSetDeleted(HostSetID hostSetID) throws UpdateNotAcceptedException {
            Iterator listeners = HostDBSubsystem.this.mHostSetListeners.iterator();
            while (listeners.hasNext()) {
                HostSetUpdateListener listener = (HostSetUpdateListener)listeners.next();
                listener.hostSetDeleted(hostSetID);
            }
        }
    };
    private static HostDBSubsystem sInstance;

    private HostDBSubsystem() {
    }

    public HostDBSubsystem(Application app) throws ConfigurationException {
        super(app);
        try {
            this.setMSRoxAddress(new RoxAddress(this.getConfigMSIP(), this.getConfigMSPort()));
        }
        catch (TransportException e) {
            ROXMessage message = new ROXMessage("hostdb.INVALID_MS_ADDR_CONFIG");
            throw new ConfigurationException(message, (Throwable)e);
        }
        try {
            this.setMSConnectionType(ConnectionType.FACTORY.get(this.getConfigMSConnectionType()));
        }
        catch (NoSuchEnumException e) {
            throw new ConfigurationException("hostdb.INVALID_MS_CONNECTION_TYPE_CONFIG", (Throwable)e, new String[]{this.getConfigMSConnectionType()});
        }
        this.setEnableDuplicateIPs(this.getConfigEnableDuplicateIPs());
        sInstance = this;
    }

    public void postInit() throws ConfigurationException {
        this.updateMasterServerConfig();
        this.validateAppIPs();
    }

    private void updateMasterServerConfig() throws ConfigurationException {
        try {
            TransactionManager tm = PersistenceManager.getInstance().getTransactionManager();
            tm.transact(new Transaction(){

                public Object execute() throws PersistenceManagerException {
                    HostDBSubsystem.this.trUpdateMasterServerConfig(HostDBSubsystem.this.getMSRoxAddress());
                    return null;
                }
            });
        }
        catch (PersistenceManagerException e) {
            ROXMessage message = new ROXMessage("hostdb.CANNOT_CONFIGURE_MS_APP");
            throw new ConfigurationException(message, (Throwable)e);
        }
    }

    private void trUpdateMasterServerConfig(RoxAddress msAddr) throws PersistenceManagerException {
        try {
            HostID msHostID = Host.MASTER_SERVER_ID;
            HostSQLOps.DEFAULT.execIncrUpdateCountByID(msHostID);
            AppInstance msApp = AppInstance.MASTER_SERVER_ID.getByIDQuery().select();
            msApp.setRoxAddress(this.getMSRoxAddress());
            msApp.setConnectionType(this.getMSConnectionType());
            msApp.validate();
            msApp.saveMS(msHostID);
        }
        catch (RPCException e) {
            throw HostDBException.unexpectedRPCException(e);
        }
    }

    private void validateAppIPs() throws ConfigurationException {
        if (this.getEnableDuplicateIPs()) {
            return;
        }
        MultiAppInstanceQuery appsWithDupIPs = MultiAppInstanceQuery.byDuplicateIP();
        try {
            if (appsWithDupIPs.selectExists()) {
                ROXMessage message = new ROXMessage("hostdb.STARTUP_DUPLICATE_IPS");
                throw new ConfigurationException(message);
            }
        }
        catch (PersistenceManagerException e) {
            ROXMessage message = new ROXMessage("hostdb.ERROR_VALIDATING_IPS");
            throw new ConfigurationException(message, (Throwable)e);
        }
        catch (RPCException e) {
            ROXMessage message = new ROXMessage("hostdb.ERROR_VALIDATING_IPS");
            throw new ConfigurationException(message, (Throwable)e);
        }
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        return sDefaultConfiguration;
    }

    public boolean getConfigEnableDuplicateIPs() throws ConfigurationException {
        return this.getConfigurationAsBoolean("hostdb.enableDuplicateIPs");
    }

    public String getConfigMSIP() throws ConfigurationException {
        return this.getConfigurationAsString("hostdb.ms.ipaddress");
    }

    public int getConfigMSPort() throws ConfigurationException {
        return this.getConfigurationAsInt("hostdb.ms.port");
    }

    public String getConfigMSConnectionType() throws ConfigurationException {
        return this.getConfigurationAsString("hostdb.ms.connectiontype");
    }

    RoxAddress getMSRoxAddress() {
        return this.mMSRoxAddress;
    }

    private void setMSRoxAddress(RoxAddress MSRoxAddress) {
        this.mMSRoxAddress = MSRoxAddress;
    }

    boolean getEnableDuplicateIPs() {
        return this.mEnableDuplicateIPs;
    }

    private void setEnableDuplicateIPs(boolean enableDuplicateIPs) {
        this.mEnableDuplicateIPs = enableDuplicateIPs;
    }

    ConnectionType getMSConnectionType() {
        return this.mMSConnectionType;
    }

    private void setMSConnectionType(ConnectionType MSConnectionType) {
        this.mMSConnectionType = MSConnectionType;
    }

    public void registerHostUpdateListener(HostUpdateListener listener) {
        this.mHostUpdateListener = listener;
    }

    HostUpdateListener getHostUpdateNotifier() {
        return this.mHostUpdateNotifier;
    }

    public void addHostSetUpdateListener(HostSetUpdateListener listener) {
        this.mHostSetListeners.add(listener);
    }

    public boolean removeHostSetUpdateListener(HostSetUpdateListener listener) {
        return this.mHostSetListeners.remove(listener);
    }

    public HostReservationID reserveHost(String inName, String inAddress) throws PersistenceManagerException, TransportException {
        if (inName == null || inName.length() == 0) {
            throw new NullPointerException();
        }
        String address = inAddress;
        if (address != null) {
            address = new RoxAddress(inAddress, 0).ipString();
        }
        HostImpl.acquireHostLock();
        try {
            if (this.mHostToReservationCollection.containsKey(inName) || SingleHostQuery.byName(inName).selectExists()) {
                throw HostDBException.reservationConflict();
            }
            if (address != null && address.length() > 0 && (this.mAddressToReservationCollection.containsKey(address) || MultiAppInstanceQuery.byIPNotHost(HostID.generateID(), address).selectExists())) {
                throw HostDBException.reservationConflict();
            }
            HostReservationID newReservation = HostReservationID.generateID();
            this.mHostToReservationCollection.put(inName, newReservation);
            if (address != null && address.length() > 0) {
                this.mAddressToReservationCollection.put(address, newReservation);
            }
            this.mReservationToHostCollection.put(newReservation, new HostAddressTuple(inName, address));
            HostReservationID hostReservationID = newReservation;
            return hostReservationID;
        }
        catch (RPCException e) {
            throw HostDBException.unexpectedRPCException(e);
        }
        finally {
            HostImpl.releaseHostLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReservation(HostReservationID inID) throws PersistenceManagerException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Releasing reservation: " + inID, this);
        }
        if (null == inID) {
            throw new NullPointerException();
        }
        HostImpl.acquireHostLock();
        try {
            HostAddressTuple tuple = (HostAddressTuple)this.mReservationToHostCollection.remove(inID);
            if (null == tuple) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("No reservation to release - not allowed!", this);
                }
                throw HostDBException.noReservation();
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Releasing reservation for " + tuple + " (" + inID + ")", this);
            }
            this.mHostToReservationCollection.remove(tuple.getName());
            if (null != tuple.getAddress()) {
                this.mAddressToReservationCollection.remove(tuple.getAddress());
            }
        }
        finally {
            HostImpl.releaseHostLock();
        }
    }

    boolean isReservedHostName(String inName) {
        return this.mHostToReservationCollection.containsKey(inName);
    }

    boolean isReservedHostAddress(String inAddress) {
        return this.mAddressToReservationCollection.containsKey(inAddress);
    }

    HostSetUpdateListener getHostSetUpdateNotifier() {
        return this.mHostSetUpdateNotifier;
    }

    MachineInfo getMachineInfo(HostID hostID) throws PersistenceManagerException {
        try {
            Host h = hostID.getByIDQuery().select();
            RoxAddress addr = h.getRARoxAddress();
            MachineInfoManager mim = (MachineInfoManager)this.getApplication().getRPCInterface(addr, MachineInfoManager.class);
            return mim.getMachineInfo();
        }
        catch (RPCException e) {
            throw HostDBException.unexpectedRPCException(e);
        }
    }

    public static void registerAgentServices(RPCManager rpc, Application app) throws RPCException {
        rpc.registerService(MachineInfoManager.class, new MachineInfoManagerImpl(app));
    }

    public static HostDBSubsystem getInstance() throws HostDBException {
        if (sInstance == null) {
            throw HostDBException.noHostDBSubsystem();
        }
        return sInstance;
    }

    private static class MachineInfoManagerImpl
    implements MachineInfoManager {
        private Application mApp;

        public MachineInfoManagerImpl(Application app) {
            this.mApp = app;
        }

        public MachineInfo getMachineInfo() {
            return MachineInfo.createFromSystemProps(this.mApp);
        }
    }

    private static interface MachineInfoManager
    extends RPCInterface {
        public MachineInfo getMachineInfo() throws RPCException;
    }

    private static final class HostAddressTuple {
        private String mName;
        private String mAddress;

        private HostAddressTuple(String inName, String inAddress) {
            this.mName = inName;
            this.mAddress = inAddress;
        }

        private String getName() {
            return this.mName;
        }

        private String getAddress() {
            return this.mAddress;
        }

        public String toString() {
            StringBuffer output = new StringBuffer();
            output.append("name: " + this.getName() + " address: ");
            if (this.getAddress() == null) {
                output.append("<none specified>");
            } else {
                output.append(this.getAddress());
            }
            return output.toString();
        }
    }
}

