/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Messages;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ReservationNotFoundException;

public class HostDBException
extends PersistenceManagerException
implements Messages {
    protected HostDBException() {
    }

    protected HostDBException(ROXMessage msg) {
        super(msg);
    }

    protected HostDBException(Throwable t) {
        super(t);
    }

    protected HostDBException(ROXMessage msg, Throwable t) {
        super(msg, t, 1);
    }

    static HostDBException invalidHostTypeName(String name) {
        return HostDBException.newValidationError("hostdb.INVALID_HOSTTYPE_NAME", name);
    }

    static HostDBException cannotDeleteMSHost() {
        return HostDBException.newValidationError("hostdb.CANNOT_DELETE_MS_HOST");
    }

    static HostDBException invalidHostTypeDescription(String desc) {
        return HostDBException.newValidationError("hostdb.INVALID_HOSTTYPE_DESC", desc);
    }

    static HostDBException reservedVarName(String name) {
        return HostDBException.newValidationError("hostdb.RESERVED_VAR_NAME", name);
    }

    static HostDBException invalidVarName(String name) {
        return HostDBException.newValidationError("hostdb.INVALID_VAR_NAME", name);
    }

    static HostDBException invalidVarDefaultValue(String value) {
        return HostDBException.newValidationError("hostdb.INVALID_VAR_DEFAULT", value);
    }

    static HostDBException invalidHostName(String name) {
        return HostDBException.newValidationError("hostdb.INVALID_HOST_NAME", name);
    }

    static HostDBException invalidHostDescription(String desc) {
        return HostDBException.newValidationError("hostdb.INVALID_HOST_DESC", desc);
    }

    static HostDBException invalidVarOverrideValue(String value) {
        return HostDBException.newValidationError("hostdb.INVALID_VAR_OVERRIDE", value);
    }

    static HostDBException invalidAppSSHPort(int port) {
        return HostDBException.newValidationError("hostdb.INVALID_APP_SSH_PORT", port);
    }

    static HostDBException invalidAppRawPort(int port) {
        return HostDBException.newValidationError("hostdb.INVALID_APP_RAW_PORT", port);
    }

    static HostDBException invalidAppIPAddress(String addr) {
        return HostDBException.newValidationError(MSG_INVALID_APP_IP, addr);
    }

    static HostDBException emptyAppParentID() {
        return HostDBException.newValidationError("hostdb.EMPTY_APP_PARENT");
    }

    static HostDBException invalidMSAppParentID(AppInstanceID parentID) {
        return HostDBException.newValidationError("hostdb.INVALID_MS_APP_PARENT", parentID);
    }

    static HostDBException invalidMSConnectionType(ConnectionType connectionType) {
        return HostDBException.newValidationError("hostdb.INVALID_MS_CONNECTION_TYPE_CONFIG", connectionType);
    }

    static HostDBException invalidAppParentType() {
        return HostDBException.newValidationError("hostdb.INVALID_APP_PARENT_TYPE");
    }

    static HostDBException noAppParent() {
        return HostDBException.newValidationError("hostdb.NO_APP_PARENT");
    }

    static HostDBException invalidHostSetName(String name) {
        return HostDBException.newValidationError("hostdb.INVALID_HOSTSET_NAME", name);
    }

    static HostDBException invalidHostSetDescription(String desc) {
        return HostDBException.newValidationError("hostdb.INVALID_HOSTSET_DESC", desc);
    }

    static HostDBException hostSetCycle() {
        return HostDBException.newValidationError("hostdb.HOSTSET_CYCLE");
    }

    static HostDBException invalidSearchName(String name) {
        return HostDBException.newValidationError("hostdb.INVALID_SEARCH_NAME", name);
    }

    static HostDBException invalidSearchDescription(String desc) {
        return HostDBException.newValidationError("hostdb.INVALID_SEARCH_DESC", desc);
    }

    static HostDBException emptySearchCriteria() {
        return HostDBException.newValidationError("hostdb.EMPTY_SEARCH_CRITERIA");
    }

    static HostDBException unexpectedRPCException(RPCException e) {
        return new HostDBException(e);
    }

    static HostDBException reservationConflict() {
        return new HostDBException(new ROXMessage("hostdb.RESERVATION_CONFLICT"));
    }

    static HostDBException noReservation() {
        return new ReservationNotFoundException(new ROXMessage("hostdb.NO_RESERVATION"));
    }

    static HostDBException virtualHostApps() {
        return HostDBException.newValidationError("hostdb.VIRTUAL_HOST_APPS");
    }

    static HostDBException virtualHostCycle() {
        return HostDBException.newValidationError("hostdb.VIRTUAL_HOST_CYCLE");
    }

    static HostDBException noRAOnHost(String hostname) {
        return HostDBException.newValidationError("hostdb.NO_RA_ON_HOST", hostname);
    }

    static HostDBException noHostDBSubsystem() {
        return HostDBException.newSystemError("hostdb.NO_HOSTDB_SUBSYSTEM");
    }

    static HostDBException duplicateAppIP(String ip) {
        return HostDBException.newValidationError("hostdb.DUPLICATE_APP_IP", ip);
    }

    static HostDBException invalidPort(String port) {
        return HostDBException.newValidationError("hostdb.INVALID_APP_RAW_PORT", port);
    }

    static HostDBException invalidTRAddressChange() {
        return HostDBException.newValidationError("hostdb.INVALID_TR_ADDRESS_CHANGE");
    }

    static HostDBException invalidAppParentChange() {
        return HostDBException.newValidationError("hostdb.INVALID_APP_PARENT_CHANGE");
    }

    static HostDBException invalidTRTypeChange() {
        return HostDBException.newValidationError("hostdb.INVALID_TR_TYPE_CHANGE");
    }

    static HostDBException reservationRequired() {
        return HostDBException.newValidationError("hostdb.RESERVATION_REQUIRED");
    }

    static HostDBException reservationForbidden() {
        return HostDBException.newValidationError("hostdb.RESERVATION_NOT_ALLOWED");
    }

    private static HostDBException newValidationError(String code) {
        return HostDBException.newValidationError(code, new Object[0]);
    }

    private static HostDBException newSystemError(String code) {
        return HostDBException.newSystemError(code, new Object[0]);
    }

    private static HostDBException newValidationError(String code, Object arg) {
        return HostDBException.newValidationError(code, new Object[]{arg});
    }

    private static HostDBException newValidationError(String code, int arg) {
        return HostDBException.newValidationError(code, new Object[]{new Integer(arg)});
    }

    private static HostDBException newValidationError(String code, Object[] args) {
        ROXMessage msg = new ROXMessage(code, args, 2000);
        return new HostDBException(msg);
    }

    private static HostDBException newSystemError(String code, Object[] args) {
        ROXMessage msg = new ROXMessage(code, args, 3000);
        return new HostDBException(msg);
    }
}

