/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImpl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostReservationID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Messages;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostTypeQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.util.Validate;

public class Host
extends SummaryHost
implements VariableSettingsSource,
Cloneable,
Messages {
    public static final HostID MASTER_SERVER_ID = new HostID("010010001024-0000000000000-00001-0000000005");
    public static final HostID HOST_SENTINEL_ID = new HostID("010010001024-0000000000000-00005-0000000005");
    private boolean mHostIsCopy;
    private static final int MAX_NAME_LEN = 512;

    public Host(HostType hostType) {
        super(HostImpl.create(hostType));
        this.mHostIsCopy = true;
    }

    public Host() throws RPCException, PersistenceManagerException {
        this(SystemPluginConstants.getInstance().DEFAULT_HOST_TYPE_ID.getByIDQuery().select());
    }

    public Host(TargetRef inTargetRef, InstalledComponentID inInstalledComponentID, HostReservationID inID) throws RPCException, PersistenceManagerException, TransportException {
        this(SingleHostTypeQuery.byName(inTargetRef.getTypeName()).select());
        this.setName(inTargetRef.getHostName());
        if (null == inInstalledComponentID || null == inID) {
            throw new NullPointerException();
        }
        this.getMutableHost().setHostReservationID(inID);
        Host currentTarget = this.getICTarget(inInstalledComponentID);
        if (inTargetRef.isVirtual()) {
            this.setParentHostID(currentTarget.getID());
        } else {
            AppInstance app = new AppInstance(AppType.RA);
            AppInstance currentAgent = currentTarget.getAppRA();
            app.setParentID(currentAgent.getParentID());
            app.setConnectionType(inTargetRef.getConnection());
            app.setParameters(inTargetRef.getParams());
            app.setRoxAddress(new RoxAddress(inTargetRef.getIPAddr(), Integer.parseInt(inTargetRef.getPort())));
            this.addAppInstance(app);
        }
        this.setInstalledComponentID(inInstalledComponentID);
    }

    Host(HostImpl host) {
        super(host);
        this.mHostIsCopy = false;
    }

    public void reinstallTargetableComponentHost(TargetRef inTargetRef, InstalledComponentID inInstalledComponentID, HostReservationID inReservationID) throws PersistenceManagerException, RPCException, TransportException {
        if (inTargetRef.isVirtual() != this.isVirtual()) {
            throw HostDBException.invalidTRTypeChange();
        }
        AppInstance raApp = this.getAppInstance(AppType.RA);
        RoxAddress currentAddr = null;
        RoxAddress newAddr = null;
        if (!inTargetRef.isVirtual()) {
            newAddr = new RoxAddress(inTargetRef.getIPAddr(), Integer.parseInt(inTargetRef.getPort()));
        }
        if (!this.isVirtual()) {
            currentAddr = raApp.getRoxAddress();
            if (!newAddr.ipString().equals(currentAddr.ipString())) {
                throw HostDBException.invalidTRAddressChange();
            }
            AppInstance currentRAApp = this.getICTarget(this.getInstalledComponentID()).getAppRA();
            AppInstance newRAApp = this.getICTarget(inInstalledComponentID).getAppRA();
            if (!currentRAApp.getParentID().equals(newRAApp.getParentID())) {
                throw HostDBException.invalidAppParentChange();
            }
        }
        if (inReservationID == null) {
            if (!inTargetRef.getHostName().equals(this.getName())) {
                throw HostDBException.reservationRequired();
            }
        } else if (inTargetRef.getHostName().equals(this.getName())) {
            throw HostDBException.reservationForbidden();
        }
        this.setInstalledComponentID(null);
        this.setName(inTargetRef.getHostName());
        this.setHostType(SingleHostTypeQuery.byName(inTargetRef.getTypeName()).select());
        this.getMutableHost().setHostReservationID(inReservationID);
        if (!this.isVirtual()) {
            raApp.setConnectionType(inTargetRef.getConnection());
            raApp.setParameters(inTargetRef.getParams());
            raApp.setRoxAddress(newAddr);
            this.removeAppInstance(AppType.RA);
            this.addAppInstance(raApp);
        }
        this.setInstalledComponentID(inInstalledComponentID);
    }

    protected Host getICTarget(InstalledComponentID icid) throws RPCException, PersistenceManagerException {
        InstalledComponent currentIC = icid.getByIDQuery().select();
        SummaryTarget st = currentIC.getTargetID().getByIDQuery().selectSummaryView();
        return st.getCurrentHostID().getByIDQuery().select();
    }

    private HostImpl getMutableHost() {
        if (!this.mHostIsCopy) {
            this.setHost((HostImpl)this.getHost().clone());
            this.mHostIsCopy = true;
        }
        return this.getHost();
    }

    public void setName(String name) {
        if (this.getInstalledComponentID() != null) {
            throw new UnsupportedOperationException();
        }
        this.getMutableHost().setName(name);
    }

    public void setDescription(String desc) {
        this.getMutableHost().setDescription(desc);
    }

    public void setParentHostID(HostID hostID) {
        if (this.getInstalledComponentID() != null) {
            throw new UnsupportedOperationException();
        }
        this.getMutableHost().setParentHostID(hostID);
    }

    public void setVisibility(Visibility visibility) {
        this.getMutableHost().setVisibility(visibility);
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableHost().setUpdateCount(updateCount);
    }

    private void setInstalledComponentID(InstalledComponentID inID) {
        this.getMutableHost().setInstalledComponentID(inID);
    }

    public String[] getVarNames() {
        return this.getHost().getVarNames();
    }

    public String[] getOverrideVarNames() {
        return this.getHost().getOverrideVarNames();
    }

    public String getVarValue(String varName) {
        return this.getHost().getVarValue(varName);
    }

    public String getOverrideVarValue(String varName) {
        return this.getHost().getOverrideVarValue(varName);
    }

    public void setOverrideVarValue(String varName, String varValue) {
        this.getMutableHost().setOverrideVarValue(varName, varValue);
    }

    public void removeOverrideVarValue(String varName) {
        this.getMutableHost().removeOverrideVarValue(varName);
    }

    public void removeAllOverrideVarValues() {
        this.getMutableHost().removeAllOverrideVarValues();
    }

    public boolean containsVarValue(String varName) {
        return this.getHost().containsVarValue(varName);
    }

    public boolean containsOverrideVarValue(String varName) {
        return this.getHost().containsOverrideVarValue(varName);
    }

    public HostType getHostType() {
        return this.getHost().getHostType();
    }

    String getHostTypeName() {
        return this.getHost().getHostTypeName();
    }

    public void setHostType(HostType hostType) {
        if (this.getInstalledComponentID() != null) {
            throw new UnsupportedOperationException();
        }
        this.getMutableHost().setHostType(hostType);
    }

    public HostSetIDSet getHostSetIDSet() {
        return this.getHost().getHostSetIDSet();
    }

    public void setHostSetIDSet(HostSetIDSet IDSet) {
        this.getMutableHost().setHostSetIDSet(IDSet);
    }

    public AppInstance getAppInstance(AppType appType) {
        return this.getHost().getAppInstance(appType);
    }

    public void addAppInstance(AppInstance appInstance) {
        if (this.getInstalledComponentID() != null) {
            throw new UnsupportedOperationException();
        }
        this.getMutableHost().addAppInstance(appInstance);
    }

    public boolean removeAppInstance(AppType appType) {
        if (this.getInstalledComponentID() != null) {
            throw new UnsupportedOperationException();
        }
        return this.getMutableHost().removeAppInstance(appType);
    }

    public AppInstance[] getAppInstances() {
        return this.getHost().getAppInstances();
    }

    boolean containsAppInstance(AppType type) {
        return this.getHost().containsAppInstance(type);
    }

    int numAppInstances() {
        return this.getHost().numAppInstances();
    }

    public AppInstance getAppRA() {
        return this.getAppInstance(AppType.RA);
    }

    public AppInstance getAppMS() {
        return this.getAppInstance(AppType.MS);
    }

    public AppInstance getAppLD() {
        return this.getAppInstance(AppType.LD);
    }

    public RoxAddress getRARoxAddress() throws HostDBException {
        return this.getHost().getRARoxAddress();
    }

    public Host getDataClone() {
        return new Host((HostImpl)this.getHost().getObjectDataClone());
    }

    public Object clone() {
        if (this.mHostIsCopy) {
            return new Host((HostImpl)this.getHost().clone());
        }
        return new Host(this.getHost());
    }

    public void save() throws HostDBException, PersistenceManagerException, RPCException {
        this.getMutableHost().save();
    }

    public void validate() throws HostDBException {
        this.getHost().validate();
    }

    public static void validateName(String name) throws HostDBException {
        if (name == null) {
            throw HostDBException.invalidHostName(name);
        }
        int len = name.length();
        if (len < 1 || len > 512) {
            throw HostDBException.invalidHostName(name);
        }
        if (!Host.isValidNameStart(name.charAt(0))) {
            throw HostDBException.invalidHostName(name);
        }
        for (int i = 1; i < len; ++i) {
            if (Host.isValidNameChar(name.charAt(i))) continue;
            throw HostDBException.invalidHostName(name);
        }
    }

    private static boolean isValidNameStart(char ch) {
        return Character.isLetter(ch) || ch == '_';
    }

    private static boolean isValidNameChar(char ch) {
        return Host.isValidNameStart(ch) || Character.isDigit(ch) || ch == '.' || ch == '-';
    }

    public static void validateDescription(String desc) throws HostDBException {
        if (!Validate.isValidObjectDescription(desc)) {
            throw HostDBException.invalidHostDescription(desc);
        }
    }

    public static void validateOverrideValue(String value) throws HostDBException {
        if (!Validate.isValidObjectDescription(value)) {
            throw HostDBException.invalidVarOverrideValue(value);
        }
    }

    public static void validateTargetableComponentHost(TargetRef inTargetRef) throws HostDBException {
        Host.validateName(inTargetRef.getHostName());
        if (inTargetRef.getIPAddr() != null) {
            try {
                RoxAddress addr = new RoxAddress(inTargetRef.getIPAddr(), Integer.parseInt(inTargetRef.getPort()));
                AppInstance.validateIPAddress(addr.ipString());
                AppInstance.validatePort(addr.getPort(), inTargetRef.getConnection());
                AppInstance.validateConnectionType(inTargetRef.getConnection(), AppType.RA);
            }
            catch (TransportException e) {
                throw new HostDBException(e);
            }
            catch (NumberFormatException e) {
                throw HostDBException.invalidPort(inTargetRef.getPort());
            }
        }
    }

    public static void acquireHostLock() throws PersistenceManagerException {
        HostImpl.acquireHostLock();
    }

    public static void releaseHostLock() {
        HostImpl.releaseHostLock();
    }
}

