/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ComparisonType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.DescriptionCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.IPAddressCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.NameCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.OSArchCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.OSNameCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.OSVersionCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ParentCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarCriteria;
import com.raplix.util.regex.GlobPattern;
import com.raplix.util.regex.RegExSyntaxException;

public abstract class AttributeCriteria
extends PersistentBean
implements RPCSerializable,
Cloneable {
    public static final String ATTR_NAME = "sys.hostName";
    public static final String ATTR_DESCRIPTION = "sys.description";
    public static final String ATTR_HOST_TYPE = "sys.hostType";
    public static final String ATTR_IP_ADDRESS = "sys.ipAddress";
    public static final String ATTR_PARENT = "sys.parent";
    public static final String ATTR_OS_NAME = "sys.OS";
    public static final String ATTR_OS_VERSION = "sys.OSVersion";
    public static final String ATTR_OS_ARCH = "sys.OSArch";
    private ComparisonType mComparisonType;
    private GlobPattern mValuePattern;
    private HostSearchID mHostSearchID;

    AttributeCriteria() {
    }

    AttributeCriteria(ComparisonType compType, GlobPattern valuePattern) {
        this.setComparisonType(compType);
        this.setValuePattern(valuePattern);
    }

    public static AttributeCriteria create(String attributeName, ComparisonType compType, GlobPattern valuePattern) {
        if (attributeName.equals(ATTR_NAME)) {
            return new NameCriteria(compType, valuePattern);
        }
        if (attributeName.equals(ATTR_DESCRIPTION)) {
            return new DescriptionCriteria(compType, valuePattern);
        }
        if (attributeName.equals(ATTR_HOST_TYPE)) {
            return new HostTypeCriteria(compType, valuePattern);
        }
        if (attributeName.equals(ATTR_IP_ADDRESS)) {
            return new IPAddressCriteria(compType, valuePattern);
        }
        if (attributeName.equals(ATTR_PARENT)) {
            return new ParentCriteria(compType, valuePattern);
        }
        if (attributeName.equals(ATTR_OS_NAME)) {
            return new OSNameCriteria(compType, valuePattern);
        }
        if (attributeName.equals(ATTR_OS_VERSION)) {
            return new OSVersionCriteria(compType, valuePattern);
        }
        if (attributeName.equals(ATTR_OS_ARCH)) {
            return new OSArchCriteria(compType, valuePattern);
        }
        return new VarCriteria(attributeName, compType, valuePattern);
    }

    public abstract String getAttributeName();

    public ComparisonType getComparisonType() {
        return this.mComparisonType;
    }

    public void setComparisonType(ComparisonType comparisonType) {
        if (comparisonType == null) {
            throw new NullPointerException();
        }
        this.mComparisonType = comparisonType;
    }

    public GlobPattern getValuePattern() {
        return this.mValuePattern;
    }

    public void setValuePattern(GlobPattern valuePattern) {
        if (valuePattern == null) {
            throw new NullPointerException();
        }
        this.mValuePattern = valuePattern;
    }

    private void setValuePatternString(String pat) {
        this.setValuePattern(GlobPattern.create(pat));
    }

    private String getValuePatternString() {
        return this.getValuePattern().toString();
    }

    GlobPattern getComparisonValuePattern() {
        if (ComparisonType.EQUALS.equals(this.getComparisonType())) {
            return this.getValuePattern();
        }
        return GlobPattern.create("*" + this.getValuePattern() + "*");
    }

    private String getComparisonValuePatternSQL() {
        return this.getComparisonValuePattern().toSQLPattern();
    }

    private void setComparisonValuePatternSQL(String sql) {
    }

    abstract ConditionalExpression getConditional(HostSQLOps var1);

    abstract boolean matches(Host var1);

    boolean matches(String value) {
        try {
            value = value.toLowerCase();
            return this.getComparisonValuePattern().toRegEx().match(value);
        }
        catch (RegExSyntaxException e) {
            return false;
        }
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer buf) {
        buf.append(this.getAttributeName());
        buf.append(" ");
        buf.append(this.getComparisonType());
        buf.append(" ");
        this.quote(buf, this.getValuePattern().toString());
        return buf;
    }

    private void quote(StringBuffer buf, String str) {
        buf.append("\"");
        int len = str.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append("\"");
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof AttributeCriteria)) {
            return false;
        }
        AttributeCriteria otherCriteria = (AttributeCriteria)other;
        return this.getAttributeName().equals(otherCriteria.getAttributeName()) && this.getComparisonType().equals(otherCriteria.getComparisonType()) && this.getValuePattern().equals(otherCriteria.getValuePattern());
    }

    public int hashCode() {
        return this.getAttributeName().hashCode() + this.getComparisonType().hashCode() + this.getValuePattern().hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private AttributeCriteria getDataClone() {
        try {
            return (AttributeCriteria)super.getObjectDataClone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void saveMS(HostSearchID hostSearchID) throws PersistenceManagerException {
        AttributeCriteria copy = this.getDataClone();
        copy.setHostSearchID(hostSearchID);
        copy.saveMS((PersistContext)null);
    }

    HostSearchID getHostSearchID() {
        return this.mHostSearchID;
    }

    private void setHostSearchID(HostSearchID hostSearchID) {
        this.mHostSearchID = hostSearchID;
    }
}

