/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;

public class AppTypeCriteria
implements RPCSerializable,
Cloneable {
    private boolean mIncludeRA = false;
    private boolean mIncludeMS = false;
    private boolean mIncludeLD = false;
    private boolean mIncludeNone = false;
    public static final String OPTION_ENABLED = "t";
    public static final String OPTION_DISABLED = "f";

    public boolean getIncludeRA() {
        return this.mIncludeRA;
    }

    public void setIncludeRA(boolean includeRA) {
        this.mIncludeRA = includeRA;
    }

    public boolean getIncludeMS() {
        return this.mIncludeMS;
    }

    public void setIncludeMS(boolean includeMS) {
        this.mIncludeMS = includeMS;
    }

    public boolean getIncludeLD() {
        return this.mIncludeLD;
    }

    public void setIncludeLD(boolean includeLD) {
        this.mIncludeLD = includeLD;
    }

    public boolean getIncludeNone() {
        return this.mIncludeNone;
    }

    public void setIncludeNone(boolean includeNone) {
        this.mIncludeNone = includeNone;
    }

    ConditionalExpression getConditional(HostSQLOps hostTable) {
        return hostTable.getByAppType(this);
    }

    boolean matches(Host h) {
        if (this.getIncludeRA() && h.containsAppInstance(AppType.RA)) {
            return true;
        }
        if (this.getIncludeLD() && h.containsAppInstance(AppType.LD)) {
            return true;
        }
        if (this.getIncludeMS() && h.containsAppInstance(AppType.MS)) {
            return true;
        }
        return this.getIncludeNone() && h.numAppInstances() == 0;
    }

    public boolean isEmptyCriteria() {
        return !this.getIncludeMS() && !this.getIncludeLD() && !this.getIncludeRA() && !this.getIncludeNone();
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer buf) {
        this.appendOption(buf, this.getIncludeMS());
        buf.append("|");
        this.appendOption(buf, this.getIncludeLD());
        buf.append("|");
        this.appendOption(buf, this.getIncludeRA());
        buf.append("|");
        this.appendOption(buf, this.getIncludeNone());
        return buf;
    }

    private void appendOption(StringBuffer buf, boolean option) {
        if (option) {
            buf.append(OPTION_ENABLED);
        } else {
            buf.append(OPTION_DISABLED);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof AppTypeCriteria)) {
            return false;
        }
        AppTypeCriteria otherCriteria = (AppTypeCriteria)other;
        return this.getIncludeMS() == otherCriteria.getIncludeMS() && this.getIncludeLD() == otherCriteria.getIncludeLD() && this.getIncludeRA() == otherCriteria.getIncludeRA() && this.getIncludeNone() == otherCriteria.getIncludeNone();
    }

    public int hashCode() {
        int result = 0;
        if (this.getIncludeMS()) {
            result |= 1;
        }
        if (this.getIncludeLD()) {
            result |= 2;
        }
        if (this.getIncludeRA()) {
            result |= 4;
        }
        if (this.getIncludeNone()) {
            result |= 8;
        }
        return result;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void reset() {
        this.setIncludeMS(false);
        this.setIncludeRA(false);
        this.setIncludeLD(false);
        this.setIncludeNone(false);
    }
}

