/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.util.regex.GlobPattern;

class AppInstanceSQLOps
extends AppInstanceImplTable {
    public static final AppInstanceSQLOps DEFAULT = new AppInstanceSQLOps();

    public AppInstanceSQLOps(String alias) {
        super(alias);
    }

    private AppInstanceSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new AppInstanceSQLOps(alias);
    }

    public ConditionalExpression isInHosts(HostID[] hostIDs) {
        return AppInstanceSQLOps.emptyIn(this.HostID, AppInstanceSQLOps.rList(hostIDs));
    }

    public ConditionalExpression isInHost(HostID hostID) {
        return AppInstanceSQLOps.equals(this.HostID, hostID);
    }

    private OrderByList orderByHostName(QueryContext ctx) {
        HostSQLOps hostT = new HostSQLOps("hostT");
        ctx.addTable(hostT);
        ctx.addAndWhereCondition(AppInstanceSQLOps.equals((ColumnNode)hostT.ID, this.HostID));
        return AppInstanceSQLOps.dictOrderAsc(hostT.Name);
    }

    public OrderByList orderByTypeAsc(QueryContext ctx) {
        return AppInstanceSQLOps.oList(AppInstanceSQLOps.orderByAsc(this.Type)).add(this.orderByHostName(ctx));
    }

    public OrderByList orderByTypeDesc(QueryContext ctx) {
        return AppInstanceSQLOps.oList(AppInstanceSQLOps.orderByDesc(this.Type)).add(this.orderByHostName(ctx));
    }

    public OrderByList orderByHostIDAsc(QueryContext ctx) {
        return AppInstanceSQLOps.oList(AppInstanceSQLOps.orderByAsc(this.HostID));
    }

    public int createUniquePorts(HostID hostID, AppType[] types) throws PersistenceManagerException {
        return AppInstanceSQLOps.execute(this.update(AppInstanceSQLOps.uList(AppInstanceSQLOps.set((ColumnNode)this.Port, AppInstanceSQLOps.times(AppInstanceSQLOps.v(-1), this.Port))), AppInstanceSQLOps.where(AppInstanceSQLOps.and(AppInstanceSQLOps.equals(this.HostID, hostID), AppInstanceSQLOps.emptyIn(this.Type, AppInstanceSQLOps.rList(types))))));
    }

    public int removeByHost(HostID hostID) throws PersistenceManagerException {
        return AppInstanceSQLOps.execute(this.delete(AppInstanceSQLOps.where(AppInstanceSQLOps.equals(this.HostID, hostID))));
    }

    public int removeByHostAndTypeAndNotID(HostID hostID, AppType type, AppInstanceID curApp) throws PersistenceManagerException {
        AndExp conditions = AppInstanceSQLOps.and(AppInstanceSQLOps.equals(this.HostID, hostID), AppInstanceSQLOps.equals(this.Type, type));
        if (curApp != null) {
            conditions.add(AppInstanceSQLOps.not(AppInstanceSQLOps.equals(this.ID, curApp)));
        }
        return AppInstanceSQLOps.execute(this.delete(AppInstanceSQLOps.where(conditions)));
    }

    public Select selectHosts() {
        return this.select(AppInstanceSQLOps.sList(this.HostID));
    }

    public ConditionalExpression matchesAddress(RoxAddress addr) {
        return AppInstanceSQLOps.and(AppInstanceSQLOps.equals(this.IPAddress, addr.getIPAddress()), AppInstanceSQLOps.equals(this.Port, addr.getPort()));
    }

    public ConditionalExpression hasAppWithIP(GlobPattern ipPat, HostImplTable hT) {
        return AppInstanceSQLOps.exists(this.select(AppInstanceSQLOps.sList(this.HostID), AppInstanceSQLOps.where(AppInstanceSQLOps.and(AppInstanceSQLOps.equals((ColumnNode)this.HostID, hT.ID), AppInstanceSQLOps.likeLower(this.IPAddressString, ipPat)))));
    }

    public ConditionalExpression isIPNotHost(HostID hostID, String ip) {
        return AppInstanceSQLOps.and(AppInstanceSQLOps.equals(this.IPAddressString, ip), AppInstanceSQLOps.notEquals(this.HostID, hostID));
    }

    public ConditionalExpression isDuplicateIP() {
        AppInstanceSQLOps a1 = new AppInstanceSQLOps("a1");
        AppInstanceSQLOps a2 = new AppInstanceSQLOps("a2");
        Select appsWithDups = AppInstanceSQLOps.select(AppInstanceSQLOps.sList(a1.ID), AppInstanceSQLOps.tList(a1, (TableClause)a2), AppInstanceSQLOps.where(AppInstanceSQLOps.and(AppInstanceSQLOps.equals((ColumnNode)a1.IPAddress, a2.IPAddress), AppInstanceSQLOps.notEquals((ColumnNode)a1.HostID, a2.HostID))));
        return AppInstanceSQLOps.in((ColumnNode)this.ID, appsWithDups);
    }

    public Select selectDominantAppTypeForHost(IDColumn hostID) {
        return this.select(AppInstanceSQLOps.sList(AppInstanceSQLOps.min(this.Type)), AppInstanceSQLOps.where(AppInstanceSQLOps.equals((ColumnNode)this.HostID, hostID)));
    }

    public ConditionalExpression hasAppType(AppType type, HostImplTable ht) {
        return AppInstanceSQLOps.exists(this.select(AppInstanceSQLOps.sList(this.ID), AppInstanceSQLOps.where(AppInstanceSQLOps.and(AppInstanceSQLOps.equals((ColumnNode)this.HostID, ht.ID), AppInstanceSQLOps.equals(this.Type, type)))));
    }

    public ConditionalExpression hasApp(HostImplTable ht) {
        return AppInstanceSQLOps.exists(this.select(AppInstanceSQLOps.sList(this.ID), AppInstanceSQLOps.where(AppInstanceSQLOps.equals((ColumnNode)this.HostID, ht.ID))));
    }

    Select getAppChildren(HostID inHostID) {
        AppInstanceSQLOps a1 = new AppInstanceSQLOps("a1");
        AppInstanceSQLOps a2 = new AppInstanceSQLOps("a2");
        Select inner = a1.select(AppInstanceSQLOps.sList(a1.ID), AppInstanceSQLOps.where(AppInstanceSQLOps.equals(a1.HostID, inHostID)));
        return a2.select(AppInstanceSQLOps.sList(a2.HostID), AppInstanceSQLOps.where(AppInstanceSQLOps.in((ColumnNode)a2.ParentID, inner)));
    }
}

