/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.SaveResult;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiAppInstanceQuery;

class AppInstanceImpl
extends PersistentBean
implements Cloneable {
    private AppType mType;
    private ConnectionType mConnectionType = ConnectionType.RAW;
    private RoxAddress mRoxAddress;
    private int mPort = 0;
    private int mIPAddress = 0;
    private String mIPAddressString = "0.0.0.0";
    private String mParameters = "";
    private HostID mHostID;
    private AppInstanceID mParentID;

    AppInstanceImpl() {
    }

    AppInstanceImpl(AppType appType) {
        this.setType(appType);
    }

    AppInstanceID getID() {
        return (AppInstanceID)this.getObjectID();
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int count) {
        super.setUpdateCount(count);
    }

    AppType getType() {
        return this.mType;
    }

    private void setType(AppType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.mType = type;
    }

    ConnectionType getConnectionType() {
        return this.mConnectionType;
    }

    void setConnectionType(ConnectionType connectionType) {
        if (connectionType == null) {
            throw new NullPointerException();
        }
        this.mConnectionType = connectionType;
    }

    RoxAddress getRoxAddress() {
        if (this.mRoxAddress == null) {
            this.mRoxAddress = new RoxAddress(this.getIPAddress(), this.getPort());
        }
        return this.mRoxAddress;
    }

    void setRoxAddress(RoxAddress roxAddress) {
        this.setPort(roxAddress.getPort());
        this.setIPAddress(roxAddress.getIPAddress());
        this.setIPAddressString(roxAddress.ipString());
        this.mRoxAddress = roxAddress;
    }

    int getPort() {
        return this.mPort;
    }

    private void setPort(int port) {
        this.mPort = port;
        this.mRoxAddress = null;
    }

    private int getIPAddress() {
        return this.mIPAddress;
    }

    private void setIPAddress(int IPAddress) {
        this.mIPAddress = IPAddress;
        this.mRoxAddress = null;
    }

    String getIPAddressString() {
        return this.mIPAddressString;
    }

    private void setIPAddressString(String IPAddressString) {
        this.mIPAddressString = IPAddressString;
    }

    String getParameters() {
        return this.mParameters;
    }

    void setParameters(String parameters) {
        this.mParameters = parameters == null ? "" : parameters;
    }

    HostID getHostID() {
        return this.mHostID;
    }

    private void setHostID(HostID hostID) {
        this.mHostID = hostID;
    }

    AppInstanceID getParentID() {
        return this.mParentID;
    }

    void setParentID(AppInstanceID parentID) {
        this.mParentID = parentID;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Object getObjectDataClone() {
        try {
            AppInstanceImpl result = (AppInstanceImpl)super.getObjectDataClone();
            result.setHostID(null);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void validate() throws HostDBException {
        AppInstance.validatePort(this.getPort(), this.getConnectionType());
        AppInstance.validateIPAddress(this.getIPAddressString());
        AppInstance.validateParentID(this.getParentID(), this.getType());
        AppInstance.validateConnectionType(this.getConnectionType(), this.getType());
    }

    AppInstance getCompleteView() {
        return new AppInstance(this);
    }

    protected void saveMS(HostID hostID) throws PersistenceManagerException {
        this.validateIPAddressMS(hostID, this.getIPAddressString());
        this.validateParentMS();
        this.setHostID(hostID);
        super.saveMS(null);
    }

    protected SaveResult createSaveResult() throws PersistenceManagerException {
        return new AppSaveResult(this);
    }

    protected void setSaveResult(SaveResult saveResult) throws PersistenceManagerException {
        super.setSaveResult(saveResult);
        this.setHostID(((AppSaveResult)saveResult).getHostID());
    }

    private void validateIPAddressMS(HostID hostID, String ip) throws PersistenceManagerException {
        if (HostDBSubsystem.getInstance().getEnableDuplicateIPs()) {
            return;
        }
        try {
            MultiAppInstanceQuery otherAppsWithIP = MultiAppInstanceQuery.byIPNotHost(hostID, ip);
            if (otherAppsWithIP.selectExists()) {
                throw HostDBException.duplicateAppIP(ip);
            }
        }
        catch (RPCException e) {
            throw HostDBException.unexpectedRPCException(e);
        }
    }

    private void validateParentMS() throws PersistenceManagerException {
        AppInstanceID parentID = this.getParentID();
        if (parentID == null) {
            return;
        }
        try {
            AppInstance parent = parentID.getByIDQuery().select();
            if (AppType.RA.equals(parent.getType())) {
                throw HostDBException.invalidAppParentType();
            }
        }
        catch (RPCException e) {
            throw HostDBException.unexpectedRPCException(e);
        }
        catch (NoResultsFoundException e) {
            throw HostDBException.noAppParent();
        }
    }

    private static class AppSaveResult
    extends SaveResult {
        private HostID mHostID;

        AppSaveResult(AppInstanceImpl app) {
            super(app);
            this.setHostID(app.getHostID());
        }

        private AppSaveResult() {
        }

        private HostID getHostID() {
            return this.mHostID;
        }

        private void setHostID(HostID hostID) {
            this.mHostID = hostID;
        }
    }
}

