/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.SaveResult;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceImpl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDHaver;
import com.raplix.util.Validate;

public class AppInstance
implements HostIDHaver,
RPCSerializable {
    private boolean mAppInstanceIsCopy;
    private AppInstanceImpl mAppInstance;
    public static final AppInstanceID MASTER_SERVER_ID = new AppInstanceID("010010001024-0000000000000-00001-0000000006");

    private AppInstance() {
    }

    public AppInstance(AppType appType) {
        this.setAppInstance(new AppInstanceImpl(appType));
        this.mAppInstanceIsCopy = true;
    }

    AppInstance(AppInstanceImpl appInstance) {
        this.setAppInstance(appInstance);
        this.mAppInstanceIsCopy = false;
    }

    private AppInstanceImpl getAppInstance() {
        return this.mAppInstance;
    }

    private void setAppInstance(AppInstanceImpl appInstance) {
        this.mAppInstance = appInstance;
    }

    private AppInstanceImpl getMutableAppInstance() {
        if (!this.mAppInstanceIsCopy) {
            this.setAppInstance((AppInstanceImpl)this.getAppInstance().clone());
            this.mAppInstanceIsCopy = true;
        }
        return this.getAppInstance();
    }

    public ObjectID getObjectID() {
        return this.getID();
    }

    public AppInstanceID getID() {
        return this.getAppInstance().getID();
    }

    public AppType getType() {
        return this.getAppInstance().getType();
    }

    public ConnectionType getConnectionType() {
        return this.getAppInstance().getConnectionType();
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.getMutableAppInstance().setConnectionType(connectionType);
    }

    public HostID getHostID() {
        return this.getAppInstance().getHostID();
    }

    public RoxAddress getRoxAddress() {
        return this.getAppInstance().getRoxAddress();
    }

    public void setRoxAddress(RoxAddress roxAddress) {
        this.getMutableAppInstance().setRoxAddress(roxAddress);
    }

    public String getIPAddress() {
        return this.getAppInstance().getIPAddressString();
    }

    public int getPort() {
        return this.getAppInstance().getPort();
    }

    public String getParameters() {
        return this.getAppInstance().getParameters();
    }

    public void setParameters(String parameters) {
        this.getMutableAppInstance().setParameters(parameters);
    }

    public AppInstanceID getParentID() {
        return this.getAppInstance().getParentID();
    }

    public void setParentID(AppInstanceID parentID) {
        this.getMutableAppInstance().setParentID(parentID);
    }

    public int getUpdateCount() {
        return this.getAppInstance().getUpdateCount();
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableAppInstance().setUpdateCount(updateCount);
    }

    public AppInstance getDataClone() {
        return new AppInstance((AppInstanceImpl)this.getAppInstance().getObjectDataClone());
    }

    public Object clone() {
        if (this.mAppInstanceIsCopy) {
            return new AppInstance((AppInstanceImpl)this.getAppInstance().clone());
        }
        return new AppInstance(this.getAppInstance());
    }

    public void validate() throws HostDBException {
        this.getAppInstance().validate();
    }

    public static void validatePort(int port, ConnectionType connectionType) throws HostDBException {
        if (connectionType.equals(ConnectionType.SSH)) {
            if (!Validate.isValidSSHPort(port)) {
                throw HostDBException.invalidAppSSHPort(port);
            }
        } else if (!Validate.isValidPort(port)) {
            throw HostDBException.invalidAppRawPort(port);
        }
    }

    public static void validateConnectionType(ConnectionType connectionType, AppType appType) throws HostDBException {
        if (AppType.MS.equals(appType) && !ConnectionType.RAW.equals(connectionType) && !ConnectionType.SSL.equals(connectionType)) {
            throw HostDBException.invalidMSConnectionType(connectionType);
        }
    }

    public static void validateIPAddress(String addr) throws HostDBException {
        if (!Validate.isValidIPAddress(addr)) {
            throw HostDBException.invalidAppIPAddress(addr);
        }
    }

    public static void validateParentID(AppInstanceID parentID, AppType appType) throws HostDBException {
        if (appType.equals(AppType.MS)) {
            if (parentID != null) {
                throw HostDBException.invalidMSAppParentID(parentID);
            }
        } else if (parentID == null) {
            throw HostDBException.emptyAppParentID();
        }
    }

    void saveMS(HostID hostID) throws PersistenceManagerException {
        this.getMutableAppInstance().saveMS(hostID);
    }

    SaveResult createSaveResult() throws PersistenceManagerException {
        return this.getAppInstance().createSaveResult();
    }

    void setSaveResult(SaveResult result) throws PersistenceManagerException {
        this.getMutableAppInstance().setSaveResult(result);
    }
}

