/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.folderdb;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderDBException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.string.StringEscapedTokenizer;
import java.util.ArrayList;

public class SummaryFolder
implements RPCSerializable,
PluginMember,
StandardObject,
HasObjectID,
UsingObject {
    private FolderImpl mFolderImpl;

    private SummaryFolder() {
    }

    protected FolderImpl getFolderImpl() {
        return this.mFolderImpl;
    }

    protected void setFolderImpl(FolderImpl inImpl) {
        this.mFolderImpl = inImpl;
    }

    SummaryFolder(FolderImpl inImpl) {
        this.mFolderImpl = inImpl;
    }

    public ObjectID getObjectID() {
        return this.getFolderImpl().getObjectID();
    }

    public GroupID getGroupID() {
        return this.getFolderImpl().getGroupID();
    }

    public PluginID getPluginID() {
        return this.getFolderImpl().getPluginID();
    }

    public String getName() {
        return this.getFolderImpl().getName();
    }

    public String getDescription() {
        return this.getFolderImpl().getDescription();
    }

    public Visibility getVisibility() {
        return this.getFolderImpl().getVisibility();
    }

    public FolderID getID() {
        return this.getFolderImpl().getID();
    }

    public FolderID getParentFolderID() {
        return this.getFolderImpl().getParentFolderID();
    }

    public String getFullPathString() {
        return this.getFolderImpl().getFullPathString();
    }

    public String findRelativePath(String path) throws FolderDBException {
        if (path.startsWith("/")) {
            int i;
            StringBuffer result = new StringBuffer();
            String ourPath = this.getFullPathString();
            String[] ourDirs = SummaryFolder.splitDirs(ourPath);
            String[] pathDirs = SummaryFolder.splitDirs(path);
            for (int start = 0; start < pathDirs.length && start < ourDirs.length && ourDirs[start].equals(pathDirs[start]); ++start) {
            }
            for (i = start; i < ourDirs.length; ++i) {
                result.append("..");
                result.append("/");
            }
            for (i = start; i < pathDirs.length; ++i) {
                result.append(pathDirs[i]);
                result.append("/");
            }
            if (result.length() > 0 && result.lastIndexOf("/") == result.length() - 1) {
                return result.substring(0, result.length() - 1);
            }
            return result.toString();
        }
        throw FolderDBException.folderPathInvalid(path);
    }

    private static String[] splitDirs(String str) throws FolderDBException {
        if ((str = str.substring(1)).endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        StringEscapedTokenizer tokenizer = new StringEscapedTokenizer(str, "/", "");
        ArrayList<String> dst = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(".") || token.equals("..") || token.equals("")) {
                throw FolderDBException.folderPathInvalid(str);
            }
            dst.add(token);
        }
        return (String[])CollectionUtil.mapClass(dst, String.class);
    }

    public int getUpdateCount() {
        return this.getFolderImpl().getUpdateCount();
    }
}

