/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.folderdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireWriteLockRPCTransaction;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.MultiStandardObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.CompleteFolderProcessor;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderDBException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderOrder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderSQLOps;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderToFolderLinkTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathFilter;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathParams;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolderProcessor;
import com.raplix.rolloutexpress.systemmodel.plandb.MultiExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.util.rwlock.LockContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;

public class MultiFolderQuery
extends MultiStandardObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final FolderSQLOps TABLE = new FolderSQLOps("folderT1");
    private FullPathFilter mFullPathFilter;
    private GroupID mGroupIDFilter;

    private MultiFolderQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, FolderOrder.FACTORY);
    }

    private MultiFolderQuery(FolderID[] IDs) {
        super((Table)TABLE, IDs, FolderOrder.FACTORY);
    }

    public static MultiFolderQuery all() {
        MultiFolderQuery result = new MultiFolderQuery((ConditionalExpression)null);
        result.setObjectOrder(FolderOrder.BY_NAME_ASC);
        result.setVisibilityFilter(Visibility.VISIBLE);
        return result;
    }

    public static MultiFolderQuery byIDs(FolderID[] IDs) {
        return new MultiFolderQuery(IDs);
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((FolderOrder)order);
    }

    public FullPathFilter getPathFilter() {
        return this.mFullPathFilter;
    }

    public void setPathFilter(FullPathFilter inPathFilter) {
        this.mFullPathFilter = inPathFilter;
    }

    public GroupID getGroupIDFilter() {
        return this.mGroupIDFilter;
    }

    public void setGroupIDFilter(GroupID inGroupID) {
        this.mGroupIDFilter = inGroupID;
    }

    public Folder[] select() throws RPCException, PersistenceManagerException {
        CompleteFolderProcessor processor = new CompleteFolderProcessor(this.getTable(), false);
        return (Folder[])this.select(processor, Folder.class);
    }

    public SummaryFolder[] selectSummaryView() throws RPCException, PersistenceManagerException {
        SummaryFolderProcessor processor = new SummaryFolderProcessor(this.getTable(), false);
        return (SummaryFolder[])this.select(processor, SummaryFolder.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        super.addFilterCondition(ctx);
        FolderSQLOps t = (FolderSQLOps)this.getTable();
        if (this.getGroupIDFilter() != null) {
            ctx.addAndWhereCondition(t.isGroupID(this.getGroupIDFilter()));
        }
        if (this.getPathFilter() != null) {
            FullPathParams theFolderConditionalParams = FullPathParams.forFolderConditional(t.cParentFolderID(), t.ID);
            this.getPathFilter().gatherClauseData(theFolderConditionalParams);
            ConditionalExpression theWhereCondition = theFolderConditionalParams.getWhereCondition();
            if (theWhereCondition != null) {
                ctx.addAndWhereCondition(theWhereCondition);
            }
        }
    }

    protected TableList getTableList() {
        TableList theResult = super.getTableList();
        if (this.getPathFilter() != null) {
            theResult = this.getPathFilter().getTableList(theResult);
        }
        return theResult;
    }

    public void move(final FolderID inNewParentID, final String inNewName) throws PersistenceManagerException, RPCException, AccessControlException {
        MultiFolderQuery.transactRPC(new AcquireWriteLockRPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                try {
                    MultiFolderQuery.this.trMove(inNewParentID, inNewName);
                }
                catch (RPCException e) {
                    throw new PersistenceManagerException(e);
                }
                return null;
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("folderdb.MOVING_FOLDERS");
            }
        });
    }

    static void move(final FolderID inFolderToMove, final FolderID inNewParentID, final String inNewName) throws RPCException, PersistenceManagerException {
        MultiFolderQuery.transactRPC(new AcquireWriteLockRPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                try {
                    PersistenceManager.getInstance().getSystemLockObject().writeLock(new ROXMessage("folderdb.MOVING_FOLDERS"), new LockContext(this){
                        private final /* synthetic */ 2 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public Object execute() throws Exception {
                            Folder theFolder = 2.access$000(this.this$0).getByIDQuery().select();
                            Folder theNewParentFolder = null;
                            if (2.access$100(this.this$0) != null) {
                                theNewParentFolder = 2.access$100(this.this$0).getByIDQuery().select();
                            }
                            MultiFolderQuery.trMoveFolderAndContents(theFolder, theNewParentFolder, 2.access$200(this.this$0), MultiFolderQuery.getAllParentIDs(2.access$100(this.this$0)));
                            return null;
                        }
                    });
                }
                catch (PersistenceManagerException e) {
                    throw e;
                }
                catch (AccessControlException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PersistenceManagerException(e);
                }
                return null;
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("folderdb.MOVING_FOLDERS");
            }

            static /* synthetic */ FolderID access$000(2 x0) {
                return x0.inFolderToMove;
            }

            static /* synthetic */ FolderID access$100(2 x0) {
                return x0.inNewParentID;
            }

            static /* synthetic */ String access$200(2 x0) {
                return x0.inNewName;
            }
        });
    }

    void trMove(final FolderID inNewParentID, final String inNewName) throws PersistenceManagerException, RPCException, AccessControlException {
        if (inNewParentID == null && inNewName == null) {
            return;
        }
        try {
            PersistenceManager.getInstance().getSystemLockObject().writeLock(new ROXMessage("folderdb.MOVING_FOLDERS"), new LockContext(){

                public Object execute() throws Exception {
                    Folder[] theFoldersToMove = MultiFolderQuery.this.select();
                    if (theFoldersToMove != null) {
                        if (inNewName != null && inNewParentID != null && theFoldersToMove.length > 1) {
                            String theTarget = inNewParentID.getByIDQuery().selectSummaryView().getFullPathString() + "/" + inNewName;
                            throw new FolderDBException(new ROXMessage("folderdb.LOGICAL_NAME_COLLISION", new String[]{theTarget}));
                        }
                        ObjectID[] theNewParentIDsToAdd = MultiFolderQuery.getAllParentIDs(inNewParentID);
                        Folder theNewParentFolder = null;
                        if (inNewParentID != null) {
                            theNewParentFolder = inNewParentID.getByIDQuery().select();
                        }
                        for (int i = 0; i < theFoldersToMove.length; ++i) {
                            MultiFolderQuery.trMoveFolderAndContents(theFoldersToMove[i], theNewParentFolder, inNewName, theNewParentIDsToAdd);
                        }
                    }
                    return null;
                }
            });
        }
        catch (PersistenceManagerException e) {
            throw e;
        }
        catch (RPCException e) {
            throw e;
        }
        catch (AccessControlException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FolderDBException(e);
        }
    }

    static ObjectID[] getAllParentIDs(FolderID inNewParentID) throws PersistenceManagerException {
        if (inNewParentID == null) {
            return null;
        }
        Link[] theNewParentLinks = FolderToFolderLinkTable.DEFAULT.getByChildIDs(new ObjectID[]{inNewParentID});
        int theNumNewParents = theNewParentLinks == null ? 0 : theNewParentLinks.length;
        ObjectID[] theParentIDs = new FolderID[theNumNewParents + 1];
        for (int theLinkIdx = 0; theLinkIdx < theNumNewParents; ++theLinkIdx) {
            theParentIDs[theLinkIdx] = theNewParentLinks[theLinkIdx].getParentObjectID();
        }
        theParentIDs[theNumNewParents] = inNewParentID;
        return theParentIDs;
    }

    static void trMoveFolderAndContents(Folder inFolderToMove, Folder inNewParentFolder, String inNewName, ObjectID[] inNewParentIDsToAdd) throws PersistenceManagerException, RPCException {
        FolderID theFolderToMoveID = inFolderToMove.getID();
        if (theFolderToMoveID.equals(FolderID.ROOT_FOLDER_ID)) {
            throw new FolderDBException(new ROXMessage("folderdb.ROOT_IMMUTABLE"));
        }
        MultiFolderQuery.verifyPluginWritable(inFolderToMove);
        boolean isDirChange = inNewParentFolder != null;
        boolean isPathChange = isDirChange || inNewName != null && !inNewName.equals(inFolderToMove.getName());
        HashSet theWritables = new HashSet();
        ObjectID[] theOldParentIDsToRmv = null;
        if (isDirChange) {
            for (int i = 0; i < inNewParentIDsToAdd.length; ++i) {
                if (!inNewParentIDsToAdd[i].equals(theFolderToMoveID)) continue;
                throw new FolderDBException(new ROXMessage("folderdb.BAD_MOVE_INTO_SELF"));
            }
            MultiFolderQuery.verifyFolderAndPluginWritable(inNewParentFolder, theWritables);
            Link[] theOldParentLinks = FolderToFolderLinkTable.DEFAULT.getByChildIDs(new ObjectID[]{theFolderToMoveID});
            int theNumOldParents = theOldParentLinks == null ? 0 : theOldParentLinks.length;
            theOldParentIDsToRmv = new FolderID[theNumOldParents];
            for (int theLinkIdx = 0; theLinkIdx < theNumOldParents; ++theLinkIdx) {
                theOldParentIDsToRmv[theLinkIdx] = theOldParentLinks[theLinkIdx].getParentObjectID();
            }
        }
        Folder theCurParentFolder = inFolderToMove.getParentFolderID().getByIDQuery().select();
        MultiFolderQuery.verifyFolderAndPluginWritable(theCurParentFolder, theWritables);
        String theOldPartialPath = null;
        String theNewPartialPath = null;
        if (isPathChange) {
            theOldPartialPath = inFolderToMove.getFullPathString();
            if (inNewParentFolder != null) {
                theNewPartialPath = inNewParentFolder.getFullPathString();
            } else {
                theNewPartialPath = theOldPartialPath.substring(0, theOldPartialPath.length() - 1);
                int thePreNameSepIdx = theNewPartialPath.lastIndexOf("/");
                theNewPartialPath = theNewPartialPath.substring(0, thePreNameSepIdx + 1);
            }
            theNewPartialPath = theNewPartialPath + (inNewName != null ? inNewName : inFolderToMove.getName());
            theNewPartialPath = theNewPartialPath + "/";
        }
        SubFolderWParentIter theSubFolderWParentIter = new SubFolderWParentIter(inFolderToMove);
        Folder[] theTargetAndParent = new Folder[2];
        if (isPathChange) {
            MultiFolderQuery.changeFolderPath(inFolderToMove, theOldPartialPath, theNewPartialPath);
            MultiFolderQuery.moveContainedObjs(inFolderToMove);
            while (theSubFolderWParentIter.getNextTargetAndParent(theTargetAndParent)) {
                MultiFolderQuery.changeFolderPath(theTargetAndParent[0], theOldPartialPath, theNewPartialPath);
                MultiFolderQuery.moveContainedObjs(theTargetAndParent[0]);
            }
        }
        if (isDirChange) {
            MultiFolderQuery.changeFolderParentLinks(inFolderToMove, theOldParentIDsToRmv, inNewParentIDsToAdd);
        }
        if (inNewParentFolder != null) {
            inFolderToMove.setParentFolderID(inNewParentFolder.getID());
        }
        inFolderToMove.save();
        theSubFolderWParentIter.reset();
        while (theSubFolderWParentIter.getNextTargetAndParent(theTargetAndParent)) {
            Folder theSubFolder = theTargetAndParent[0];
            MultiFolderQuery.verifyPluginWritable(theTargetAndParent[1]);
            if (isDirChange) {
                MultiFolderQuery.changeFolderParentLinks(theSubFolder, theOldParentIDsToRmv, inNewParentIDsToAdd);
            }
            theSubFolder.save();
        }
    }

    private static void moveContainedObjs(SummaryFolder inRetargetingSummaryFolder) throws RPCException, PersistenceManagerException {
        MultiComponentQuery.trMoveMS(inRetargetingSummaryFolder);
        MultiExecutionPlanQuery.trMoveMS(inRetargetingSummaryFolder);
    }

    static void verifyPluginWritable(SummaryFolder inFolder) throws FolderDBException, AccessControlException {
        Plugin.checkWritePermissions(inFolder);
    }

    private static void verifyFolderAndPluginWritable(SummaryFolder inFolder, HashSet ioWritables) throws FolderDBException, AccessControlException {
        FolderID theFolderID = inFolder.getID();
        if (!ioWritables.contains(theFolderID)) {
            MultiFolderQuery.verifyPluginWritable(inFolder);
            AccessController.checkPermission(new FolderPermission(theFolderID, "write"));
            ioWritables.add(theFolderID);
        }
    }

    private static void changeFolderPath(Folder ioFolderToMove, String inOldPartialPath, String inNewPartialPath) {
        String theFullPath = ioFolderToMove.getFullPathString();
        if (!theFullPath.startsWith(inOldPartialPath) || !inNewPartialPath.startsWith("/")) {
            throw new IllegalStateException("sanity check failure: fullpath " + theFullPath + "must begin with " + inOldPartialPath + " and new partial path " + inNewPartialPath + " must begin with separator");
        }
        theFullPath = inNewPartialPath + theFullPath.substring(inOldPartialPath.length(), theFullPath.length());
        ioFolderToMove.setFullPathString(theFullPath);
    }

    private static void changeFolderParentLinks(Folder ioFolderToMove, ObjectID[] inOldParentIDsToRmv, ObjectID[] inNewParentIDsToAdd) throws PersistenceManagerException {
        int i;
        FolderID theFolderToMoveID = ioFolderToMove.getID();
        Link[] theExistingParentLinks = FolderToFolderLinkTable.DEFAULT.getByChildIDs(new ObjectID[]{theFolderToMoveID});
        int theNumExistingParents = theExistingParentLinks == null ? 0 : theExistingParentLinks.length;
        HashSet<ObjectID> theParentIDHash = new HashSet<ObjectID>();
        for (int theLinkIdx = 0; theLinkIdx < theNumExistingParents; ++theLinkIdx) {
            theParentIDHash.add(theExistingParentLinks[theLinkIdx].getParentObjectID());
        }
        for (i = 0; i < inOldParentIDsToRmv.length; ++i) {
            theParentIDHash.remove(inOldParentIDsToRmv[i]);
        }
        for (i = 0; i < inNewParentIDsToAdd.length; ++i) {
            theParentIDHash.add(inNewParentIDsToAdd[i]);
        }
        ObjectID[] theParentIDArray = theParentIDHash.toArray(new ObjectID[0]);
        FolderToFolderLinkTable.DEFAULT.removeByChildID(theFolderToMoveID);
        FolderToFolderLinkTable.DEFAULT.addLinks(theParentIDArray, theFolderToMoveID);
    }

    static class SubFolderWParentIter {
        private Folder[] mFolders;
        private HashMap mFolderID2FolderMap;
        private int mIdx;

        SubFolderWParentIter(Folder inRoot) throws RPCException, PersistenceManagerException {
            if (inRoot == null) {
                throw new NullPointerException();
            }
            MultiFolderQuery theMFQ = MultiFolderQuery.all();
            FullPathFilter theFPF = new FullPathFilter(inRoot.getID(), null, true);
            theMFQ.setPathFilter(theFPF);
            theMFQ.setObjectOrder(FolderOrder.BY_NAME_ASC);
            this.mFolders = theMFQ.select();
            this.mFolderID2FolderMap = new HashMap();
            this.mFolderID2FolderMap.put(inRoot.getID(), inRoot);
            for (int i = 0; i < this.mFolders.length; ++i) {
                Folder theFolder = this.mFolders[i];
                this.mFolderID2FolderMap.put(theFolder.getID(), theFolder);
            }
            this.mIdx = 0;
        }

        boolean getNextTargetAndParent(Folder[] outNextTargetAndParent) {
            Folder theNextTarget;
            if (this.mIdx >= this.mFolders.length) {
                return false;
            }
            outNextTargetAndParent[0] = theNextTarget = this.mFolders[this.mIdx++];
            Folder theNextParent = (Folder)this.mFolderID2FolderMap.get(theNextTarget.getParentFolderID());
            if (theNextParent == null) {
                throw new IllegalStateException();
            }
            outNextTargetAndParent[1] = theNextParent;
            return true;
        }

        public void reset() {
            this.mIdx = 0;
        }
    }
}

