/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.folderdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.CachedFolderTreeNode;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderOrder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathFilter;
import com.raplix.rolloutexpress.systemmodel.folderdb.MultiFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import java.util.HashMap;
import java.util.Vector;

class MultiCachedFolderTreeNodeQuery {
    private CachedFolderTreeNode mParentFolderTreeNode = null;

    public static MultiCachedFolderTreeNodeQuery allChildrenOf(CachedFolderTreeNode inParentTreeNode) throws PersistenceManagerException {
        MultiCachedFolderTreeNodeQuery result = new MultiCachedFolderTreeNodeQuery(inParentTreeNode);
        return result;
    }

    private MultiCachedFolderTreeNodeQuery(CachedFolderTreeNode inParentFolder) throws PersistenceManagerException {
        this.setParentFolderTreeFilter(inParentFolder);
    }

    public void setParentFolderTreeFilter(CachedFolderTreeNode inParent) {
        this.mParentFolderTreeNode = inParent;
    }

    public CachedFolderTreeNode getParentFolderTreeFilter() {
        return this.mParentFolderTreeNode;
    }

    public CachedFolderTreeNode[] select() throws RPCException, PersistenceManagerException {
        int i;
        MultiFolderQuery theMFQ = MultiFolderQuery.all();
        FolderID theSearchRoot = this.mParentFolderTreeNode == null ? FolderID.ROOT_FOLDER_ID : this.mParentFolderTreeNode.getFolder().getID();
        FullPathFilter theFPF = new FullPathFilter(theSearchRoot, null, true);
        theMFQ.setPathFilter(theFPF);
        theMFQ.setObjectOrder(FolderOrder.BY_NAME_ASC);
        SummaryFolder[] theChildSummaries = theMFQ.selectSummaryView();
        HashMap theParIDToContainedNodesVecMap = new HashMap();
        Vector<CachedFolderTreeNode> theNodesVec = new Vector<CachedFolderTreeNode>();
        for (i = 0; i < theChildSummaries.length; ++i) {
            SummaryFolder theChild = theChildSummaries[i];
            Vector<CachedFolderTreeNode> theByParentIDVec = (Vector<CachedFolderTreeNode>)theParIDToContainedNodesVecMap.get(theChild.getParentFolderID());
            if (theByParentIDVec == null) {
                theByParentIDVec = new Vector<CachedFolderTreeNode>();
                theParIDToContainedNodesVecMap.put(theChild.getParentFolderID(), theByParentIDVec);
            }
            CachedFolderTreeNode theNode = new CachedFolderTreeNode(theChild);
            theByParentIDVec.add(theNode);
            theNodesVec.add(theNode);
        }
        if (this.mParentFolderTreeNode != null) {
            theNodesVec.add(this.mParentFolderTreeNode);
        }
        for (i = 0; i < theNodesVec.size(); ++i) {
            CachedFolderTreeNode theNode = (CachedFolderTreeNode)theNodesVec.get(i);
            FolderID theNodeFolderID = theNode.getFolder().getID();
            Vector theChildren = (Vector)theParIDToContainedNodesVecMap.get(theNodeFolderID);
            if (theChildren == null) continue;
            theNode.setChildren(theChildren.toArray(new CachedFolderTreeNode[0]));
        }
        Vector theSearchRootChildNodes = (Vector)theParIDToContainedNodesVecMap.get(theSearchRoot);
        CachedFolderTreeNode[] results = theSearchRootChildNodes == null ? new CachedFolderTreeNode[]{} : theSearchRootChildNodes.toArray(new CachedFolderTreeNode[0]);
        return results;
    }
}

