/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.folderdb;

import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import java.util.Vector;

class FullPathParams {
    private int mType;
    private IDColumn mParentFolderIDColumn;
    private IDColumn mFolderObjIDColumn;
    private AndExp mAndExpr;
    private TableList mTableList;
    private Vector mAddedTables = new Vector();

    public static FullPathParams forFolderConditional(IDColumn inParentFolderIDColumn, IDColumn inFolderObjIDColumn) {
        return new FullPathParams(inParentFolderIDColumn, inFolderObjIDColumn);
    }

    public static FullPathParams forTableList(TableList inTableList) {
        return new FullPathParams(inTableList);
    }

    public static FullPathParams forNonFolderConditional(IDColumn inCPathIDColumn) {
        return new FullPathParams(inCPathIDColumn);
    }

    private FullPathParams(IDColumn inCPathIDColumn) {
        this.mParentFolderIDColumn = inCPathIDColumn;
        this.mType = 1;
    }

    private FullPathParams(TableList inTableList) {
        this.mTableList = inTableList;
        this.mType = 2;
    }

    private FullPathParams(IDColumn inParentFolderIDColumn, IDColumn inFolderObjIDColumn) {
        if (inFolderObjIDColumn == null) {
            throw new NullPointerException();
        }
        this.mParentFolderIDColumn = inParentFolderIDColumn;
        this.mFolderObjIDColumn = inFolderObjIDColumn;
        this.mType = 0;
    }

    public boolean getIsFolderSearch() {
        return this.mType == 0 || this.mType == 2;
    }

    public TableList getTableList() {
        if (this.mTableList == null) {
            throw new NullPointerException();
        }
        return this.mTableList;
    }

    public ConditionalExpression getWhereCondition() {
        if (!this.gathersConditions()) {
            throw new IllegalStateException();
        }
        return this.mAndExpr;
    }

    public void addTable(Table inTable) {
        if (this.mTableList != null) {
            for (int i = 0; i < this.mAddedTables.size(); ++i) {
                if (inTable != this.mAddedTables.get(i)) continue;
                return;
            }
            this.mAddedTables.add(inTable);
            this.mTableList = QueryBuilder.tList(this.mTableList, (TableClause)inTable);
        }
    }

    public void addAndExpr(ConditionalExpression inCondExpr) {
        if (this.mAndExpr == null) {
            this.mAndExpr = QueryBuilder.and();
        }
        this.mAndExpr.add(inCondExpr);
    }

    public boolean gathersConditions() {
        return this.mType != 2;
    }

    public IDColumn getParentFolderIDCol() {
        return this.mParentFolderIDColumn;
    }

    public IDColumn getFolderObjIDColumn() {
        return this.mFolderObjIDColumn;
    }

    static interface Type {
        public static final int FOR_FOLDER_CONDITIONAL = 0;
        public static final int FOR_NON_FOLDER_CONDITIONAL = 1;
        public static final int FOR_TABLES = 2;
    }
}

