/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.folderdb;

import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderLinkSQLOps;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderObjectTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderSQLOps;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathParams;
import com.raplix.util.regex.GlobPattern;

public class FullPathFilter
extends QueryBuilder
implements Cloneable {
    private static final FolderSQLOps FOLDER_TABLE = new FolderSQLOps("folderT2");
    private static final FolderLinkSQLOps FOLDER_LINK_TABLE = new FolderLinkSQLOps("folderLinkT");
    private GlobPattern mPathFilter;
    private FolderID mSearchRoot;
    private boolean mRecursiveMode;

    public FullPathFilter() {
        this(null, null, true);
    }

    public FullPathFilter(FolderID inSearchRoot, GlobPattern inPathFilter, boolean inRecursive) {
        this.setSearchRoot(inSearchRoot);
        this.setPathFilter(inPathFilter);
        this.setRecursiveMode(inRecursive);
    }

    public GlobPattern getPathFilter() {
        return this.mPathFilter;
    }

    public void setPathFilter(GlobPattern inPathFilter) {
        this.mPathFilter = inPathFilter;
    }

    public void setSearchRoot(FolderID inFolderID) {
        this.mSearchRoot = inFolderID;
    }

    public FolderID getSearchRoot() {
        return this.mSearchRoot;
    }

    public void setRecursiveMode(boolean inRecursive) {
        this.mRecursiveMode = inRecursive;
    }

    public boolean getRecursiveMode() {
        return this.mRecursiveMode;
    }

    void gatherClauseData(FullPathParams inParams) {
        FolderID theSearchRoot = this.getSearchRoot();
        if (this.getPathFilter() == null && this.getRecursiveMode() && theSearchRoot == null) {
            return;
        }
        boolean isFolderSearch = inParams.getIsFolderSearch();
        if (!this.getRecursiveMode()) {
            if (theSearchRoot == null) {
                if (isFolderSearch) {
                    inParams.addTable(FOLDER_TABLE);
                    inParams.addAndExpr(FOLDER_TABLE.isFolderID(FolderID.ROOT_FOLDER_ID));
                } else {
                    inParams.addAndExpr(QueryBuilder.equals(inParams.getParentFolderIDCol(), FolderID.ROOT_FOLDER_ID));
                }
            } else {
                inParams.addAndExpr(QueryBuilder.equals(inParams.getParentFolderIDCol(), theSearchRoot));
            }
        } else {
            if (theSearchRoot != null) {
                inParams.addAndExpr(FolderLinkSQLOps.or(FolderLinkSQLOps.equals(inParams.getParentFolderIDCol(), theSearchRoot), FOLDER_LINK_TABLE.linkExists(theSearchRoot, inParams.getParentFolderIDCol())));
            }
            if (this.getPathFilter() != null) {
                inParams.addTable(FOLDER_TABLE);
                inParams.addAndExpr(FOLDER_TABLE.isFolderID(isFolderSearch ? inParams.getFolderObjIDColumn() : inParams.getParentFolderIDCol()));
                GlobPattern thePattern = GlobPattern.create(this.getPathFilter().getPattern());
                inParams.addAndExpr(FOLDER_TABLE.isFullPath(thePattern));
            }
        }
    }

    public void addFilterCondition(QueryContext ctx, FolderObjectTable inTable) {
        FullPathParams theFolderConditionalParams = FullPathParams.forNonFolderConditional(inTable.cPathID());
        this.gatherClauseData(theFolderConditionalParams);
        ConditionalExpression theWhereCondition = theFolderConditionalParams.getWhereCondition();
        if (theWhereCondition != null) {
            ctx.addAndWhereCondition(theWhereCondition);
        }
    }

    public TableList getTableList(TableList theResult) {
        FullPathParams theTableListParam = FullPathParams.forTableList(theResult);
        this.gatherClauseData(theTableListParam);
        return theTableListParam.getTableList();
    }
}

