/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.folderdb;

import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImplTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentGroupDataTable;
import com.raplix.util.regex.GlobPattern;

class FolderSQLOps
extends FolderImplTable {
    public static final FolderSQLOps DEFAULT = new FolderSQLOps();

    public FolderSQLOps(String alias) {
        super(alias);
    }

    private FolderSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new FolderSQLOps(alias);
    }

    public ConditionalExpression isName(String name) {
        return FolderSQLOps.equals(this.Name, name);
    }

    public ConditionalExpression isFullPath(String inFullPath) {
        return FolderSQLOps.equals(this.FullPathString, inFullPath);
    }

    public ConditionalExpression isFullPath(GlobPattern inFullPath) {
        return FolderSQLOps.likeLower(this.FullPathString, inFullPath);
    }

    public ConditionalExpression isFolderID(FolderID inFolderID) {
        return FolderSQLOps.equals(this.ID, inFolderID);
    }

    public ConditionalExpression isFolderID(IDColumn inFolderID) {
        return FolderSQLOps.equals((ColumnNode)this.ID, inFolderID);
    }

    public ConditionalExpression isParent(FolderID inParentID) {
        return FolderSQLOps.equals(this.ParentFolderID, inParentID);
    }

    public ConditionalExpression isParent(IDColumn inParentID) {
        return FolderSQLOps.equals((ColumnNode)this.ParentFolderID, inParentID);
    }

    public ConditionalExpression isGroupID(GroupID inGroupID) {
        return FolderSQLOps.equals(this.GroupID, inGroupID);
    }

    public OrderByList orderByNameAsc(QueryContext ctx) {
        return FolderSQLOps.dictOrderAsc(this.Name);
    }

    public OrderByList orderByNameDesc(QueryContext ctx) {
        return FolderSQLOps.dictOrderDesc(this.Name);
    }

    public OrderByList orderByPathAndNameAsc(QueryContext ctx) {
        return FolderSQLOps.dictOrderAsc(this.FullPathString);
    }

    public OrderByList orderByPathAndNameDesc(QueryContext ctx) {
        return FolderSQLOps.dictOrderDesc(this.FullPathString);
    }

    public OrderByList orderByOwnerAsc(QueryContext ctx) {
        PersistentGroupDataTable pgT = new PersistentGroupDataTable("pgT");
        ctx.addTable(pgT);
        ctx.addAndWhereCondition(FolderSQLOps.equals((ColumnNode)pgT.ID, this.GroupID));
        return FolderSQLOps.dictOrderAsc(pgT.Name).add(this.orderByNameAsc(ctx));
    }

    public OrderByList orderByOwnerDesc(QueryContext ctx) {
        PersistentGroupDataTable pgT = new PersistentGroupDataTable("pgT");
        ctx.addTable(pgT);
        ctx.addAndWhereCondition(FolderSQLOps.equals((ColumnNode)pgT.ID, this.GroupID));
        return FolderSQLOps.dictOrderDesc(pgT.Name).add(this.orderByNameAsc(ctx));
    }

    public ConditionalExpression getByName(GlobPattern namePattern) {
        return FolderSQLOps.likeLower(this.Name, namePattern);
    }

    public ConditionalExpression getByDescription(GlobPattern descPattern) {
        return FolderSQLOps.likeLower(this.Description, descPattern);
    }
}

