/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.folderdb;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ConstraintViolationException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderDBException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderToFolderLinkTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessControlManager;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessData;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class FolderImpl
extends PersistentBean
implements Cloneable {
    private String mFullPath;
    private String mDescription = "";
    private FolderID mParentFolderID;
    private String mCachedName;
    private GroupID mGroupID;
    private PluginID mPluginID;
    private FolderAccessData mFolderAccessData;
    private transient SummaryFolder mSummaryView;
    private boolean mExternalDataLoaded = false;
    private static FolderAccessControlManager sFolderAccessMgr = null;

    private FolderImpl() {
    }

    static FolderImpl create() {
        FolderImpl result = new FolderImpl();
        result.resetExternalData(true);
        return result;
    }

    FolderID getID() {
        return (FolderID)super.getObjectID();
    }

    public String getName() {
        return this.mCachedName;
    }

    void setName(String inName) {
        if (inName == null) {
            throw new NullPointerException();
        }
    }

    String getDescription() {
        return this.mDescription;
    }

    void setDescription(String inDesc) {
        if (inDesc == null) {
            throw new NullPointerException();
        }
        this.mDescription = inDesc;
    }

    protected Visibility getVisibility() {
        return Visibility.VISIBLE;
    }

    protected void setVisibility(Visibility visibility) {
    }

    public FolderAccessData getFolderAccessData() {
        if (this.mFolderAccessData == null) {
            return null;
        }
        return (FolderAccessData)this.mFolderAccessData.clone();
    }

    public void setFolderAccessData(FolderAccessData inFolderAccessData) {
        this.mFolderAccessData = (FolderAccessData)inFolderAccessData.clone();
        this.mGroupID = this.mFolderAccessData.getOwnerID();
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int updateCount) {
        super.setUpdateCount(updateCount);
    }

    public String getFullPathString() {
        return this.mFullPath;
    }

    void setFullPathString(String inFullPath) {
        if (inFullPath == null) {
            throw new NullPointerException();
        }
        this.mFullPath = inFullPath;
        String thePathSansTrailingSeparator = this.mFullPath.substring(0, this.mFullPath.length() - 1);
        this.mCachedName = ResourceStringUtils.getURLFileName(thePathSansTrailingSeparator);
    }

    FolderID getParentFolderID() {
        return this.mParentFolderID;
    }

    void setParentFolderID(FolderID parentFolderID) {
        this.mParentFolderID = parentFolderID;
    }

    public GroupID getGroupID() {
        return this.mGroupID;
    }

    void setGroupID(GroupID inGroupID) {
        this.mGroupID = inGroupID;
    }

    public PluginID getPluginID() {
        return this.mPluginID;
    }

    void setPluginID(PluginID inPluginID) {
        this.mPluginID = inPluginID;
    }

    SummaryFolder getSummaryView() {
        if (this.mSummaryView == null) {
            this.mSummaryView = new SummaryFolder(this);
        }
        return this.mSummaryView;
    }

    private boolean isExternalDataLoaded() {
        return this.mExternalDataLoaded;
    }

    private void resetExternalData(boolean isLoadComplete) {
        this.mFolderAccessData = null;
        if (isLoadComplete) {
            this.setExternalDataLoaded();
        }
    }

    private void setExternalDataLoaded() {
        this.mExternalDataLoaded = true;
    }

    private void loadExternalDataMS() throws PersistenceManagerException {
        if (this.isExternalDataLoaded()) {
            return;
        }
        if (this.getID() != null) {
            try {
                this.setExternalDataMS(FolderImpl.getFolderAccessMgr().get(this.getID()));
            }
            catch (UserDBException e) {
                throw new FolderDBException(e);
            }
        } else {
            this.resetExternalData(true);
        }
    }

    static void loadExternalDataMS(List inFolderImpls) throws PersistenceManagerException {
        int size = inFolderImpls.size();
        if (size == 0) {
            return;
        }
        FolderIDSet theUnloadedFolderIDSet = new FolderIDSet();
        ArrayList<FolderImpl> theUnloadedFolderImpls = new ArrayList<FolderImpl>();
        for (int i = 0; i < size; ++i) {
            FolderImpl theFolderImpl = (FolderImpl)inFolderImpls.get(i);
            if (theFolderImpl.isExternalDataLoaded()) continue;
            theUnloadedFolderIDSet.add(theFolderImpl.getID());
            theUnloadedFolderImpls.add(theFolderImpl);
        }
        if (theUnloadedFolderIDSet.isEmpty()) {
            return;
        }
        Map theIDToFADMap = null;
        try {
            theIDToFADMap = FolderImpl.getFolderAccessMgr().get(theUnloadedFolderIDSet);
        }
        catch (UserDBException e) {
            throw new FolderDBException(e);
        }
        for (int i = 0; i < size; ++i) {
            FolderImpl theFolderImpl = (FolderImpl)inFolderImpls.get(i);
            if (theFolderImpl.isExternalDataLoaded()) continue;
            theFolderImpl.setExternalDataMS((FolderAccessData)theIDToFADMap.get(theFolderImpl.getID()));
        }
    }

    Folder getCompleteViewMS() throws PersistenceManagerException {
        this.loadExternalDataMS();
        return new Folder(this);
    }

    private synchronized void setExternalDataMS(FolderAccessData inFAD) {
        if (this.isExternalDataLoaded()) {
            return;
        }
        this.mFolderAccessData = inFAD;
        this.setExternalDataLoaded();
    }

    protected Object clone() {
        try {
            FolderImpl result = (FolderImpl)super.clone();
            result.mSummaryView = null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void save() throws FolderDBException, PersistenceManagerException, RPCException {
        this.nonTxValidate();
        this.saveRPC(null);
    }

    void nonTxValidate() throws FolderDBException {
        if (FolderID.ROOT_FOLDER_ID.equals(this.getID())) {
            if (!"/".equals(this.mFullPath)) {
                throw FolderDBException.folderNameInvalid(this.mFullPath);
            }
        } else {
            Folder.validateName(this.getName());
        }
        Folder.validateDescription(this.getDescription());
    }

    protected void saveMS(PersistContext context) throws PersistenceManagerException {
        FolderImpl.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                FolderImpl.this.trSaveMS();
                return null;
            }
        });
    }

    private void txValidate() throws PersistenceManagerException {
        if (!FolderID.ROOT_FOLDER_ID.equals(this.getID())) {
            SummaryFolder theParentSummary = null;
            try {
                theParentSummary = new SingleFolderQuery(this.mParentFolderID).selectSummaryView();
            }
            catch (RPCException e) {
                throw new PersistenceManagerException(new ROXMessage("folderdb.PARENT_UNREADABLE", new String[]{this.mParentFolderID.toString()}), (Throwable)e);
            }
            String theCurParentPath = theParentSummary.getFullPathString();
            String theOrigFullPathSansSeparator = this.mFullPath.substring(0, this.mFullPath.length() - 1);
            int theLastSepIdx = theOrigFullPathSansSeparator.lastIndexOf("/");
            String theOrigPath = theOrigFullPathSansSeparator.substring(0, theLastSepIdx + 1);
            if (!theOrigPath.equals(theCurParentPath)) {
                throw new FolderDBException(new ROXMessage("folderdb.PARENT_CHANGED", new String[]{theOrigPath, theCurParentPath}));
            }
        }
    }

    private void trSaveMS() throws PersistenceManagerException {
        block12: {
            this.txValidate();
            try {
                FolderID theID = this.getID();
                if (theID != null) {
                    try {
                        AccessController.checkPermission(new FolderPermission(theID, "write"));
                    }
                    catch (AccessControlException e) {
                        throw new PersistenceManagerException(e);
                    }
                    theID.lockForUpdateMS();
                    super.saveMS(null);
                    try {
                        sFolderAccessMgr.save(theID, this.mFolderAccessData, false);
                        break block12;
                    }
                    catch (UserDBException e) {
                        throw new FolderDBException(e);
                    }
                }
                super.saveMS(null);
                theID = this.getID();
                try {
                    sFolderAccessMgr.save(theID, this.mFolderAccessData, true);
                }
                catch (UserDBException e) {
                    throw new FolderDBException(e);
                }
                Link[] theNewParentLinks1 = FolderToFolderLinkTable.DEFAULT.getByChildIDs(new ObjectID[]{this.mParentFolderID});
                int theNumNewParents1 = theNewParentLinks1 == null ? 0 : theNewParentLinks1.length;
                ObjectID[] theParentIDs = new FolderID[theNumNewParents1 + 1];
                for (int theLinkIdx = 0; theLinkIdx < theNumNewParents1; ++theLinkIdx) {
                    theParentIDs[theLinkIdx] = theNewParentLinks1[theLinkIdx].getParentObjectID();
                }
                theParentIDs[theNumNewParents1] = this.mParentFolderID;
                FolderToFolderLinkTable.DEFAULT.addLinks(theParentIDs, theID);
            }
            catch (AccessControlException e) {
                throw new FolderDBException(new ROXMessage("folderdb.PERMISSIONS_SAVE_ERROR", new String[]{this.getFullPathString()}), (Throwable)e);
            }
            catch (ConstraintViolationException e) {
                if ("rox_folder_c_full_path_key".equals(e.getConstraintName())) {
                    throw new FolderDBException(new ROXMessage("folderdb.NAME_COLLISION", new String[]{this.getFullPathString()}));
                }
                throw e;
            }
        }
    }

    private static FolderAccessControlManager getFolderAccessMgr() throws FolderDBException {
        if (sFolderAccessMgr == null) {
            try {
                sFolderAccessMgr = PersistenceManager.getInstance().getApplication().getUserDBSubsystem().getFolderAccessControlManager();
            }
            catch (UnsupportedSubsystemException e) {
                throw new FolderDBException(e);
            }
        }
        return sFolderAccessMgr;
    }
}

