/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.folderdb;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.cache.SingleObjectByNameCache;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderDBException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderToFolderLinkTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathFilter;
import com.raplix.rolloutexpress.systemmodel.folderdb.MultiFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plandb.MultiExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessControlManager;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessData;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserFolderPermissions;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringEscapedTokenizer;
import java.security.AccessControlException;
import java.security.AccessController;

public class FolderID
extends ObjectID {
    public static final FolderID ROOT_FOLDER_ID = new FolderID("010010001024-0000000000000-00000-0000000013");
    public static final String UNKNOWN_FOLDER = "(unknown-folder)";
    private static final IDFactory ID_FACTORY = new IDFactory();

    private FolderID() {
    }

    public FolderID(String key) {
        super(key);
    }

    public SingleFolderQuery getByIDQuery() {
        return new SingleFolderQuery(this);
    }

    public static FolderID generateID() {
        return (FolderID)ID_FACTORY.generateObjectID();
    }

    protected void deleteMS(final PersistContext inContext) throws PersistenceManagerException {
        if (this.equals(ROOT_FOLDER_ID)) {
            throw new FolderDBException(new ROXMessage("folderdb.ROOT_IMMUTABLE"));
        }
        FolderID.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                FolderAccessControlManager theFACM = null;
                try {
                    theFACM = PersistenceManager.getInstance().getApplication().getUserDBSubsystem().getFolderAccessControlManager();
                }
                catch (UnsupportedSubsystemException e) {
                    throw new PersistenceManagerException(e);
                }
                try {
                    theFACM.delete(FolderID.this);
                }
                catch (UserDBException e) {
                    throw new PersistenceManagerException(e);
                }
                FolderToFolderLinkTable.DEFAULT.removeByChildID(FolderID.this);
                FolderID.super.deleteMS(inContext);
                return null;
            }
        });
    }

    public void move(FolderID inNewParentID, String inNewName) throws FolderDBException, PersistenceManagerException, RPCException {
        if (inNewParentID == null && inNewName == null) {
            return;
        }
        MultiFolderQuery.move(this, inNewParentID, inNewName);
    }

    public UserFolderPermissions getUserPermissions(final UserID inUserID) throws FolderDBException, PersistenceManagerException, RPCException {
        UserFolderPermissionsCtx thePermsCtx = (UserFolderPermissionsCtx)FolderID.transactRPC(new RPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                try {
                    UserID theUserID = inUserID;
                    if (theUserID == null) {
                        try {
                            theUserID = PersistenceManager.getInstance().getApplication().getUserDBSubsystem().getLocalSessionManager().getCurrentUserID();
                        }
                        catch (RPCException e) {
                            throw new FolderDBException(e);
                        }
                    }
                    UserFolderPermissions thePerms = PersistenceManager.getInstance().getApplication().getUserDBSubsystem().getFolderAccessControlManager().getUserPermissions(FolderID.this, theUserID);
                    return new UserFolderPermissionsCtx(thePerms);
                }
                catch (UserDBException e) {
                    throw new FolderDBException(e);
                }
                catch (UnsupportedSubsystemException e) {
                    throw new FolderDBException(e);
                }
            }
        });
        return thePermsCtx.getPerms();
    }

    public UserFolderPermissions getUserPermissions() throws FolderDBException, PersistenceManagerException, RPCException {
        return this.getUserPermissions(null);
    }

    public String getResolvedPath(String inPath) throws FolderDBException {
        String thePath;
        if (inPath == null) {
            inPath = "";
        }
        if (!(thePath = inPath.replace('\\', '/')).startsWith("/")) {
            try {
                thePath = this.getByIDQuery().selectSummaryView().getFullPathString() + thePath;
            }
            catch (RPCException e) {
                throw new FolderDBException(e);
            }
            catch (PersistenceManagerException e) {
                throw new FolderDBException(e);
            }
        }
        if (!(thePath = FolderID.stripDotsFromPath(thePath)).endsWith("/")) {
            thePath = thePath + "/";
        }
        return thePath;
    }

    public SingleFolderQuery getByResolvedPathQuery(String inPath) throws FolderDBException {
        return SingleFolderQuery.byPath(this.getResolvedPath(inPath));
    }

    private static String stripDotsFromPath(String inPath) throws FolderDBException {
        if (inPath == null || inPath.length() == 0) {
            throw FolderDBException.folderPathInvalid(inPath);
        }
        String thePath = inPath.replace('\\', '/');
        if (thePath.equals("/")) {
            return "/";
        }
        if (thePath.indexOf("//") != -1) {
            throw FolderDBException.folderPathInvalid(inPath);
        }
        if (thePath.indexOf("/") != 0) {
            throw FolderDBException.folderPathInvalid(inPath);
        }
        if ((thePath = thePath.substring(1)).endsWith("/")) {
            thePath = thePath.substring(0, thePath.length() - 1);
        }
        StringEscapedTokenizer theTokenizer = new StringEscapedTokenizer(thePath, "/", "");
        String theResult = "/";
        while (theTokenizer.hasMoreTokens()) {
            String theCurToken = theTokenizer.nextToken();
            if (theCurToken.equals("..")) {
                if (theResult.equals("/")) continue;
                theResult = theResult.substring(0, theResult.length() - 1);
                int theLastSlashIdx = theResult.lastIndexOf("/");
                theResult = theResult.substring(0, theLastSlashIdx + 1);
                continue;
            }
            if (theCurToken.equals(".")) continue;
            theResult = theResult + theCurToken + "/";
        }
        return theResult;
    }

    public String findRelativePath(String path) throws FolderDBException {
        try {
            return this.getByIDQuery().selectSummaryView().findRelativePath(path);
        }
        catch (PersistenceManagerException e) {
            throw new FolderDBException(e);
        }
        catch (RPCException e) {
            throw new FolderDBException(e);
        }
    }

    protected void lockForUpdateMS() throws PersistenceManagerException {
        super.lockForUpdateMS();
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        FolderIDSet idset = new FolderIDSet();
        idset.add(this);
        return idset;
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        if (this.equals(ROOT_FOLDER_ID)) {
            throw new ObjectNotDeletableException(new ROXMessage("folderdb.ROOT_IMMUTABLE"));
        }
        try {
            SummaryFolder theSummaryFolder = this.getByIDQuery().selectSummaryView();
            try {
                MultiFolderQuery.verifyPluginWritable(theSummaryFolder);
            }
            catch (AccessControlException e) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{theSummaryFolder.getPluginID().getByIDQuery().selectSummaryView()});
            }
            FolderPermission fp = new FolderPermission(theSummaryFolder.getParentFolderID(), "write");
            try {
                AccessController.checkPermission(fp);
            }
            catch (AccessControlException e) {
                throw new ObjectNotDeletableException(fp.getMessage());
            }
            MultiComponentQuery theMCQ = MultiComponentQuery.all();
            FullPathFilter thePathFilter = new FullPathFilter(this, null, true);
            theMCQ.setFullPathFilter(thePathFilter);
            theMCQ.setVisibilityFilter(null);
            inDependentContainer.addAllDependentObjects(theMCQ.selectSummaryView());
            MultiExecutionPlanQuery theMPQ = MultiExecutionPlanQuery.all();
            thePathFilter = new FullPathFilter(this, null, true);
            theMPQ.setFullPathFilter(thePathFilter);
            theMPQ.setVisibilityFilter(null);
            inDependentContainer.addAllDependentObjects(theMPQ.selectSummaryView());
            MultiFolderQuery theAllChildrenQuery = MultiFolderQuery.all();
            thePathFilter = new FullPathFilter(this, null, true);
            theAllChildrenQuery.setPathFilter(thePathFilter);
            inDependentContainer.addAllDependentObjects(theAllChildrenQuery.selectSummaryView());
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    public String getFullPathString() {
        try {
            return this.getByIDQuery().selectSummaryView().getFullPathString();
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error while querying folderID " + this, e, this);
            }
            return "(unknown-folder):" + this + "/";
        }
    }

    public FolderID create(String subFolder) throws PersistenceManagerException, FolderDBException, RPCException {
        Folder.validateName(subFolder);
        Folder parentFolder = new SingleFolderQuery(this).select();
        Folder folder = new Folder(subFolder, this, null);
        folder.setDescription("");
        FolderAccessData fad = parentFolder.getFolderAccessData();
        folder.setFolderAccessData(fad);
        try {
            folder.save();
        }
        catch (FolderDBException e) {
            String em = e.getMessage();
            ROXMessage roxm = e.getROXMessage();
            String msgKey = roxm.getKey();
            if (!msgKey.equals("folderdb.NAME_COLLISION") && !msgKey.equals("folderdb.LOGICAL_NAME_COLLISION")) {
                throw e;
            }
            throw FolderDBException.nameCollisionOnCreate(subFolder);
        }
        return folder.getID();
    }

    private static final class UserFolderPermissionsCtx
    extends PersistContext {
        private UserFolderPermissions mPerms;

        public UserFolderPermissionsCtx(UserFolderPermissions inPerms) {
            this.mPerms = inPerms;
        }

        public UserFolderPermissions getPerms() {
            return this.mPerms;
        }
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new FolderID(inID);
        }

        public void registerCaches(ClassMap classMap, ObjectCache objectCache) {
            FolderImplTable t = FolderImplTable.DEFAULT;
            SingleObjectByNameCache cache = new SingleObjectByNameCache(objectCache, t.FullPathString);
            classMap.addSingleObjectCache(cache);
        }
    }
}

