/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.folderdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.Messages;

public class FolderDBException
extends PersistenceManagerException
implements Messages {
    protected FolderDBException() {
    }

    public FolderDBException(ROXMessage message) {
        super(message);
    }

    public FolderDBException(ROXMessage message, Throwable t) {
        super(message, t);
    }

    public FolderDBException(Throwable t) {
        super(t);
    }

    static FolderDBException folderPathInvalid(String path) {
        return FolderDBException.newValidationError("folderdb.INVALID_FOLDER_PATH", path);
    }

    static FolderDBException folderNameInvalid(String path) {
        return FolderDBException.newValidationError("folderdb.INVALID_FOLDER_NAME", path);
    }

    static FolderDBException folderDescInvalid(String inDesc) {
        return FolderDBException.newValidationError("folderdb.INVALID_FOLDER_DESC", inDesc);
    }

    static FolderDBException wrappingTxnNotAllowed(String inPath) {
        return FolderDBException.newValidationError("folderdb.TXN_NOT_ALLOWED", inPath);
    }

    static FolderDBException nameCollisionOnCreate(String inPath) {
        return FolderDBException.newValidationError("folderdb.NAME_COLLISION_ON_CREATE", inPath);
    }

    static FolderDBException newValidationError(String code, String arg) {
        return FolderDBException.newValidationError(code, new String[]{arg});
    }

    static FolderDBException newValidationError(String code, String[] args) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 2000);
        return new FolderDBException(msg);
    }
}

