/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.folderdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentServicesInit;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.TransactionContext;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.exception.TransactionNonExistentException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderDBException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImpl;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessData;
import com.raplix.util.Validate;
import java.security.AccessControlException;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;

public class Folder
extends SummaryFolder
implements Cloneable {
    public static final String PATH_SEPARATOR = "/";
    private static final int MAX_NAME_LEN = 512;
    private static boolean sTxnTestModeOnly = false;
    private boolean mFolderIsCopy;

    public Folder(String inName, FolderID inParentID, PluginID inPluginID) throws FolderDBException, RPCException, PersistenceManagerException {
        super(FolderImpl.create());
        this.mFolderIsCopy = true;
        this.getFolderImpl().setParentFolderID(inParentID);
        this.getFolderImpl().setPluginID(inPluginID);
        Folder.validateName(inName);
        this.setName(inName);
        Folder theParentFolder = new SingleFolderQuery(inParentID).select();
        String thePathString = theParentFolder.getFullPathString() + inName + PATH_SEPARATOR;
        this.getFolderImpl().setFullPathString(thePathString);
        try {
            Plugin.checkWritePermissions(theParentFolder);
        }
        catch (AccessControlException e) {
            String theFolderDesc = theParentFolder.getFullPathString();
            throw new FolderDBException(new ROXMessage("folderdb.NO_WRITE_PERM", new String[]{theFolderDesc}), (Throwable)e);
        }
        this.getFolderImpl().setFolderAccessData(theParentFolder.getFolderAccessData());
    }

    Folder(FolderImpl inFolderImpl) {
        super(inFolderImpl);
        this.mFolderIsCopy = false;
    }

    public static void validateName(String inName) throws FolderDBException {
        if (inName.indexOf(PATH_SEPARATOR) != -1 || inName.indexOf("\\") != -1 || inName.length() == 0 || inName.length() > 512) {
            throw FolderDBException.folderNameInvalid(inName);
        }
        try {
            XMLUtil.validatePathName(PATH_SEPARATOR + inName);
        }
        catch (SystemModelParseException e) {
            throw FolderDBException.folderNameInvalid(inName);
        }
        catch (InvalidDatatypeValueException e) {
            throw FolderDBException.folderNameInvalid(inName);
        }
    }

    public static void validateDescription(String inDesc) throws FolderDBException {
        if (inDesc != null && !Validate.isValidObjectDescription(inDesc)) {
            throw FolderDBException.folderDescInvalid(inDesc);
        }
    }

    public static FolderID createPath(final String inFullPathString) throws PersistenceManagerException, FolderDBException, RPCException {
        try {
            TransactionManager t;
            PersistenceManager pm = PersistenceManager.getInstance();
            if (pm != null && (t = pm.getTransactionManager()) != null) {
                TransactionContext tc = t.getTransactionContext();
                throw FolderDBException.wrappingTxnNotAllowed(inFullPathString);
            }
        }
        catch (TransactionNonExistentException e) {
            // empty catch block
        }
        FolderCreateCtx res = (FolderCreateCtx)Folder.transactRPC(new RPCTransaction(false){

            protected PersistContext executeMS() throws PersistenceManagerException {
                try {
                    return Folder.createPathMS(inFullPathString);
                }
                catch (RPCException e) {
                    throw new FolderDBException(e);
                }
            }
        });
        return res.getID();
    }

    static FolderCreateCtx createPathMS(final String inFullPathString) throws PersistenceManagerException, FolderDBException, RPCException {
        while (true) {
            try {
                FolderCreateCtx res = (FolderCreateCtx)Folder.transactRPC(new RPCTransaction(true){

                    protected PersistContext executeMS() throws PersistenceManagerException {
                        try {
                            return Folder.trCreatePathMS(inFullPathString);
                        }
                        catch (RPCException e) {
                            throw new FolderDBException(e);
                        }
                    }
                });
                return res;
            }
            catch (FolderDBException cve) {
                ROXMessage roxm;
                String msgKey;
                String em = cve.getMessage();
                if ((msgKey = (roxm = cve.getROXMessage()).getKey()).equals("folderdb.NAME_COLLISION_ON_CREATE")) continue;
                throw cve;
            }
            break;
        }
    }

    static FolderCreateCtx trCreatePathMS(String inFullPathString) throws PersistenceManagerException, RPCException {
        String fullPath = null;
        FolderID parentID = FolderID.ROOT_FOLDER_ID;
        try {
            if (!inFullPathString.startsWith(PATH_SEPARATOR) || !inFullPathString.endsWith(PATH_SEPARATOR)) {
                throw FolderDBException.folderPathInvalid(inFullPathString);
            }
            boolean tempIndex = false;
            SingleFolderQuery existingQuery = SingleFolderQuery.byPath(inFullPathString);
            SummaryFolder existingFolder = existingQuery.selectSummaryView();
            FolderID existingID = existingFolder.getID();
            return new FolderCreateCtx(existingID);
        }
        catch (NoResultsFoundException e) {
            fullPath = inFullPathString;
            int index = fullPath.lastIndexOf(PATH_SEPARATOR, fullPath.length() - 2);
            String parentPath = index == 0 ? PATH_SEPARATOR : fullPath.substring(0, index + 1);
            String childPath = fullPath.substring(index + 1, fullPath.length() - 1);
            if (sTxnTestModeOnly) {
                if (parentPath.equals("/HA/") && childPath.equals("HB")) {
                    sTxnTestModeOnly = false;
                    throw new FolderDBException(new ROXMessage("folderdb.NAME_COLLISION_ON_CREATE"));
                }
                if (parentPath.equals("/IA/") && childPath.equals("IB")) {
                    throw new FolderDBException(new ROXMessage("folderdb.INVALID_FOLDER_DESC"));
                }
            }
            FolderCreateCtx fcctx = Folder.trCreatePathMS(parentPath);
            parentID = fcctx.getID();
            FolderID createdID = parentID.create(childPath);
            return new FolderCreateCtx(createdID);
        }
    }

    static PersistContext transactRPC(RPCTransaction transaction) throws PersistenceManagerException, RPCException {
        return PersistentServicesInit.transact(transaction);
    }

    private FolderImpl getMutableFolder() {
        if (!this.mFolderIsCopy) {
            this.setFolderImpl((FolderImpl)this.getFolderImpl().clone());
            this.mFolderIsCopy = true;
        }
        return this.getFolderImpl();
    }

    public Object clone() {
        if (this.mFolderIsCopy) {
            return new Folder((FolderImpl)this.getFolderImpl().clone());
        }
        return new Folder(this.getFolderImpl());
    }

    public FolderAccessData getFolderAccessData() {
        return this.getFolderImpl().getFolderAccessData();
    }

    public void setFolderAccessData(FolderAccessData inFolderAccessData) {
        this.getMutableFolder().setFolderAccessData(inFolderAccessData);
    }

    public void setDescription(String inDescription) {
        this.getMutableFolder().setDescription(inDescription);
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableFolder().setUpdateCount(updateCount);
    }

    public void validate() throws FolderDBException {
        this.getFolderImpl().nonTxValidate();
    }

    public void save() throws FolderDBException, PersistenceManagerException, RPCException {
        this.getMutableFolder().save();
    }

    private void setName(String inName) {
        this.getMutableFolder().setName(inName);
    }

    void setFullPathString(String inFullPathString) {
        this.getMutableFolder().setFullPathString(inFullPathString);
    }

    void setParentFolderID(FolderID inParentFolderID) {
        this.getMutableFolder().setParentFolderID(inParentFolderID);
    }

    public static void forTestOnly_SetTxnTest(boolean inTxnTestMode) {
        sTxnTestModeOnly = inTxnTestMode;
    }

    static final class FolderCreateCtx
    extends PersistContext {
        private FolderID mFolderID;

        public FolderCreateCtx(FolderID inFolderID) {
            this.setID(inFolderID);
        }

        public FolderID getID() {
            return this.mFolderID;
        }

        private void setID(FolderID inFolderID) {
            this.mFolderID = inFolderID;
        }
    }
}

