/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.folderdb;

import [Lcom.raplix.rolloutexpress.systemmodel.folderdb.CachedFolderTreeNode;;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.MultiCachedFolderTreeNodeQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.util.collections.CollectionUtil;
import java.util.Vector;

public class CachedFolderTreeNode
implements RPCSerializable {
    private SummaryFolder mSummaryFolder;
    private Vector mChildrenOrdered = new Vector();

    private CachedFolderTreeNode() {
    }

    public CachedFolderTreeNode(SummaryFolder inFolder) {
        if (inFolder == null) {
            throw new NullPointerException();
        }
        this.mSummaryFolder = inFolder;
    }

    public CachedFolderTreeNode[] getChildren() {
        return (CachedFolderTreeNode[])CollectionUtil.mapClass(this.mChildrenOrdered, CachedFolderTreeNode;.class);
    }

    public CachedFolderTreeNode[] retrieveChildren() throws RPCException, PersistenceManagerException {
        return MultiCachedFolderTreeNodeQuery.allChildrenOf(this).select();
    }

    Vector getChildrenAsVector() {
        return this.mChildrenOrdered;
    }

    public SummaryFolder getFolder() {
        return this.mSummaryFolder;
    }

    public String toString() {
        return this.mSummaryFolder.getFullPathString();
    }

    void setChildren(CachedFolderTreeNode[] inChildSummaries) {
        this.mChildrenOrdered = new Vector();
        for (int i = 0; i < inChildSummaries.length; ++i) {
            this.mChildrenOrdered.add(inChildSummaries[i]);
        }
    }
}

