/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import java.util.Hashtable;

public class VariableSettingsSelector
implements RPCSerializable {
    private Hashtable mNameMap = new Hashtable();
    private SummaryComponent mComponent;
    private ComponentVariableSettings[] mAll;
    public static final int DEFAULT = -1;
    private int mCurrent;

    private VariableSettingsSelector() {
    }

    VariableSettingsSelector(SummaryComponent comp, ComponentVariableSettings[] vars) {
        this.setComponent(comp);
        this.setAll(vars);
    }

    public SummaryComponent getComponent() {
        return this.mComponent;
    }

    private void setComponent(SummaryComponent comp) {
        this.mComponent = comp;
    }

    public ComponentVariableSettings[] getAll() {
        return this.mAll;
    }

    void setAll(ComponentVariableSettings[] all) {
        this.mAll = all;
        this.mCurrent = -1;
        this.mNameMap.clear();
        for (int i = 0; i < all.length; ++i) {
            this.mNameMap.put(all[i].getName(), new Integer(i));
        }
    }

    public int getIndexOfCurrent() {
        return this.mCurrent;
    }

    public void setIndexOfCurrent(int ndx) {
        if (ndx != -1 && (ndx < 0 || ndx >= this.mAll.length)) {
            throw new IndexOutOfBoundsException(String.valueOf(ndx));
        }
        this.mCurrent = ndx;
    }

    public ComponentVariableSettings getCurrent() {
        return this.mCurrent == -1 ? null : this.mAll[this.mCurrent];
    }

    public int getIndexOfName(String name) {
        Integer ndx = (Integer)this.mNameMap.get(name);
        if (ndx == null) {
            return -1;
        }
        return ndx;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof VariableSettingsSelector)) {
            return false;
        }
        VariableSettingsSelector otherSel = (VariableSettingsSelector)other;
        return this.getComponent().getID().equals(otherSel.getComponent().getID()) && this.equals(this.getAll(), otherSel.getAll()) && this.getIndexOfCurrent() == otherSel.getIndexOfCurrent() && this.mNameMap.equals(otherSel.mNameMap);
    }

    private boolean equals(ComponentVariableSettings[] v1, ComponentVariableSettings[] v2) {
        if (v1.length != v2.length) {
            return false;
        }
        for (int i = 0; i < v1.length; ++i) {
            if (v1[i].getID().equals(v2[i].getID())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getComponent().getID().hashCode();
    }
}

