/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDescriptor;
import com.raplix.util.collections.TypedList;
import java.util.Collection;
import java.util.Iterator;

public class VarDescriptorList
extends TypedList {
    private static final VarDescriptor[] EMPTY_ARR = new VarDescriptor[0];

    VarDescriptorList() {
    }

    VarDescriptorList(Collection c) {
        this.addAll(c);
    }

    public VarDescriptor getVar(int index) {
        return (VarDescriptor)this.get(index);
    }

    public VarDescriptor getVar(String varName) {
        if (varName == null) {
            return null;
        }
        Iterator vars = this.iterator();
        while (vars.hasNext()) {
            VarDescriptor var = (VarDescriptor)vars.next();
            if (!varName.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    public Object[] toArray() {
        return this.toVarArray();
    }

    public VarDescriptor[] toVarArray() {
        return this.toVarArray(EMPTY_ARR);
    }

    public VarDescriptor[] toVarArray(VarDescriptor[] arr) {
        return (VarDescriptor[])super.toArray(arr);
    }

    protected void checkElement(Object obj) {
        VarDescriptor v = (VarDescriptor)obj;
        if (v == null) {
            throw new NullPointerException();
        }
    }

    VariableSettingsSource toVariableSettingsSource() {
        VariableSettingsHolder result = new VariableSettingsHolder();
        Iterator vars = this.iterator();
        while (vars.hasNext()) {
            VarDescriptor var = (VarDescriptor)vars.next();
            if (var.getOverrideValue() == null) continue;
            result.setVarValue(var.getName(), var.getOverrideValue());
        }
        return result;
    }
}

