/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;

public class VarDescriptor
implements RPCSerializable {
    private boolean mIsReadOnly = false;
    private boolean mIsInherited = false;
    private String mName;
    private String mDefaultValue;
    private String mOverrideValue;
    private String mDefaultPrompt;
    private String mOverridePrompt;
    private Modifier mModifier = null;
    private AccessMode mAccessMode = null;

    public VarDescriptor(String name) {
        this.setName(name);
    }

    VarDescriptor(String name, String defaultValue) {
        this(name);
        this.setDefaultValue(defaultValue);
    }

    VarDescriptor(VarDecl varDecl, Component comp) {
        VarDecl inheritedDecl;
        this.setName(varDecl.getName());
        if (varDecl.getDeclaringComponent() == comp) {
            this.mModifier = varDecl.getModifier();
            this.mAccessMode = varDecl.getAccessMode();
            inheritedDecl = varDecl.getOverriddenVarDecl();
            this.setOverrideValue(varDecl.getDefaultValue());
            this.setOverridePrompt(varDecl.getPrompt());
            this.setIsReadOnly(false);
        } else {
            inheritedDecl = varDecl;
            this.setIsReadOnly(Modifier.FINAL.equals(varDecl.getModifier()));
        }
        this.setIsInherited(inheritedDecl != null);
        if (this.isInherited()) {
            this.setDefaultValue(inheritedDecl.getDefaultValue());
            this.setDefaultPrompt(inheritedDecl.getPrompt());
        }
    }

    private VarDescriptor() {
    }

    public boolean isReadOnly() {
        return this.mIsReadOnly;
    }

    private void setIsReadOnly(boolean isReadOnly) {
        this.mIsReadOnly = isReadOnly;
    }

    public boolean isInherited() {
        return this.mIsInherited;
    }

    private void setIsInherited(boolean isInherited) {
        this.mIsInherited = isInherited;
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        this.mName = name;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    private void setDefaultValue(String val) {
        this.mDefaultValue = val;
    }

    public String getOverrideValue() {
        return this.mOverrideValue;
    }

    public void setOverrideValue(String value) {
        if (this.isReadOnly() && value != null) {
            throw new IllegalArgumentException("read only var");
        }
        this.mOverrideValue = value;
    }

    public String getDefaultPrompt() {
        return this.mDefaultPrompt;
    }

    private void setDefaultPrompt(String prompt) {
        this.mDefaultPrompt = prompt;
    }

    public String getOverridePrompt() {
        return this.mOverridePrompt;
    }

    public void setOverridePrompt(String prompt) {
        if (this.isReadOnly() && prompt != null) {
            throw new IllegalArgumentException("read only var");
        }
        this.mOverridePrompt = prompt;
    }

    VarDecl generateVarDecl() {
        if (this.getOverrideValue() == null && this.getOverridePrompt() == null) {
            return null;
        }
        if (this.getOverrideValue() == null) {
            return new VarDecl(this.mAccessMode, this.mModifier, this.getName(), this.getDefaultValue(), this.getOverridePrompt());
        }
        if (this.getOverridePrompt() == null) {
            return new VarDecl(this.mAccessMode, this.mModifier, this.getName(), this.getOverrideValue(), this.getDefaultPrompt());
        }
        return new VarDecl(this.mAccessMode, this.mModifier, this.getName(), this.getOverrideValue(), this.getOverridePrompt());
    }
}

