/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberBase;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class VarDecl
extends ComponentMemberBase {
    private String mDefaultValue;
    private String mPrompt;
    public static final String ELEMENT_NAME = "var";
    public static final String LIST_ELEMENT_NAME = "varList";
    private static final String DEFAULT_ATTR = "default";
    private static final String PROMPT_ATTR = "prompt";

    private VarDecl() {
    }

    public VarDecl(AccessMode accessMode, Modifier modifier, String name, String defaultVal, String prompt) {
        super(accessMode, modifier, name);
        this.setDefaultValue(defaultVal);
        this.setPrompt(prompt);
    }

    public VarDecl(AccessMode accessMode, Modifier modifier, String name, String defaultVal) {
        this(accessMode, modifier, name, defaultVal, null);
    }

    public VarDecl(String name, String defaultVal) {
        this(null, null, name, defaultVal);
    }

    public VarDecl(Element element, FolderID path, boolean isInternal) {
        super(element, null);
        Attr defaultAttr = element.getAttributeNode(DEFAULT_ATTR);
        if (defaultAttr != null) {
            this.setDefaultValue(defaultAttr.getValue());
        }
        this.setPrompt(XMLUtil.getAttribute(element, PROMPT_ATTR));
    }

    public VarDecl getOverriddenVarDecl() {
        return (VarDecl)this.getOverriddenMember();
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    private void setDefaultValue(String defaultValue) {
        this.mDefaultValue = defaultValue;
    }

    public String getPrompt() {
        return this.mPrompt;
    }

    private void setPrompt(String prompt) {
        this.mPrompt = prompt;
    }

    protected void populateXML(XML var, boolean isInternal) {
        XMLUtil.addAttributeIfNotNull(var, DEFAULT_ATTR, this.getDefaultValue());
        XMLUtil.addAttributeIfNotNull(var, PROMPT_ATTR, this.getPrompt());
    }

    public static VariableSettingsSource toVariableSettings(VarDecl[] vars) {
        VariableSettingsHolder result = new VariableSettingsHolder();
        for (int i = 0; i < vars.length; ++i) {
            String defaultValue = vars[i].getDefaultValue();
            if (defaultValue == null) continue;
            result.setVarValue(vars[i].getName(), defaultValue);
        }
        return result;
    }

    static VariableSettingsSource toVariableSettings(VarDecl[] vars, String valIfNull) {
        VariableSettingsHolder result = new VariableSettingsHolder();
        for (int i = 0; i < vars.length; ++i) {
            String defaultValue = vars[i].getDefaultValue();
            if (defaultValue == null) {
                defaultValue = valIfNull;
            }
            result.setVarValue(vars[i].getName(), defaultValue);
        }
        return result;
    }

    protected void validate(Component declarer) throws ComponentDBException, PlanDBException {
        super.validate(declarer);
        if (Modifier.ABSTRACT.equals(this.getModifier())) {
            if (this.getDefaultValue() != null) {
                throw ComponentDBException.nonEmptyAbstractVar(this);
            }
        } else if (this.getDefaultValue() == null) {
            throw ComponentDBException.emptyNonAbstractVar(this);
        }
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected String getListElementName() {
        return LIST_ELEMENT_NAME;
    }

    void accept(CompDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getDefaultValue());
    }

    ComponentMemberBase accept(CompDBTransformer t) throws Exception {
        VarDecl result = (VarDecl)super.accept(t);
        result.setDefaultValue(t.transformToken(this.getDefaultValue()));
        return result;
    }
}

