/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlock;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.util.ObjectUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class UninstallBlock
extends NamedBlock {
    public static final String ELEMENT_NAME = "uninstallSteps";
    public static final String LIST_ELEMENT_NAME = "uninstallList";
    private static final String DEPENDANT_CLEANUP_ELEM = "dependantCleanup";
    private static final HashSet IGNORES = (HashSet)ExecStep.DEFAULT_BLOCK_IGNORES.clone();
    private Vector mDependantCleanupSteps = new Vector();

    private UninstallBlock() {
    }

    public UninstallBlock(String inName, String inDescription) {
        super(inName, inDescription);
    }

    public UninstallBlock(String name, String description, PromptParamList params, VariableSettingsSource localVars) {
        super(name, description, params, localVars);
    }

    public UninstallBlock(AccessMode accessMode, Modifier modifier, String name, String description, PromptParamList params, VariableSettingsSource localVars) {
        super(accessMode, modifier, name, description, params, localVars);
    }

    public UninstallBlock(AccessMode accessMode, Modifier modifier, String name, String description, PromptParamList params, VariableSettingsSource localVars, boolean returns) {
        super(accessMode, modifier, name, description, params, localVars, returns);
    }

    public UninstallBlock(Element uninstallElement, FolderID path, boolean isInternal) throws SystemModelParseException {
        super(uninstallElement, IGNORES);
        ExecStep[] steps = ExecStep.parseStepBlock(uninstallElement, DEPENDANT_CLEANUP_ELEM);
        if (steps != null) {
            this.setDependantCleanupSteps(steps);
        }
    }

    public UninstallBlock getOverriddenBlock() {
        return (UninstallBlock)this.getOverriddenMember();
    }

    public void addDependantCleanupStep(ExecStep inStep) {
        this.mDependantCleanupSteps.addElement(inStep);
    }

    public ExecStep[] getDependantCleanupSteps() {
        return this.mDependantCleanupSteps.toArray(new ExecStep[this.mDependantCleanupSteps.size()]);
    }

    public void setDependantCleanupSteps(ExecStep[] steps) {
        this.mDependantCleanupSteps.clear();
        if (steps != null) {
            this.mDependantCleanupSteps.addAll(Arrays.asList(steps));
        }
    }

    protected void writeStepsToXML(XML outXML) {
        if (this.mDependantCleanupSteps.size() > 0) {
            XML cleanupSteps = new XML(DEPENDANT_CLEANUP_ELEM);
            cleanupSteps.setPrettyPrint(true);
            for (int i = 0; i < this.mDependantCleanupSteps.size(); ++i) {
                ExecStep theStep = (ExecStep)this.mDependantCleanupSteps.elementAt(i);
                theStep.writeToXML(cleanupSteps);
            }
            outXML.addElement((org.apache.ecs.Element)cleanupSteps);
        }
        super.writeStepsToXML(outXML);
    }

    protected boolean hasEmptyBody() {
        return super.hasEmptyBody() && this.mDependantCleanupSteps.size() == 0;
    }

    protected void validateSteps(Caller container) throws PlanDBException {
        ExecStep.validateSteps(this.mDependantCleanupSteps, container);
        super.validateSteps(container);
    }

    public boolean equalsData(NamedBlock other) {
        if (!(other instanceof UninstallBlock)) {
            return false;
        }
        UninstallBlock otherBlock = (UninstallBlock)other;
        return super.equalsData(other) && ObjectUtil.equals(this.mDependantCleanupSteps, otherBlock.mDependantCleanupSteps);
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected String getListElementName() {
        return LIST_ELEMENT_NAME;
    }

    public Object clone() {
        UninstallBlock result = (UninstallBlock)super.clone();
        result.mDependantCleanupSteps = ExecStep.deepClone(result.mDependantCleanupSteps);
        return result;
    }

    void acceptSteps(CompDBVisitor v) throws Exception {
        ExecStep[] dependantCleanupSteps = this.mDependantCleanupSteps.toArray(new ExecStep[this.mDependantCleanupSteps.size()]);
        v.visit(dependantCleanupSteps);
        super.acceptSteps(v);
    }

    void acceptSteps(CompDBTransformer t, NamedBlock result) throws Exception {
        super.acceptSteps(t, result);
        UninstallBlock resultBlock = (UninstallBlock)result;
        for (int i = 0; i < this.mDependantCleanupSteps.size(); ++i) {
            ExecStep es = (ExecStep)this.mDependantCleanupSteps.get(i);
            resultBlock.mDependantCleanupSteps.set(i, t.transform(es));
        }
    }

    static {
        IGNORES.add(DEPENDANT_CLEANUP_ELEM);
    }
}

