/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.util.enum.NoSuchEnumException;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class TargetRef
implements Cloneable,
RPCSerializable {
    private String mHostName;
    private String mTypeName;
    private String mConnStr;
    private ConnectionType mConnection;
    private String mIPAddr;
    private String mPort;
    private String mParams;
    private Component mComp;
    private static final String TARGETREF_ELEM = "targetRef";
    private static final String HOSTNAME_ATTR = "hostName";
    private static final String HOSTTYPE_ATTR = "typeName";
    private static final String AGENT_ELEM = "agent";
    private static final String CONN_ATTR = "connection";
    private static final String IP_ATTR = "ipAddr";
    private static final String PORT_ATTR = "port";
    private static final String PARAMS_ATTR = "params";
    private static final String DEFAULT_PORT = "1131";

    private TargetRef() {
    }

    public TargetRef(Element elem) {
        this.setHostName(XMLUtil.getAttribute(elem, HOSTNAME_ATTR));
        this.setTypeName(XMLUtil.getAttribute(elem, HOSTTYPE_ATTR));
        Element[] agent = XMLUtil.getChildren(elem, AGENT_ELEM);
        if (agent.length > 0) {
            this.setConnectionString(XMLUtil.getAttribute(agent[0], CONN_ATTR));
            this.setIPAddr(XMLUtil.getAttribute(agent[0], IP_ATTR));
            this.setPort(XMLUtil.getAttribute(agent[0], PORT_ATTR));
            this.setParams(XMLUtil.getAttribute(agent[0], PARAMS_ATTR));
        }
    }

    public TargetRef(String hostName, String typeName, String connection, String ipAddr, String port, String params) {
        this(hostName, typeName);
        this.setConnectionString(connection);
        this.setIPAddr(ipAddr);
        this.setPort(port);
        this.setParams(params);
    }

    public TargetRef(String hostName, String typeName) {
        this.setHostName(hostName);
        this.setTypeName(typeName);
    }

    public String getHostName() {
        return this.mHostName;
    }

    private void setHostName(String hostName) {
        if (hostName == null) {
            throw new NullPointerException();
        }
        this.mHostName = hostName;
    }

    public String getTypeName() {
        return this.mTypeName;
    }

    private void setTypeName(String typeName) {
        this.mTypeName = typeName != null ? typeName : SystemPluginConstants.DEFAULT_HOST_TYPE_NAME;
    }

    public String getConnectionString() {
        return this.mConnStr;
    }

    private void setConnectionString(String connStr) {
        if (connStr == null) {
            throw new NullPointerException();
        }
        this.mConnStr = connStr;
    }

    public ConnectionType getConnection() {
        return this.mConnection;
    }

    private void setConnection(ConnectionType conn) {
        if (conn == null) {
            throw new NullPointerException();
        }
        this.mConnection = conn;
    }

    public String getIPAddr() {
        return this.mIPAddr;
    }

    private void setIPAddr(String ip) {
        if (ip == null) {
            throw new NullPointerException();
        }
        this.mIPAddr = ip;
    }

    public String getPort() {
        return this.mPort;
    }

    private void setPort(String port) {
        this.mPort = port;
    }

    public String getParams() {
        return this.mParams;
    }

    private void setParams(String params) {
        this.mParams = params;
    }

    public boolean isVirtual() {
        return this.mConnStr == null;
    }

    public Component getDeclaringComponent() {
        return this.mComp;
    }

    void setDeclaringComponent(Component comp) {
        this.mComp = comp;
    }

    public TargetRef generate(ComponentConfigManager configMgr) throws ConfigGenException, ComponentDBException {
        TargetRef copy = (TargetRef)this.clone();
        ConfigGenerator generator = configMgr.newCallerScope(new Caller(null, this.getDeclaringComponent()));
        copy.setHostName(generator.generate(copy.getHostName()));
        if (!this.isVirtual()) {
            String connStr = copy.getConnectionString();
            connStr = generator.generate(connStr);
            copy.setConnectionString(connStr);
            try {
                copy.setConnection(ConnectionType.FACTORY.get(connStr.toLowerCase()));
            }
            catch (NoSuchEnumException e) {
                throw ComponentDBException.invalidTgtRefConnType(this.getDeclaringComponent(), connStr);
            }
            if (!connStr.equals(copy.getConnection().toString().toUpperCase())) {
                throw ComponentDBException.invalidTgtRefConnType(this.getDeclaringComponent(), connStr);
            }
            copy.setIPAddr(generator.generate(copy.getIPAddr()));
            if (this.getPort() == null) {
                if (copy.getConnection() != null) {
                    if (copy.getConnection().equals(ConnectionType.RAW) || copy.getConnection().equals(ConnectionType.SSL)) {
                        copy.setPort(DEFAULT_PORT);
                    } else if (copy.getConnection().equals(ConnectionType.SSH)) {
                        copy.setPort(Integer.toString(AppType.RA.getDefaultSSHPort()));
                    }
                }
            } else {
                copy.setPort(generator.generate(copy.getPort()));
            }
            copy.setParams(generator.generate(copy.getParams()));
        }
        return copy;
    }

    protected void populateXML(XML var) {
        XMLUtil.addAttributeIfNotNull(var, HOSTNAME_ATTR, this.getHostName());
        XMLUtil.addAttributeIfNotNull(var, HOSTTYPE_ATTR, this.getTypeName());
        if (!this.isVirtual()) {
            XML agent = new XML(AGENT_ELEM);
            agent.setPrettyPrint(true);
            XMLUtil.addAttributeIfNotNull(agent, CONN_ATTR, this.getConnectionString());
            XMLUtil.addAttributeIfNotNull(agent, IP_ATTR, this.getIPAddr());
            XMLUtil.addAttributeIfNotNull(agent, PORT_ATTR, this.getPort());
            XMLUtil.addAttributeIfNotNull(agent, PARAMS_ATTR, this.getParams());
            var.addElement((org.apache.ecs.Element)agent);
        }
    }

    protected Object clone() {
        try {
            TargetRef result = (TargetRef)super.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void accept(CompDBVisitor v) throws Exception {
        v.visitToken(this.getHostName());
        if (!this.isVirtual()) {
            v.visitToken(this.getConnectionString());
            v.visitToken(this.getIPAddr());
            v.visitToken(this.getPort());
            v.visitToken(this.getParams());
        }
    }

    TargetRef accept(CompDBTransformer t) throws Exception {
        TargetRef result = t.clone(this);
        result.setHostName(t.transformToken(this.getHostName()));
        if (!this.isVirtual()) {
            result.setConnectionString(t.transformToken(this.getConnectionString()));
            result.setIPAddr(t.transformToken(this.getIPAddr()));
            result.setPort(t.transformToken(this.getPort()));
            result.setParams(t.transformToken(this.getParams()));
        }
        return result;
    }

    TargetRef cloneForTransform() {
        return (TargetRef)this.clone();
    }

    void validateNamespace(CompDBPluginNSValidator v) throws Exception {
        this.accept(v);
        v.visitHostType(this.getTypeName());
    }

    static String getElementName() {
        return TARGETREF_ELEM;
    }
}

