/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.executor.target.TargetSQLOps;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Not;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSQLOps;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallStatus;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;

class SystemServiceRefSQLOps
extends SystemServiceRefImplTable {
    public static final SystemServiceRefSQLOps DEFAULT = new SystemServiceRefSQLOps();

    public SystemServiceRefSQLOps(String alias) {
        super(alias);
    }

    private SystemServiceRefSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new SystemServiceRefSQLOps(alias);
    }

    public ConditionalExpression isName(String name) {
        return SystemServiceRefSQLOps.equals(this.Name, name);
    }

    public OrderByList orderByNameAsc(QueryContext ctx) {
        return SystemServiceRefSQLOps.dictOrderAsc(this.Name);
    }

    public OrderByList orderByNameDesc(QueryContext ctx) {
        return SystemServiceRefSQLOps.dictOrderDesc(this.Name);
    }

    public Select selectCompByRef(SystemServiceRefID ref) {
        return this.select(SystemServiceRefSQLOps.sList(this.InstCompPathID, this.InstCompName, this.InstCompVersion), SystemServiceRefSQLOps.where(SystemServiceRefSQLOps.equals(this.ID, ref)));
    }

    public Select selectCompByRef(String name) {
        return this.select(SystemServiceRefSQLOps.sList(this.InstCompPathID, this.InstCompName, this.InstCompVersion), SystemServiceRefSQLOps.where(SystemServiceRefSQLOps.equals(this.Name, name)));
    }

    public ConditionalExpression refsComponent(ComponentID cID) {
        ComponentSQLOps ct = ComponentSQLOps.DEFAULT;
        return this.refsComp(ct, SystemServiceRefSQLOps.equals(ct.ID, cID));
    }

    ConditionalExpression refsComp(ComponentSQLOps ct, ConditionalExpression cond) {
        return SystemServiceRefSQLOps.in(SystemServiceRefSQLOps.cList(this.InstCompPathID, this.InstCompName, this.InstCompVersion), ct.select(SystemServiceRefSQLOps.sList(ct.PathID, ct.Name, ct.Version), SystemServiceRefSQLOps.where(cond)));
    }

    public ConditionalExpression isNotInstalledOn(HostID hostID) throws RPCException, PersistenceManagerException {
        ComponentSQLOps ct = new ComponentSQLOps("icT");
        TargetSQLOps tt = new TargetSQLOps("itT");
        PersistentInstalledComponentTable ict = new PersistentInstalledComponentTable("iicT");
        AndExp isInstalled = SystemServiceRefSQLOps.and();
        isInstalled.add(SystemServiceRefSQLOps.equals(ict.InstallStatus, InstallStatus.INSTALLED));
        isInstalled.add(tt.equalsHost(hostID, TargetType.PHYSICAL));
        isInstalled.add(SystemServiceRefSQLOps.equals((ColumnNode)ict.TargetID, tt.ID));
        isInstalled.add(SystemServiceRefSQLOps.equals((ColumnNode)ct.ID, ict.ComponentID));
        isInstalled.add((ConditionalExpression)SystemServiceRefSQLOps.or(SystemServiceRefSQLOps.isNull(this.InstCompInstallPath), SystemServiceRefSQLOps.equals((ColumnNode)this.InstCompInstallPath, ict.InstallPath)));
        Not compIsNotInstalled = SystemServiceRefSQLOps.not(SystemServiceRefSQLOps.exists(SystemServiceRefSQLOps.select(SystemServiceRefSQLOps.sList(ict.ID), SystemServiceRefSQLOps.tList(ict, (TableClause)tt), SystemServiceRefSQLOps.where(isInstalled))));
        AndExp conds = SystemServiceRefSQLOps.and();
        conds.add(SystemServiceRefSQLOps.equals((ColumnNode)this.InstCompPathID, ct.PathID));
        conds.add(SystemServiceRefSQLOps.equals((ColumnNode)this.InstCompName, ct.Name));
        conds.add(SystemServiceRefSQLOps.equals((ColumnNode)this.InstCompVersion, ct.Version));
        conds.add(compIsNotInstalled);
        conds.add(ct.matchesPlatform(hostID));
        return SystemServiceRefSQLOps.exists(ct.select(SystemServiceRefSQLOps.sList(ct.ID), SystemServiceRefSQLOps.where(conds)));
    }
}

