/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireWriteLockTransaction;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallCompatibilityValidator;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemService;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderDBException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;

class SystemServiceRefImpl
extends PersistentBean
implements Cloneable {
    private String mSimpleName;
    private String mPluginName;
    private String mDescription = "";
    private InstalledComponentRef mInstalledComponentRef;
    private String mInstCompName;
    private int mInstCompVersion;
    private FolderID mInstCompPathID;
    private String mInstCompInstallPath;
    private PluginID mPluginID;

    private SystemServiceRefImpl() {
    }

    static SystemServiceRefImpl create() {
        SystemServiceRefImpl result = new SystemServiceRefImpl();
        return result;
    }

    static SystemServiceRefImpl create(PluginID plugin) throws PersistenceManagerException, RPCException {
        SystemServiceRefImpl result = SystemServiceRefImpl.create();
        result.setPluginID(plugin);
        String pluginName = plugin.getByIDQuery().selectSummaryView().getName();
        result.setPluginName(pluginName + Plugin.NAME_SEPARATOR);
        return result;
    }

    SystemServiceRefID getID() {
        return (SystemServiceRefID)super.getObjectID();
    }

    String getName() {
        if (this.getPluginID() != null) {
            return this.getPluginName() + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    private void setName(String name) {
        int separatorIndex = name.indexOf(Plugin.NAME_SEPARATOR);
        if (separatorIndex != -1) {
            this.setPluginName(name.substring(0, separatorIndex + 1));
            this.setSimpleName(name.substring(separatorIndex + 1));
        } else {
            this.setSimpleName(name);
        }
    }

    String getSimpleName() {
        return this.mSimpleName;
    }

    void setSimpleName(String simpleName) {
        if (simpleName == null) {
            throw new NullPointerException();
        }
        this.mSimpleName = simpleName;
    }

    private void setPluginName(String pluginName) {
        this.mPluginName = pluginName;
    }

    private String getPluginName() {
        return this.mPluginName;
    }

    String getDescription() {
        return this.mDescription;
    }

    void setDescription(String desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.mDescription = desc;
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int updateCount) {
        super.setUpdateCount(updateCount);
    }

    InstalledComponentRef getInstalledComponentRef() {
        return this.mInstalledComponentRef;
    }

    void setInstalledComponentRef(InstalledComponentRef installedComponentRef) {
        this.mInstalledComponentRef = installedComponentRef.toUniversal();
    }

    private String getInstCompName() {
        return this.mInstCompName;
    }

    private void setInstCompName(String instCompName) {
        this.mInstCompName = instCompName;
    }

    private int getInstCompVersion() {
        return this.mInstCompVersion;
    }

    private String getInstCompVersionString() {
        return new VersionNumber(this.getInstCompVersion()).getAsString();
    }

    private void setInstCompVersion(int instCompVersion) {
        this.mInstCompVersion = instCompVersion;
    }

    private void setInstCompVersion(String version) {
        try {
            this.mInstCompVersion = new VersionNumber(version).getSingleVersionNumber();
        }
        catch (PersistenceManagerException e) {
            this.mInstCompVersion = 0;
        }
    }

    private FolderID getInstCompPathID() {
        return this.mInstCompPathID;
    }

    private void setInstCompPathID(FolderID instCompPathID) {
        this.mInstCompPathID = instCompPathID;
    }

    private String getInstCompInstallPath() {
        return this.mInstCompInstallPath;
    }

    private void setInstCompInstallPath(String instCompInstallPath) {
        this.mInstCompInstallPath = instCompInstallPath;
    }

    SystemServiceRef getCompleteViewMS() throws FolderDBException {
        this.readInstCompFromDBProps();
        return new SystemServiceRef(this);
    }

    private void readInstCompFromDBProps() {
        if (this.mInstalledComponentRef == null) {
            this.mInstalledComponentRef = new InstalledComponentRef(this.getInstCompPathID(), this.getInstCompName(), this.getInstCompVersionString(), Comparator.EQUAL, false, this.getInstCompInstallPath(), true);
        }
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Object getObjectDataClone() {
        try {
            SystemServiceRefImpl result = (SystemServiceRefImpl)super.getObjectDataClone();
            result.setPluginID(null);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void save() throws PersistenceManagerException, RPCException {
        this.validate();
        this.writeInstCompToDBProps();
        this.saveRPC(null);
    }

    protected void saveMS(final PersistContext ctx) throws PersistenceManagerException {
        SystemServiceRefImpl.transactMS(new AcquireWriteLockTransaction(){

            public Object execute() throws PersistenceManagerException {
                SystemServiceRefImpl.this.trSaveMS(ctx);
                return null;
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("cdb.SAVING_SYSTEMSERVICEREF", SystemServiceRefImpl.this.getName());
            }
        });
    }

    private void trSaveMS(PersistContext ctx) throws PersistenceManagerException {
        Plugin.checkWritePermissions(this.getCompleteViewMS());
        try {
            Component serviceComp = this.validateRefMS();
            this.validateCallCompatibilityMS(serviceComp);
            super.saveMS(ctx);
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
    }

    private Component validateRefMS() throws PersistenceManagerException, RPCException {
        try {
            InstalledComponentRef ref = this.getInstalledComponentRef();
            Component comp = SingleComponentQuery.byRef(ref).select();
            Component systemServiceExtendor = comp.getAncestorByExtendsTypeName(SystemService.TYPE_NAME);
            if (systemServiceExtendor == null) {
                throw ComponentDBException.notSystemService();
            }
            return comp;
        }
        catch (NoResultsFoundException e) {
            throw ComponentDBException.notSystemService();
        }
    }

    private void validateCallCompatibilityMS(Component curComp) throws PersistenceManagerException, RPCException {
        SystemServiceRefID id = this.getID();
        if (id == null) {
            return;
        }
        id.lockForUpdateMS();
        SystemServiceRef oldRef = id.getByIDQuery().select();
        InstalledComponentRef oldCompRef = oldRef.getInstalledComponentRef();
        Component oldComp = SingleComponentQuery.byRef(oldCompRef).select();
        CallCompatibilityValidator.validate(oldComp, curComp);
    }

    private void writeInstCompToDBProps() {
        InstalledComponentRef instComp = this.getInstalledComponentRef();
        this.setInstCompPathID(instComp.getPath());
        this.setInstCompName(instComp.getComponentName());
        this.setInstCompVersion(instComp.getComponentVersion());
        this.setInstCompInstallPath(instComp.getInstallPath());
    }

    void validate() throws ComponentDBException {
        SystemServiceRef.validateSimpleName(this.getSimpleName());
        SystemServiceRef.validateDescription(this.getDescription());
        SystemServiceRef.validateInstalledComponentRef(this.getInstalledComponentRef());
    }

    PluginID getPluginID() {
        return this.mPluginID;
    }

    private void setPluginID(PluginID plugin) {
        this.mPluginID = plugin;
    }
}

