/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.cache.SingleObjectByNameCache;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefObserverQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import java.security.AccessControlException;

public class SystemServiceRefID
extends ObjectID {
    private static final IDFactory ID_FACTORY = new IDFactory();

    private SystemServiceRefID() {
    }

    public SystemServiceRefID(String key) {
        super(key);
    }

    public SingleSystemServiceRefQuery getByIDQuery() {
        return new SingleSystemServiceRefQuery(this);
    }

    private SingleComponentQuery getComponentQuery() throws RPCException, PersistenceManagerException {
        SystemServiceRef ref = this.getByIDQuery().select();
        return SingleComponentQuery.byRef(ref.getInstalledComponentRef());
    }

    public static SystemServiceRefID generateID() {
        return (SystemServiceRefID)ID_FACTORY.generateObjectID();
    }

    protected void lockForUpdateMS() throws PersistenceManagerException {
        super.lockForUpdateMS();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            SystemServiceRef svce = this.getByIDQuery().select();
            try {
                Plugin.checkWritePermissions(svce);
            }
            catch (AccessControlException e) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{svce.getPluginID().getByIDQuery().selectSummaryView()});
            }
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        SystemServiceRefIDSet idset = new SystemServiceRefIDSet();
        idset.add(this);
        return idset;
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new SystemServiceRefID(inID);
        }

        public void registerCaches(ClassMap classMap, ObjectCache objectCache) {
            SystemServiceRefImplTable t = SystemServiceRefImplTable.DEFAULT;
            SingleObjectByNameCache cache = new SingleObjectByNameCache(objectCache, t.Name);
            classMap.addSingleObjectCache(cache);
            ComponentID.registerObserverQuery(SystemServiceRefObserverQuery.getInstance());
        }
    }
}

