/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.util.Validate;

public class SystemServiceRef
implements RPCSerializable,
Cloneable,
UsingObject,
PluginMember,
HasObjectID {
    private boolean mImplIsCopy;
    private SystemServiceRefImpl mImpl;
    private static final int MAX_NAME_LENGTH = 64;

    public SystemServiceRef() {
        this.setImpl(SystemServiceRefImpl.create());
        this.mImplIsCopy = true;
    }

    public SystemServiceRef(PluginID plugin) throws PersistenceManagerException, RPCException {
        this.setImpl(SystemServiceRefImpl.create(plugin));
        this.mImplIsCopy = true;
    }

    SystemServiceRef(SystemServiceRefImpl impl) {
        this.setImpl(impl);
        this.mImplIsCopy = false;
    }

    private SystemServiceRefImpl getImpl() {
        return this.mImpl;
    }

    private void setImpl(SystemServiceRefImpl impl) {
        this.mImpl = impl;
    }

    private SystemServiceRefImpl getMutableImpl() {
        if (!this.mImplIsCopy) {
            this.setImpl((SystemServiceRefImpl)this.getImpl().clone());
            this.mImplIsCopy = true;
        }
        return this.getImpl();
    }

    public ObjectID getObjectID() {
        return this.getID();
    }

    public SystemServiceRefID getID() {
        return this.getImpl().getID();
    }

    public int getUpdateCount() {
        return this.getImpl().getUpdateCount();
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableImpl().setUpdateCount(updateCount);
    }

    public String getName() {
        return this.getImpl().getName();
    }

    public String getSimpleName() {
        return this.getImpl().getSimpleName();
    }

    public void setSimpleName(String name) {
        this.getMutableImpl().setSimpleName(name);
    }

    public String getDescription() {
        return this.getImpl().getDescription();
    }

    public void setDescription(String desc) {
        this.getMutableImpl().setDescription(desc);
    }

    public PluginID getPluginID() {
        return this.getImpl().getPluginID();
    }

    public InstalledComponentRef getInstalledComponentRef() {
        return this.getImpl().getInstalledComponentRef();
    }

    public void setInstalledComponentRef(InstalledComponentRef installedComponentRef) {
        this.getMutableImpl().setInstalledComponentRef(installedComponentRef);
    }

    public SystemServiceRef getDataClone() {
        return new SystemServiceRef((SystemServiceRefImpl)this.getImpl().getObjectDataClone());
    }

    public Object clone() {
        if (this.mImplIsCopy) {
            return new SystemServiceRef((SystemServiceRefImpl)this.getImpl().clone());
        }
        return new SystemServiceRef(this.getImpl());
    }

    public void save() throws ComponentDBException, PersistenceManagerException, RPCException {
        this.getMutableImpl().save();
    }

    public void validate() throws ComponentDBException {
        this.getImpl().validate();
    }

    public static void validateSimpleName(String name) throws ComponentDBException {
        if (name == null) {
            throw ComponentDBException.invalidServiceRefName(name);
        }
        int len = name.length();
        if (len == 0 || len > 64) {
            throw ComponentDBException.invalidServiceRefName(name);
        }
        if (!Validate.isValidFirstCharForName(name.charAt(0))) {
            throw ComponentDBException.invalidServiceRefName(name);
        }
        for (int i = 1; i < len; ++i) {
            if (SystemServiceRef.isValidNameChar(name.charAt(i))) continue;
            throw ComponentDBException.invalidServiceRefName(name);
        }
    }

    private static boolean isValidNameChar(char ch) {
        String validchars = "-_+. ";
        return Character.isDigit(ch) || Character.isLetter(ch) || validchars.indexOf(ch) != -1;
    }

    public static void validateDescription(String desc) throws ComponentDBException {
        if (!Validate.isValidObjectDescription(desc)) {
            throw ComponentDBException.invalidServiceRefDescription(desc);
        }
    }

    public static void validateInstalledComponentRef(InstalledComponentRef ref) throws ComponentDBException {
        if (ref == null) {
            throw ComponentDBException.emptyServiceRefComponentRef();
        }
        if (ref.hasUnresolvedPath()) {
            throw ComponentDBException.invalidServiceRefComponentRef(ref);
        }
        if (!Comparator.EQUAL.equals(ref.getVersionComparator())) {
            throw ComponentDBException.invalidServiceRefComponentRef(ref);
        }
        if (ref.getOnlyCallCompatible()) {
            throw ComponentDBException.invalidServiceRefComponentRef(ref);
        }
        if (!Validate.isValidObjectName(ref.getComponentName(), 512)) {
            throw ComponentDBException.invalidServiceRefComponentRef(ref);
        }
        try {
            new VersionNumber(ref.getComponentVersion());
        }
        catch (PersistenceManagerException e) {
            throw ComponentDBException.invalidServiceRefComponentRef(ref);
        }
    }
}

