/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.UninstallBlock;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;

public class SystemService {
    public static final String TYPE_NAME = "system" + Plugin.NAME_SEPARATOR + "system service";
    private Component mComponent;
    public static final String INSTALL_BLOCK_NAME = "default";
    public static final String UNINSTALL_BLOCK_NAME = "default";

    public SystemService(String name) throws PersistenceManagerException, RPCException {
        this(SystemService.getComponent(name));
    }

    private static Component getComponent(String name) throws PersistenceManagerException, RPCException {
        SystemServiceRef ref = SingleSystemServiceRefQuery.byName(name).select();
        return SingleComponentQuery.byRef(ref.getInstalledComponentRef()).select();
    }

    public SystemService(Component comp) {
        this.setComponent(comp);
    }

    public Component getComponent() {
        return this.mComponent;
    }

    private void setComponent(Component component) {
        this.mComponent = component;
    }

    public InstallBlock getInstallBlock() {
        return this.getComponent().resolveInstallBlock("default", null);
    }

    public UninstallBlock getUninstallBlock() {
        return this.getComponent().resolveUninstallBlock("default", null);
    }
}

