/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedData;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ElementDescriptor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.message.MessageManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class SummaryComponent
implements StandardObject,
VersionedData,
RPCSerializable,
HasObjectID,
UsingObject,
ElementDescriptor,
PluginMember {
    private ComponentImpl mComponent;

    private SummaryComponent() {
    }

    SummaryComponent(ComponentImpl component) {
        this.setComponent(component);
    }

    ComponentImpl getComponent() {
        return this.mComponent;
    }

    void setComponent(ComponentImpl component) {
        this.mComponent = component;
    }

    public ObjectID getObjectID() {
        return this.getID();
    }

    public ComponentID getID() {
        return this.getComponent().getID();
    }

    public Visibility getVisibility() {
        return this.getComponent().getVisibility();
    }

    public AccessMode getAccessMode() {
        return this.getComponent().getAccessMode();
    }

    public Modifier getModifier() {
        return this.getComponent().getModifier();
    }

    public String getName() {
        return this.getComponent().getName();
    }

    public FolderID getPath() {
        return this.getComponent().getPathID();
    }

    public String getFullName() {
        return this.getComponent().getFullName();
    }

    public String getDescription() {
        return this.getComponent().getDescription();
    }

    public String getLabel() {
        return this.getComponent().getLabel();
    }

    public int getUpdateCount() {
        return this.getComponent().getUpdateCount();
    }

    public String getPlatform() {
        return this.getComponent().getPlatform();
    }

    MultiHostSetQuery getCompatiblePlatforms() throws PersistenceManagerException, RPCException {
        SummaryHostSet platform = SingleHostSetQuery.byName(this.getPlatform()).selectSummaryView();
        return platform.getID().getDescendantsQuery();
    }

    public String getLocalLimitToHostSet() {
        return this.getComponent().getLocalLimitToHostSet();
    }

    public String getExtendsTypeName() {
        return this.getComponent().getExtendsTypeName();
    }

    public String getSoftwareVendor() {
        return this.getComponent().getSoftwareVendor();
    }

    public String getAuthor() {
        return this.getComponent().getAuthor();
    }

    public String getLocalInstallPath() {
        return this.getComponent().getLocalInstallPath();
    }

    public String[] getLocalIgnorePaths() {
        return this.getComponent().getIgnorePaths();
    }

    public boolean isDerivedComponent() {
        return this.getComponent().isDerivedComponent();
    }

    public boolean isSimpleComponent() {
        return this.getComponent().getIsSimpleComponent();
    }

    public SourceInfo getSourceInfo() {
        return this.getComponent().getSourceInfo();
    }

    public UserID getUserID() {
        return this.getComponent().getUserID();
    }

    public Date getTimeStamp() {
        return this.getComponent().getTimeStamp();
    }

    public VersionNumber getVersionNumber() {
        return this.getComponent().getVersionNumber();
    }

    public ObjectID getRootObjectID() {
        return this.getRootID();
    }

    public ComponentID getRootID() {
        return this.getComponent().getRootID();
    }

    public static SummaryComponent createFromResultSet(ComponentImplTable table, ResultSet rs) throws PersistenceManagerException, SQLException {
        return table.retrieveObject(rs).getSummaryView();
    }

    public String getElementDescription() {
        return MessageManager.messageAsString("cdb.member.component");
    }

    public PluginID getPluginID() {
        return this.getComponent().getPluginID();
    }

    boolean isMoveNeeded(String name, SummaryFolder path) {
        return this.getComponent().isMoveNeeded(name, path);
    }
}

