/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.TokenCallContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallScopeBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberBase;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.plandb.VarList;
import com.raplix.util.ObjectUtil;
import java.util.Arrays;
import java.util.Vector;
import org.apache.ecs.xml.XML;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.w3c.dom.Element;

public class SnapshotBlock
extends ComponentMemberBase
implements CallScopeBlock {
    private String mDescription;
    private ExecStep[] mPrepareSteps = EMPTY_STEPS;
    private ExecStep[] mCaptureSteps = EMPTY_STEPS;
    private ExecStep[] mCleanupSteps = EMPTY_STEPS;
    private PromptParamList mParams;
    private VarList mLocalVars;
    public static final String ELEMENT_NAME = "snapshot";
    public static final String LIST_ELEMENT_NAME = "snapshotList";
    private static final String ATTR_DESC = "description";
    private static final String ELEM_PREPARE = "prepare";
    private static final String ELEM_CAPTURE = "capture";
    private static final String ELEM_CLEANUP = "cleanup";
    private static final ExecStep[] EMPTY_STEPS = new ExecStep[0];

    private SnapshotBlock() {
    }

    public SnapshotBlock(AccessMode accessMode, Modifier modifier, String name, String description, ExecStep[] prepare, ExecStep[] capture, ExecStep[] cleanup, PromptParamList params, VariableSettingsSource localVars) {
        super(accessMode, modifier, name);
        this.setDescription(description);
        this.setPrepareSteps(prepare, true);
        this.setCaptureSteps(capture, true);
        this.setCleanupSteps(cleanup, true);
        this.setAndCloneParams(params);
        this.setLocalVars(localVars);
    }

    public SnapshotBlock(Element element, FolderID path, boolean isInternal) throws SystemModelParseException {
        super(element, null);
        this.setDescription(XMLUtil.getAttribute(element, ATTR_DESC));
        this.setParams(new PromptParamList(element));
        this.setLocalVars(new VarList(element, this.mParams));
        this.setPrepareSteps(this.parseSteps(element, ELEM_PREPARE), false);
        this.setCaptureSteps(this.parseSteps(element, ELEM_CAPTURE), false);
        this.setCleanupSteps(this.parseSteps(element, ELEM_CLEANUP), false);
    }

    private ExecStep[] parseSteps(Element elem, String elemName) throws SystemModelParseException {
        Element[] blocks = XMLUtil.getChildren(elem, elemName);
        if (blocks.length > 0) {
            Vector steps = new Vector();
            ExecStep.parseExecSteps(blocks[0], steps);
            return steps.toArray(new ExecStep[steps.size()]);
        }
        return null;
    }

    public SnapshotBlock getOverriddenBlock() {
        return (SnapshotBlock)this.getOverriddenMember();
    }

    public String getDescription() {
        return this.mDescription;
    }

    private void setDescription(String description) {
        this.mDescription = description;
    }

    public ExecStep[] getPrepareSteps() {
        return (ExecStep[])this.mPrepareSteps.clone();
    }

    private void setPrepareSteps(ExecStep[] prepareSteps, boolean clone) {
        if (prepareSteps == null) {
            prepareSteps = EMPTY_STEPS;
        } else if (clone) {
            prepareSteps = (ExecStep[])prepareSteps.clone();
        }
        this.mPrepareSteps = prepareSteps;
    }

    public ExecStep[] getCaptureSteps() {
        return (ExecStep[])this.mCaptureSteps.clone();
    }

    private void setCaptureSteps(ExecStep[] captureSteps, boolean clone) {
        if (captureSteps == null) {
            captureSteps = EMPTY_STEPS;
        } else if (clone) {
            captureSteps = (ExecStep[])captureSteps.clone();
        }
        this.mCaptureSteps = captureSteps;
    }

    public ExecStep[] getCleanupSteps() {
        return (ExecStep[])this.mCleanupSteps.clone();
    }

    private void setCleanupSteps(ExecStep[] cleanupSteps, boolean clone) {
        if (cleanupSteps == null) {
            cleanupSteps = EMPTY_STEPS;
        } else if (clone) {
            cleanupSteps = (ExecStep[])cleanupSteps.clone();
        }
        this.mCleanupSteps = cleanupSteps;
    }

    public PromptParamList getParams() {
        return (PromptParamList)this.mParams.clone();
    }

    private void setAndCloneParams(PromptParamList params) {
        params = params == null ? new PromptParamList() : (PromptParamList)params.clone();
        this.setParams(params);
    }

    private void setParams(PromptParamList params) {
        this.mParams = params;
    }

    public VariableSettingsSource getLocalVars() {
        return (VariableSettingsSource)this.mLocalVars.clone();
    }

    private void setLocalVars(VariableSettingsSource localVars) {
        if (localVars == null) {
            this.setLocalVars(new VarList());
        } else {
            this.setLocalVars(new VarList(localVars));
        }
    }

    private void setLocalVars(VarList localVars) {
        this.mLocalVars = localVars;
    }

    protected void populateXML(XML snapshot, boolean isInternal) {
        XMLUtil.addAttributeIfNotNull(snapshot, ATTR_DESC, this.getDescription());
        this.mParams.writeToXML(snapshot);
        this.mLocalVars.writeToXML(snapshot);
        this.addSteps(snapshot, ELEM_PREPARE, this.mPrepareSteps);
        this.addSteps(snapshot, ELEM_CAPTURE, this.mCaptureSteps);
        this.addSteps(snapshot, ELEM_CLEANUP, this.mCleanupSteps);
    }

    private void addSteps(XML snapshot, String elemName, ExecStep[] steps) {
        if (steps.length == 0) {
            return;
        }
        XML block = new XML(elemName);
        block.setPrettyPrint(true);
        for (int i = 0; i < steps.length; ++i) {
            steps[i].writeToXML(block);
        }
        snapshot.addElement((org.apache.ecs.Element)block);
    }

    protected void validateName(String name) throws SystemModelParseException, InvalidDatatypeValueException {
        XMLUtil.validateEntityName(name);
    }

    protected void validate(Component declarer) throws ComponentDBException, PlanDBException {
        SnapshotBlock overridden;
        super.validate(declarer);
        if (Modifier.ABSTRACT.equals(this.getModifier())) {
            if (!this.hasEmptyBody()) {
                throw ComponentDBException.nonEmptyAbstractSnapshot(this);
            }
        } else {
            Caller caller = new Caller(null, declarer);
            ExecStep.validateSteps(this.mPrepareSteps, caller);
            ExecStep.validateSteps(this.mCaptureSteps, caller);
            ExecStep.validateSteps(this.mCleanupSteps, caller);
        }
        if ((overridden = (SnapshotBlock)this.getOverriddenMember(declarer)) != null) {
            this.validateCompatibleParams(this.mParams, overridden.mParams);
        }
    }

    protected boolean hasEmptyBody() {
        return this.mLocalVars.size() == 0 && this.mPrepareSteps.length == 0 && this.mCaptureSteps.length == 0 && this.mCleanupSteps.length == 0;
    }

    public boolean equals(Object other) {
        if (other instanceof SnapshotBlock) {
            return this.equalsData((SnapshotBlock)other);
        }
        return false;
    }

    public boolean equalsData(SnapshotBlock other) {
        return other != null && ObjectUtil.equals(this.getName(), other.getName()) && ObjectUtil.equals(this.getAccessMode(), other.getAccessMode()) && ObjectUtil.equals(this.getModifier(), other.getModifier()) && ObjectUtil.equals(this.getDescription(), other.getDescription()) && ObjectUtil.equals(this.mParams, other.mParams) && ObjectUtil.equals(this.mLocalVars, other.mLocalVars) && Arrays.equals(this.mPrepareSteps, other.mPrepareSteps) && Arrays.equals(this.mCaptureSteps, other.mCaptureSteps) && Arrays.equals(this.mCleanupSteps, other.mCleanupSteps);
    }

    public Object clone() {
        SnapshotBlock result = (SnapshotBlock)super.clone();
        result.mPrepareSteps = ExecStep.deepClone(result.mPrepareSteps);
        result.mCaptureSteps = ExecStep.deepClone(result.mCaptureSteps);
        result.mCleanupSteps = ExecStep.deepClone(result.mCleanupSteps);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void accept(CompDBVisitor v) throws Exception {
        super.accept(v);
        TokenCallContext tcc = v.getTokenCallContext();
        tcc.pushVarScope();
        try {
            tcc.enterBlockVarContext();
            try {
                v.visit(this.mParams);
                v.visit(this.mLocalVars);
            }
            finally {
                tcc.exitContext();
            }
            for (int i = 0; i < this.mPrepareSteps.length; ++i) {
                v.visit(this.mPrepareSteps[i]);
            }
            for (int j = 0; j < this.mCaptureSteps.length; ++j) {
                v.visit(this.mCaptureSteps[j]);
            }
            for (int k = 0; k < this.mCleanupSteps.length; ++k) {
                v.visit(this.mCleanupSteps[k]);
            }
        }
        finally {
            tcc.popVarScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentMemberBase accept(CompDBTransformer t) throws Exception {
        SnapshotBlock result = null;
        TokenCallContext tcc = t.getTokenCallContext();
        tcc.pushVarScope();
        try {
            int i;
            tcc.enterBlockVarContext();
            try {
                result = (SnapshotBlock)super.accept(t);
                result.mParams = t.transform(this.mParams);
                result.mLocalVars = (VarList)t.transform(this.mLocalVars);
            }
            finally {
                tcc.exitContext();
            }
            ExecStep[] steps = result.mPrepareSteps;
            for (i = 0; i < steps.length; ++i) {
                steps[i] = t.transform(steps[i]);
            }
            result.setPrepareSteps(steps, false);
            steps = result.mCaptureSteps;
            for (i = 0; i < steps.length; ++i) {
                steps[i] = t.transform(steps[i]);
            }
            result.setCaptureSteps(steps, false);
            steps = result.mCleanupSteps;
            for (i = 0; i < steps.length; ++i) {
                steps[i] = t.transform(steps[i]);
            }
            result.setCleanupSteps(steps, false);
        }
        finally {
            tcc.popVarScope();
        }
        return result;
    }

    protected String getListElementName() {
        return LIST_ELEMENT_NAME;
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }
}

