/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.cache.SingleVersionedObjectByFullNameCache;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.SingleObjectErrorMapper;
import com.raplix.rolloutexpress.persist.query.SingleObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompleteComponentProcessor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSQLOps;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponentProcessor;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;

public class SingleComponentQuery
extends SingleObjectQueryImpl {
    private static final ComponentSQLOps TABLE = new ComponentSQLOps("compT");

    public static SingleComponentQuery byName(FolderID inPathID, String name, String version) {
        if (inPathID == null) {
            inPathID = FolderID.ROOT_FOLDER_ID;
        }
        String cacheName = null;
        CacheKey cacheKey = null;
        if (version != null) {
            cacheName = "byFullNameAndVersion";
            cacheKey = SingleVersionedObjectByFullNameCache.createKey(inPathID, name, version);
        }
        ConditionalExpression cond = TABLE.isFullNameAndVersion(inPathID, name, version);
        SingleObjectErrorMapper mapper = SingleComponentQuery.getByNameErrorMapper(inPathID, name, version);
        return new SingleComponentQuery(cond, cacheName, cacheKey, mapper);
    }

    public static SingleComponentQuery byRef(ComponentRef ref) {
        return SingleComponentQuery.byName(ref.getPath(), ref.getComponentName(), ref.getComponentVersion());
    }

    private SingleComponentQuery(ConditionalExpression whereCondition, String cacheName, CacheKey cacheKey, SingleObjectErrorMapper errorMapper) {
        super(TABLE, whereCondition, cacheName, cacheKey, errorMapper);
    }

    SingleComponentQuery(ComponentID ID2) {
        super((Table)TABLE, ID2);
    }

    public Component select() throws RPCException, PersistenceManagerException {
        return this.select(false);
    }

    private Component select(boolean createReadOnlyView) throws RPCException, PersistenceManagerException {
        CompleteComponentProcessor processor = new CompleteComponentProcessor(this.getTable(), true, createReadOnlyView);
        return (Component)this.select(processor);
    }

    public Component selectReadOnlyView() throws RPCException, PersistenceManagerException {
        return this.select(true);
    }

    public SummaryComponent selectSummaryView() throws RPCException, PersistenceManagerException {
        SummaryComponentProcessor processor = new SummaryComponentProcessor(this.getTable(), true);
        return (SummaryComponent)this.select(processor);
    }
}

