/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigParser;
import com.raplix.rolloutexpress.config.ConfigTemplate;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallScopeBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDescriptor;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDescriptorList;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.util.ObjectUtil;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class ResourceSelector
implements RPCSerializable {
    private ComponentID mInheritedID = null;
    private ComponentID mLastUsedID = null;
    private ComponentID mRecommendedID;
    private Component[] mAll;
    private int mCurrent = -1;
    private int mLatest;
    private int mInherited;
    private int mRecommended;
    private int mLastUsed;
    private int mDefault;
    private Hashtable mVersionMap = new Hashtable();
    private Hashtable mIDMap = new Hashtable();
    private boolean mIsNew = true;
    private boolean mIsInherited = false;
    private boolean mIsReadOnly = false;
    private boolean mIsLocalDecl = true;
    private VariableSettingsSource mDefaultOverrides;
    private String mName;
    private Modifier mModifier = null;
    private ComponentType mLocalType = null;
    private ComponentType mType = null;
    private InstallMode mInstallMode;
    private VarDescriptorList mOverrideList;
    private Hashtable mOverrideMap = new Hashtable();
    private Component mDeclarer;
    public static final int UNDEFINED = -1;
    private static final ConfigParser CONFIG_PARSER = new ConfigParser();

    private ResourceSelector() {
    }

    ResourceSelector(ComponentRefDecl compRef, Component declarer) throws PersistenceManagerException, RPCException {
        SummaryComponent comp;
        this.initDeclarerAndTypes(declarer, compRef.getLocalType());
        ComponentRefDecl inheritedRef = null;
        if (declarer == compRef.getDeclaringComponent()) {
            inheritedRef = compRef.getOverriddenCompRef();
            this.mModifier = compRef.getModifier();
            this.mIsLocalDecl = true;
            this.setIsReadOnly(false);
            this.initOverrideMap(compRef);
        } else {
            inheritedRef = compRef;
            this.mModifier = null;
            this.mIsLocalDecl = false;
            this.setIsReadOnly(Modifier.FINAL.equals(compRef.getModifier()));
        }
        if (inheritedRef != null) {
            this.setIsInherited(true);
            comp = inheritedRef.getComponent();
            if (comp != null) {
                this.mInheritedID = comp.getID();
            }
        }
        this.initDefaultOverrides(inheritedRef);
        this.setName(compRef.getName());
        this.setInstallMode(compRef.getInstallMode());
        this.mIsNew = false;
        comp = compRef.getComponent();
        if (comp != null) {
            this.mLastUsedID = comp.getID();
        }
        this.reset(this.mLastUsedID);
    }

    ResourceSelector(ComponentID compID, Component declarer) throws PersistenceManagerException, RPCException {
        this.initDeclarerAndTypes(declarer, null);
        this.setName("");
        this.setInstallMode(InstallMode.NESTED);
        this.initDefaultOverrides(null);
        this.reset(compID);
    }

    private void initDeclarerAndTypes(Component declarer, ComponentType refType) {
        this.mDeclarer = declarer;
        this.mLocalType = refType;
        ComponentType listType = declarer.getCompRefListType();
        this.mType = refType == null ? listType : (listType.isInstanceOf(refType) ? listType : refType);
    }

    private void initOverrideMap(ComponentRefDecl compRef) {
        VariableSettingsSource args = compRef.getOverrideArgs();
        String[] names = args.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            this.mOverrideMap.put(names[i], args.getVarValue(names[i]));
        }
    }

    private void initDefaultOverrides(ComponentRefDecl compRef) throws PersistenceManagerException {
        VariableSettingsHolder defaults = new VariableSettingsHolder();
        if (compRef != null) {
            try {
                compRef.resolveOverrideArgs(null, defaults, true);
            }
            catch (ConfigGenException e) {
                throw new PersistenceManagerException(e);
            }
        }
        this.mDefaultOverrides = defaults;
    }

    public boolean isInherited() {
        return this.mIsInherited;
    }

    private void setIsInherited(boolean isInherited) {
        this.mIsInherited = isInherited;
    }

    public boolean isReadOnly() {
        return this.mIsReadOnly;
    }

    private void setIsReadOnly(boolean isReadOnly) {
        this.mIsReadOnly = isReadOnly;
    }

    public ComponentType getType() {
        return this.mType;
    }

    public boolean isNew() {
        return this.mIsNew;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        if (!this.isNew()) {
            throw new IllegalArgumentException("not new");
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.mName = name;
    }

    public InstallMode getInstallMode() {
        return this.mInstallMode;
    }

    public void setInstallMode(InstallMode installMode) {
        if (!this.isNew()) {
            throw new IllegalArgumentException("not new");
        }
        if (installMode == null) {
            throw new NullPointerException();
        }
        this.mInstallMode = installMode;
    }

    public void reset(ComponentID newCompID) throws PersistenceManagerException, RPCException {
        this.mRecommendedID = newCompID;
        this.refresh();
    }

    public void refresh() throws PersistenceManagerException, RPCException {
        Component current = this.getCurrent();
        this.mAll = this.mRecommendedID == null ? new Component[0] : MultiComponentQuery.allVersionsOf(this.mRecommendedID).select();
        this.mIDMap.clear();
        this.mVersionMap.clear();
        for (int i = 0; i < this.mAll.length; ++i) {
            Integer ndx = new Integer(i);
            this.mIDMap.put(this.mAll[i].getID(), ndx);
            this.mVersionMap.put(this.mAll[i].getVersionNumber(), ndx);
        }
        this.mLatest = this.mAll.length > 0 ? 0 : -1;
        this.mRecommended = this.getIndexOfComponentID(this.mRecommendedID);
        this.mLastUsed = this.getIndexOfComponentID(this.mLastUsedID);
        this.mInherited = this.getIndexOfComponentID(this.mInheritedID);
        this.mDefault = this.mRecommended != -1 ? this.mRecommended : this.mLatest;
        if (current == null) {
            this.mCurrent = this.mDefault;
        } else {
            this.mCurrent = this.getIndexOfComponentID(current.getID());
            if (this.mCurrent == -1) {
                this.mCurrent = this.mDefault;
            }
        }
        this.refreshOverrideList(current);
    }

    private void refreshOverrideList(Component origComp) {
        Component curComp = this.getCurrent();
        if (curComp != null && origComp != null && curComp.getID().equals(origComp.getID())) {
            return;
        }
        this.mOverrideList = this.createOverrideList(curComp, this.mOverrideMap, true);
    }

    private VarDescriptorList createOverrideList(Component curComp, Hashtable overrideMap, boolean includeCompDefault) {
        this.updateOverrideMap(overrideMap);
        VarDescriptorList newList = new VarDescriptorList();
        if (curComp != null) {
            CallSpec cs = new CallSpec(new Caller(null, this.mDeclarer), null);
            VarDecl[] vars = curComp.getVarList(cs);
            for (int i = 0; i < vars.length; ++i) {
                if (Modifier.FINAL.equals(vars[i].getModifier()) || vars[i].getAccessMode().isMoreRestrictiveThan(AccessMode.PROTECTED)) continue;
                String name = vars[i].getName();
                String defaultValue = this.mDefaultOverrides.getVarValue(name);
                if (defaultValue == null && includeCompDefault) {
                    defaultValue = vars[i].getDefaultValue();
                }
                VarDescriptor var = new VarDescriptor(name, defaultValue);
                var.setOverrideValue((String)overrideMap.get(name));
                newList.add(var);
            }
        }
        return newList;
    }

    private void updateOverrideMap(Hashtable overrideMap) {
        VarDescriptorList varList = this.getCompVarOverrideList();
        if (varList == null) {
            return;
        }
        Iterator vars = varList.iterator();
        while (vars.hasNext()) {
            VarDescriptor var = (VarDescriptor)vars.next();
            String override = var.getOverrideValue();
            if (override == null) {
                overrideMap.remove(var.getName());
                continue;
            }
            overrideMap.put(var.getName(), override);
        }
    }

    public Component[] getAll() {
        return this.mAll;
    }

    public int getIndexOfCurrent() {
        return this.mCurrent;
    }

    public void setIndexOfCurrent(int ndx) {
        if (ndx < 0 || ndx >= this.mAll.length) {
            throw new IndexOutOfBoundsException(String.valueOf(ndx));
        }
        Component orig = this.getCurrent();
        this.mCurrent = ndx;
        this.refreshOverrideList(orig);
    }

    public Component getCurrent() {
        return this.mCurrent == -1 ? null : this.mAll[this.mCurrent];
    }

    public int getIndexOfLatest() {
        return this.mLatest;
    }

    public int getIndexOfRecommended() {
        return this.mRecommended;
    }

    public int getIndexOfLastUsed() {
        return this.mLastUsed;
    }

    public int getIndexOfInherited() {
        return this.mInherited;
    }

    public int getIndexOfDefault() {
        return this.mDefault;
    }

    public int getIndexOfVersion(VersionNumber version) {
        if (version == null) {
            return -1;
        }
        Integer ndx = (Integer)this.mVersionMap.get(version);
        if (ndx == null) {
            return -1;
        }
        return ndx;
    }

    public int getIndexOfComponentID(ComponentID ID2) {
        if (ID2 == null) {
            return -1;
        }
        Integer ndx = (Integer)this.mIDMap.get(ID2);
        if (ndx == null) {
            return -1;
        }
        return ndx;
    }

    public VarDescriptorList getCompVarOverrideList() {
        return this.mOverrideList;
    }

    ComponentRefDecl generateComponentRefDecl() {
        if (this.isReadOnly()) {
            return null;
        }
        VariableSettingsSource overrides = this.getCompVarOverrideList().toVariableSettingsSource();
        if (!this.isModified(overrides, this.getCurrent())) {
            return null;
        }
        return new ComponentRefDecl(this.mModifier, this.getName(), this.getInstallMode(), this.mLocalType, overrides, this.getCurrent());
    }

    private boolean isModified(VariableSettingsSource overrides, Component comp) {
        ComponentID compID;
        if (this.mIsLocalDecl) {
            return true;
        }
        ComponentID componentID = compID = comp == null ? null : comp.getID();
        if (!ObjectUtil.equals(compID, this.mInheritedID)) {
            return true;
        }
        return overrides.getVarNames().length > 0;
    }

    public static HashSet getContainerVars(ComponentID compID, ResourceSelector selectorToReset) throws PersistenceManagerException, RPCException {
        LinkedHashSet result = new LinkedHashSet();
        Component comp = compID.getByIDQuery().select();
        HashSet overriddenVars = ResourceSelector.computeOverrides(selectorToReset, comp);
        for (Component cur = comp; cur != null; cur = cur.getBaseComponent()) {
            ResourceSelector.addContainerVars(result, cur.getLocalVarList(), overriddenVars);
            ResourceSelector.addContainerVars(result, cur.getLocalInstallList());
            ResourceSelector.addContainerVars(result, cur.getLocalUninstallList());
            ResourceSelector.addContainerVars(result, cur.getLocalSnapshotList());
            ResourceSelector.addContainerVars(result, cur.getLocalControlList());
        }
        return result;
    }

    private static HashSet computeOverrides(ResourceSelector resSel, Component comp) {
        HashSet<String> result = new HashSet<String>();
        if (resSel != null) {
            Hashtable overrideMap = (Hashtable)resSel.mOverrideMap.clone();
            VarDescriptorList overrideList = resSel.createOverrideList(comp, overrideMap, false);
            int numVars = overrideList.size();
            for (int i = 0; i < overrideList.size(); ++i) {
                VarDescriptor var = overrideList.getVar(i);
                if (var.getDefaultValue() == null && var.getOverrideValue() == null) continue;
                result.add(var.getName());
            }
        }
        return result;
    }

    private static void addContainerVars(HashSet containerVarSet, VarDecl[] vars, HashSet overriddenVars) {
        for (int i = 0; i < vars.length; ++i) {
            String varName = vars[i].getName();
            if (!overriddenVars.contains(varName)) {
                HashSet containerVars = ResourceSelector.getContainerVars(vars[i].getDefaultValue());
                containerVarSet.addAll(containerVars);
            }
            if (vars[i].getOverriddenVarDecl() == null) {
                overriddenVars.remove(varName);
                continue;
            }
            overriddenVars.add(varName);
        }
    }

    private static void addContainerVars(HashSet result, CallScopeBlock[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            ResourceSelector.addContainerVars(result, blocks[i].getParams());
            ResourceSelector.addContainerVars(result, blocks[i].getLocalVars());
        }
    }

    private static void addContainerVars(HashSet result, VariableSettingsSource vars) {
        String[] varNames = vars.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            String varValue = vars.getVarValue(varNames[i]);
            HashSet containerVars = ResourceSelector.getContainerVars(varValue);
            if (containerVars == null) continue;
            result.addAll(containerVars);
        }
    }

    private static HashSet getContainerVars(String varValue) {
        if (varValue != null) {
            try {
                ConfigTemplate template = CONFIG_PARSER.createNestedTemplate(varValue);
                return template.getPrimaryContainerVarNames();
            }
            catch (ConfigGenException configGenException) {
                // empty catch block
            }
        }
        return null;
    }
}

