/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.command.exceptions.PathDoesNotExistException;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.util.enum.NoSuchEnumException;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class ResourceDefinition
extends XMLUtil
implements RPCSerializable,
Cloneable {
    public static final String ELEMENT_NAME = "installSpec";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_PERMISSIONS = "permissions";
    private static final String ATTR_USER = "user";
    private static final String ATTR_GROUP = "group";
    private static final String ATTR_DEPLOY_MODE = "deployMode";
    private static final String ATTR_DIFF_DEPLOY = "diffDeploy";
    public static final int NO_PERMISSIONS_SET = -1;
    public static final int PERMISSIONS_RADIX = 8;
    private String mInstallName;
    private String mInstallPath;
    private String mFullTargetPath;
    private String mRAFullTargetPath;
    private String mInstallPermissions;
    private int mInstallPermissionsAsOctalInt = -1;
    private String mInstallUser;
    private String mInstallGroup;
    private transient Component mDeclaringComp;
    private String mDeployModeStr;
    private DeployMode mDeployMode;
    private String mDiffDeployStr;
    private boolean[] mDiffDeploy;

    public ResourceDefinition() {
    }

    public ResourceDefinition(String inInstallName, String inInstallPath, String inInstallPermissions) {
        this.mInstallName = inInstallName;
        this.mInstallPath = inInstallPath;
        this.setInstallPermissions(inInstallPermissions);
        this.mInstallUser = "";
        this.mInstallGroup = "";
    }

    public ResourceDefinition(Element inElement) {
        this.mInstallName = inElement.getAttribute(ATTR_NAME);
        this.mInstallPath = inElement.getAttribute(ATTR_PATH);
        this.setInstallPermissions(inElement.getAttribute(ATTR_PERMISSIONS));
        this.mInstallUser = inElement.getAttribute(ATTR_USER);
        this.mInstallGroup = inElement.getAttribute(ATTR_GROUP);
        this.setDeployModeString(ResourceDefinition.getAttribute(inElement, ATTR_DEPLOY_MODE));
        this.setDifferentialDeployString(ResourceDefinition.getAttribute(inElement, ATTR_DIFF_DEPLOY));
    }

    public Component getDeclaringComponent() {
        return this.mDeclaringComp;
    }

    void setDeclaringComponent(Component comp) {
        this.mDeclaringComp = comp;
    }

    public String getInstallName() {
        return this.mInstallName;
    }

    public void setInstallName(String inValue) {
        this.mInstallName = inValue;
    }

    public String getInstallPath() {
        return this.mInstallPath;
    }

    public void setInstallPath(String inValue) {
        this.mInstallPath = inValue;
    }

    public String getFullTargetPath() {
        return this.mFullTargetPath;
    }

    private void setFullTargetPath(String fullTargetPath) {
        this.mFullTargetPath = fullTargetPath;
    }

    public String getRAFullTargetPath() {
        return this.mRAFullTargetPath;
    }

    private void setRAFullTargetPath(String fullTargetPath) {
        this.mRAFullTargetPath = fullTargetPath;
    }

    public String getInstallPermissions() {
        return this.mInstallPermissions;
    }

    public void setInstallPermissions(String inValue) {
        this.mInstallPermissions = inValue;
    }

    public int getInstallPermissionsAsOctalInt() {
        return this.mInstallPermissionsAsOctalInt;
    }

    private void setInstallPermissionsAsInt(int perms) {
        this.mInstallPermissionsAsOctalInt = perms;
    }

    public String getInstallUser() {
        return this.mInstallUser;
    }

    public void setInstallUser(String inValue) {
        this.mInstallUser = inValue;
    }

    public String getInstallGroup() {
        return this.mInstallGroup;
    }

    public void setInstallGroup(String inValue) {
        this.mInstallGroup = inValue;
    }

    public String getDeployModeString() {
        return this.mDeployModeStr;
    }

    public void setDeployModeString(String deployMode) {
        this.mDeployModeStr = deployMode;
    }

    public DeployMode getDeployMode() {
        return this.mDeployMode;
    }

    private void setDeployMode(DeployMode deployMode) {
        this.mDeployMode = deployMode;
    }

    public String getDifferentialDeployString() {
        return this.mDiffDeployStr;
    }

    public void setDifferentialDeployString(String diffDeploy) {
        this.mDiffDeployStr = diffDeploy;
    }

    public Boolean getDifferentialDeploy() {
        return this.mDiffDeploy == null ? null : new Boolean(this.mDiffDeploy[0]);
    }

    private void setDifferentialDeploy(boolean diffDeploy) {
        this.mDiffDeploy = new boolean[]{diffDeploy};
    }

    public void writeToXML(XML outXML) {
        XML thisElement = new XML(ELEMENT_NAME);
        thisElement.setPrettyPrint(true);
        ResourceDefinition.addAttributeIfNotNull(thisElement, ATTR_NAME, this.mInstallName);
        if (this.mInstallPath != null && !this.mInstallPath.equals("")) {
            ResourceDefinition.addAttributeIfNotNull(thisElement, ATTR_PATH, this.mInstallPath);
        }
        if (this.mInstallPermissions != null && !this.mInstallPermissions.equals("")) {
            ResourceDefinition.addAttributeIfNotNull(thisElement, ATTR_PERMISSIONS, this.mInstallPermissions);
        }
        if (this.mInstallUser != null && !this.mInstallUser.equals("")) {
            ResourceDefinition.addAttributeIfNotNull(thisElement, ATTR_USER, this.mInstallUser);
        }
        if (this.mInstallGroup != null && !this.mInstallGroup.equals("")) {
            ResourceDefinition.addAttributeIfNotNull(thisElement, ATTR_GROUP, this.mInstallGroup);
        }
        ResourceDefinition.addAttributeIfNotNull(thisElement, ATTR_DEPLOY_MODE, this.getDeployModeString());
        ResourceDefinition.addAttributeIfNotNull(thisElement, ATTR_DIFF_DEPLOY, this.getDifferentialDeployString());
        outXML.addElement((org.apache.ecs.Element)thisElement);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof ResourceDefinition)) {
            return false;
        }
        return this.equals((ResourceDefinition)other);
    }

    public boolean equals(ResourceDefinition inResource) {
        if (!this.mInstallName.equals(inResource.getInstallName())) {
            return false;
        }
        if (!this.equals(this.mInstallPath, inResource.getInstallPath())) {
            return false;
        }
        if (!this.equals(this.mInstallPermissions, inResource.getInstallPermissions())) {
            return false;
        }
        if (!this.equals(this.mInstallUser, inResource.getInstallUser())) {
            return false;
        }
        if (!this.equals(this.mInstallGroup, inResource.getInstallGroup())) {
            return false;
        }
        if (!this.equals(this.getDeployModeString(), inResource.getDeployModeString())) {
            return false;
        }
        return this.equals(this.getDifferentialDeployString(), inResource.getDifferentialDeployString());
    }

    private boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResourceDefinition generate(ComponentConfigManager configMgr, Component comp, MachineInfo mi) throws ConfigGenException, ComponentDBException, PathDoesNotExistException {
        boolean diffDeploy;
        DeployMode deployMode;
        Component declComp = this.getDeclaringComponent();
        if (declComp == null) {
            declComp = comp;
        }
        Caller caller = new Caller(null, declComp);
        ConfigGenerator generator = configMgr.newCallerScope(caller);
        String installPath = generator.generate(this.getInstallPath());
        String installPermissions = generator.generate(this.getInstallPermissions());
        ResourceDefinition result = (ResourceDefinition)this.clone();
        result.setInstallName(generator.generate(result.getInstallName()));
        result.setInstallPath(installPath);
        result.setInstallPermissions(installPermissions);
        if (installPermissions != null && !installPermissions.equals("")) {
            try {
                int intPerms = Integer.parseInt(installPermissions, 8);
                result.setInstallPermissionsAsInt(intPerms);
            }
            catch (NumberFormatException e) {
                throw ComponentDBException.invalidRsrcPermissions(declComp, installPermissions);
            }
        }
        result.setInstallGroup(generator.generate(this.getInstallGroup()));
        result.setInstallUser(generator.generate(this.getInstallUser()));
        String compInstallPath = comp.getInstallPath(configMgr);
        String fullTargetPath = FileSpec.getFullTargetPath(compInstallPath, result, mi);
        result.setFullTargetPath(fullTargetPath);
        result.setRAFullTargetPath(mi.toRAPath(fullTargetPath));
        String deployModeStr = result.getDeployModeString();
        if (deployModeStr != null) {
            deployModeStr = generator.generate(deployModeStr);
            result.setDeployModeString(deployModeStr);
            try {
                deployMode = DeployMode.FACTORY.get(deployModeStr);
            }
            catch (NoSuchEnumException e) {
                throw ComponentDBException.invalidRsrcDeployMode(declComp, deployModeStr);
            }
        } else {
            deployMode = DeployMode.REPLACE;
        }
        result.setDeployMode(deployMode);
        String diffDeployStr = result.getDifferentialDeployString();
        if (diffDeployStr != null) {
            diffDeployStr = generator.generate(diffDeployStr);
            result.setDifferentialDeployString(diffDeployStr);
            if ("true".equalsIgnoreCase(diffDeployStr)) {
                diffDeploy = true;
            } else {
                if (!"false".equalsIgnoreCase(diffDeployStr)) throw ComponentDBException.invalidRsrcDiffDeploy(declComp, diffDeployStr);
                diffDeploy = false;
            }
        } else {
            diffDeploy = false;
        }
        result.setDifferentialDeploy(diffDeploy);
        return result;
    }

    public Object clone() {
        try {
            ResourceDefinition result = (ResourceDefinition)super.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void accept(CompDBVisitor v) throws Exception {
        v.visitToken(this.getInstallPath());
        v.visitToken(this.getInstallPermissions());
        v.visitToken(this.getInstallName());
        v.visitToken(this.getInstallGroup());
        v.visitToken(this.getInstallUser());
        v.visitToken(this.getDeployModeString());
        v.visitToken(this.getDifferentialDeployString());
    }

    ResourceDefinition accept(CompDBTransformer t) throws Exception {
        ResourceDefinition rd = t.clone(this);
        rd.setInstallPath(t.transformToken(rd.getInstallPath()));
        rd.setInstallPermissions(t.transformToken(rd.getInstallPermissions()));
        rd.setInstallName(t.transformToken(rd.getInstallName()));
        rd.setInstallGroup(t.transformToken(rd.getInstallGroup()));
        rd.setInstallUser(t.transformToken(rd.getInstallUser()));
        rd.setDeployModeString(t.transformToken(rd.getDeployModeString()));
        rd.setDifferentialDeployString(t.transformToken(rd.getDifferentialDeployString()));
        return rd;
    }

    ResourceDefinition cloneForTransform() {
        return (ResourceDefinition)this.clone();
    }
}

