/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.TokenCallContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallScopeBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberBase;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.plandb.VarList;
import com.raplix.util.ObjectUtil;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Set;
import java.util.Vector;
import org.apache.ecs.xml.XML;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.w3c.dom.Element;

public abstract class NamedBlock
extends ComponentMemberBase
implements CallScopeBlock {
    private static final String ATTR_DESC = "description";
    private static final String ATTR_RETURNS = "returns";
    private String mDescription;
    private boolean mReturns = false;
    private PromptParamList mParams;
    private VarList mLocalVars;
    private Vector mSteps = new Vector();

    NamedBlock() {
    }

    NamedBlock(String inName, String inDescription) {
        this(inName, inDescription, null, null);
    }

    NamedBlock(String name, String description, PromptParamList params, VariableSettingsSource localVars) {
        this(null, null, name, description, params, localVars);
    }

    NamedBlock(AccessMode accessMode, Modifier modifier, String name, String description, PromptParamList params, VariableSettingsSource localVars) {
        this(accessMode, modifier, name, description, params, localVars, false);
    }

    NamedBlock(AccessMode accessMode, Modifier modifier, String name, String description, PromptParamList params, VariableSettingsSource localVars, boolean returns) {
        super(accessMode, modifier, name);
        this.setDescription(description);
        this.setAndCloneParams(params);
        this.setLocalVars(localVars);
        this.setReturns(returns);
    }

    NamedBlock(Element controlElement) throws SystemModelParseException {
        this(controlElement, ExecStep.DEFAULT_BLOCK_IGNORES);
    }

    NamedBlock(Element controlElement, Set stepElemIgnoreList) throws SystemModelParseException {
        super(controlElement, null);
        this.setDescription(XMLUtil.getAttribute(controlElement, ATTR_DESC));
        String returnsAttrib = XMLUtil.getAttribute(controlElement, ATTR_RETURNS);
        if (returnsAttrib != null) {
            this.setReturns(returnsAttrib.equalsIgnoreCase(new String("true")));
        }
        this.setParams(new PromptParamList(controlElement));
        this.setLocalVars(new VarList(controlElement, this.mParams));
        ExecStep.parseExecSteps(controlElement, this.mSteps, stepElemIgnoreList);
    }

    public String getDescription() {
        return this.mDescription;
    }

    private void setDescription(String inValue) {
        this.mDescription = inValue;
    }

    public boolean getReturns() {
        return this.mReturns;
    }

    private void setReturns(boolean inValue) {
        this.mReturns = inValue;
    }

    public PromptParamList getParams() {
        return (PromptParamList)this.mParams.clone();
    }

    private void setAndCloneParams(PromptParamList params) {
        params = params == null ? new PromptParamList() : (PromptParamList)params.clone();
        this.setParams(params);
    }

    private void setParams(PromptParamList params) {
        this.mParams = params;
    }

    public VariableSettingsSource getLocalVars() {
        return (VariableSettingsSource)this.mLocalVars.clone();
    }

    private void setLocalVars(VariableSettingsSource localVars) {
        if (localVars == null) {
            this.setLocalVars(new VarList());
        } else {
            this.setLocalVars(new VarList(localVars));
        }
    }

    private void setLocalVars(VarList localVars) {
        this.mLocalVars = localVars;
    }

    public void addExecStep(ExecStep inStep) {
        this.mSteps.addElement(inStep);
    }

    public ExecStep[] getExecSteps() {
        return this.mSteps.toArray(new ExecStep[this.mSteps.size()]);
    }

    public void setExecSteps(ExecStep[] steps) {
        this.mSteps.clear();
        if (steps != null) {
            this.mSteps.addAll(Arrays.asList(steps));
        }
    }

    public ExecStep[] getStepsOfType(Class stepType) {
        Vector<ExecStep> result = new Vector<ExecStep>();
        for (int i = 0; i < this.mSteps.size(); ++i) {
            ExecStep theStep = (ExecStep)this.mSteps.elementAt(i);
            if (!stepType.isInstance(theStep)) continue;
            result.add(theStep);
        }
        Object[] arr = (Object[])Array.newInstance(stepType, result.size());
        return (ExecStep[])result.toArray(arr);
    }

    protected void populateXML(XML outXML, boolean isInternal) {
        XMLUtil.addAttributeIfNotNull(outXML, ATTR_DESC, this.getDescription());
        Boolean returnsBool = new Boolean(this.getReturns());
        XMLUtil.addAttributeIfNotNull(outXML, ATTR_RETURNS, returnsBool.toString());
        this.mParams.writeToXML(outXML);
        this.mLocalVars.writeToXML(outXML);
        this.writeStepsToXML(outXML);
    }

    protected void writeStepsToXML(XML outXML) {
        for (int i = 0; i < this.mSteps.size(); ++i) {
            ExecStep theStep = (ExecStep)this.mSteps.elementAt(i);
            theStep.writeToXML(outXML);
        }
    }

    protected void validateName(String name) throws SystemModelParseException, InvalidDatatypeValueException {
        XMLUtil.validateEntityName(name);
    }

    protected void validate(Component declarer) throws ComponentDBException, PlanDBException {
        NamedBlock overridden;
        super.validate(declarer);
        if (Modifier.ABSTRACT.equals(this.getModifier())) {
            if (!this.hasEmptyBody()) {
                throw ComponentDBException.nonEmptyAbstractBlock(this);
            }
        } else {
            Caller caller = new Caller(null, declarer);
            this.validateSteps(caller);
        }
        if ((overridden = (NamedBlock)this.getOverriddenMember(declarer)) != null) {
            this.validateCompatibleParams(this.mParams, overridden.mParams);
        }
    }

    protected boolean hasEmptyBody() {
        return this.mLocalVars.size() == 0 && this.mSteps.size() == 0;
    }

    protected void validateSteps(Caller container) throws PlanDBException {
        ExecStep.validateSteps(this.mSteps, container);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof NamedBlock) {
            return this.equalsData((NamedBlock)other);
        }
        return false;
    }

    public boolean equalsData(NamedBlock other) {
        return ObjectUtil.equals(this.getName(), other.getName()) && ObjectUtil.equals(this.getAccessMode(), other.getAccessMode()) && ObjectUtil.equals(this.getModifier(), other.getModifier()) && ObjectUtil.equals(this.getDescription(), other.getDescription()) && ObjectUtil.equals(this.mParams, other.mParams) && ObjectUtil.equals(this.mLocalVars, other.mLocalVars) && ObjectUtil.equals(this.mSteps, other.mSteps);
    }

    public Object clone() {
        NamedBlock result = (NamedBlock)super.clone();
        result.mSteps = ExecStep.deepClone(result.mSteps);
        return result;
    }

    void acceptSteps(CompDBVisitor v) throws Exception {
        ExecStep[] steps = this.mSteps.toArray(new ExecStep[this.mSteps.size()]);
        v.visit(steps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void accept(CompDBVisitor v) throws Exception {
        TokenCallContext tcc = v.getTokenCallContext();
        super.accept(v);
        tcc.pushVarScope();
        try {
            tcc.enterBlockVarContext();
            try {
                v.visit(this.mParams);
                v.visit(this.mLocalVars);
            }
            finally {
                tcc.exitContext();
            }
            this.acceptSteps(v);
        }
        finally {
            tcc.popVarScope();
        }
    }

    void acceptSteps(CompDBTransformer t, NamedBlock result) throws Exception {
        for (int i = 0; i < this.mSteps.size(); ++i) {
            result.mSteps.set(i, t.transform((ExecStep)this.mSteps.get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentMemberBase accept(CompDBTransformer t) throws Exception {
        TokenCallContext tcc = t.getTokenCallContext();
        NamedBlock result = (NamedBlock)super.accept(t);
        tcc.pushVarScope();
        try {
            tcc.enterBlockVarContext();
            try {
                result.mParams = t.transform(this.mParams);
                result.mLocalVars = (VarList)t.transform(this.mLocalVars);
            }
            finally {
                tcc.exitContext();
            }
            this.acceptSteps(t, result);
        }
        finally {
            tcc.popVarScope();
        }
        return result;
    }
}

