/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefOrder;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefProcessor;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;

public class MultiSystemServiceRefQuery
extends MultiObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final SystemServiceRefSQLOps TABLE = new SystemServiceRefSQLOps("ssrT");

    public static MultiSystemServiceRefQuery all() {
        MultiSystemServiceRefQuery result = new MultiSystemServiceRefQuery((ConditionalExpression)null);
        result.setObjectOrder(SystemServiceRefOrder.BY_NAME_ASC);
        return result;
    }

    public static MultiSystemServiceRefQuery byUninstalled(HostID host) throws RPCException, PersistenceManagerException {
        MultiSystemServiceRefQuery result = new MultiSystemServiceRefQuery(TABLE.isNotInstalledOn(host));
        return result;
    }

    static MultiSystemServiceRefQuery byComponent(ComponentID comp) {
        MultiSystemServiceRefQuery result = new MultiSystemServiceRefQuery(TABLE.refsComponent(comp));
        return result;
    }

    static MultiSystemServiceRefQuery byIDs(SystemServiceRefID[] ids) {
        MultiSystemServiceRefQuery result = new MultiSystemServiceRefQuery(ids);
        return result;
    }

    private MultiSystemServiceRefQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, SystemServiceRefOrder.FACTORY);
    }

    private MultiSystemServiceRefQuery(SystemServiceRefID[] IDs) {
        super((Table)TABLE, IDs, SystemServiceRefOrder.FACTORY);
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((SystemServiceRefOrder)order);
    }

    public SystemServiceRef[] select() throws RPCException, PersistenceManagerException {
        return (SystemServiceRef[])this.select(new SystemServiceRefProcessor(this.getTable(), false), SystemServiceRef.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.select();
    }
}

