/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsOrder;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsProcessor;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsSQLOps;

public class MultiComponentVariableSettingsQuery
extends MultiObjectQueryImpl {
    private static final ComponentVariableSettingsSQLOps TABLE = new ComponentVariableSettingsSQLOps("cvsT");

    static MultiComponentVariableSettingsQuery byComp(ComponentID compID) {
        MultiComponentVariableSettingsQuery result = new MultiComponentVariableSettingsQuery(TABLE.isInComp(compID));
        result.setObjectOrder(ComponentVariableSettingsOrder.BY_NAME_ASC);
        return result;
    }

    static MultiComponentVariableSettingsQuery byComps(ComponentIDSet comps) {
        ConditionalExpression cond = TABLE.isInComps(comps.toIDArray());
        MultiComponentVariableSettingsQuery result = new MultiComponentVariableSettingsQuery(cond);
        result.setObjectOrder(ComponentVariableSettingsOrder.BY_COMP_ASC);
        return result;
    }

    private MultiComponentVariableSettingsQuery(ConditionalExpression cond) {
        super((Table)TABLE, cond, ComponentVariableSettingsOrder.FACTORY);
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((ComponentVariableSettingsOrder)order);
    }

    public ComponentVariableSettings[] select() throws RPCException, PersistenceManagerException {
        ComponentVariableSettingsProcessor processor = new ComponentVariableSettingsProcessor(this.getTable(), false);
        return (ComponentVariableSettings[])this.select(processor, ComponentVariableSettings.class);
    }

    static MultiComponentVariableSettingsQuery byIDs(ComponentVariableSettingsID[] ids) {
        MultiComponentVariableSettingsQuery result = new MultiComponentVariableSettingsQuery(ids);
        return result;
    }

    private MultiComponentVariableSettingsQuery(ComponentVariableSettingsID[] IDs) {
        super((Table)TABLE, IDs, ComponentVariableSettingsOrder.FACTORY);
    }
}

